/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature.comparison;

import gov.sandia.cognition.learning.algorithm.bayes.VectorNaiveBayesCategorizer;
import gov.sandia.cognition.statistics.DataHistogram;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.local.matcher.BasicTwoWayMatcher;
import org.openimaj.feature.local.matcher.LocalFeatureMatcher;
import org.openimaj.feature.local.matcher.consistent.ConsistentLocalFeatureMatcher2d;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.image.processing.face.feature.DoGSIFTFeature;
import org.openimaj.image.processing.face.feature.comparison.FacialFeatureComparator;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.transforms.NullModel;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.geometry.transforms.residuals.TransformedSITR2d;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.math.model.Model;
import org.openimaj.math.model.UnivariateGaussianNaiveBayesModel;
import org.openimaj.math.model.fit.RobustModelFitting;
import org.openimaj.math.model.fit.SimpleModelFitting;
import org.openimaj.math.model.fit.residuals.ResidualCalculator;
import org.openimaj.math.util.distance.DistanceCheck;
import org.openimaj.math.util.distance.ModelDistanceCheck;
import org.openimaj.util.pair.Pair;

@Reference(type=ReferenceType.Inproceedings, author={"Ozkan, Derya", "Duygulu, Pinar"}, title="Finding people frequently appearing in news", year="2006", booktitle="Proceedings of the 5th international conference on Image and Video Retrieval", pages={"173", "", "182"}, url="http://dx.doi.org/10.1007/11788034_18", publisher="Springer-Verlag", series="CIVR'06", customData={"isbn", "3-540-36018-2, 978-3-540-36018-6", "location", "Tempe, AZ", "numpages", "10", "doi", "10.1007/11788034_18", "acmid", "2164555", "address", "Berlin, Heidelberg"})
public class DoGSIFTFeatureComparator
implements FacialFeatureComparator<DoGSIFTFeature> {
    public void readBinary(DataInput in) throws IOException {
    }

    public byte[] binaryHeader() {
        return null;
    }

    public void writeBinary(DataOutput out) throws IOException {
    }

    public static ModelDistanceCheck buildDefaultDistanceCheck() {
        MapBasedDataHistogram priors = new MapBasedDataHistogram();
        priors.add((Object)true, 3380);
        priors.add((Object)false, 748);
        HashMap<Boolean, List<UnivariateGaussian.PDF>> conditionals = new HashMap<Boolean, List<UnivariateGaussian.PDF>>();
        conditionals.put(true, Arrays.asList(new UnivariateGaussian.PDF(0.029852218270328083, 0.003255709240977441)));
        conditionals.put(false, Arrays.asList(new UnivariateGaussian.PDF(0.4461058073589149, 0.04829317710091845)));
        VectorNaiveBayesCategorizer bayes = new VectorNaiveBayesCategorizer((DataHistogram)priors, conditionals);
        UnivariateGaussianNaiveBayesModel distanceModel = new UnivariateGaussianNaiveBayesModel(bayes);
        ModelDistanceCheck dc = new ModelDistanceCheck((Model)distanceModel);
        return dc;
    }

    public double compare(DoGSIFTFeature query, DoGSIFTFeature target) {
        Rectangle unit = new Rectangle(0.0f, 0.0f, 1.0f, 1.0f);
        TransformedSITR2d tte = new TransformedSITR2d(TransformUtilities.makeTransform((Rectangle)query.getBounds(), (Rectangle)unit), TransformUtilities.makeTransform((Rectangle)target.getBounds(), (Rectangle)unit));
        ModelDistanceCheck dt = DoGSIFTFeatureComparator.buildDefaultDistanceCheck();
        NullModel model = new NullModel();
        SimpleModelFitting fitting = new SimpleModelFitting((EstimatableModel)model, (ResidualCalculator)tte, (DistanceCheck)dt);
        BasicTwoWayMatcher innerMatcher = new BasicTwoWayMatcher();
        ConsistentLocalFeatureMatcher2d matcher = new ConsistentLocalFeatureMatcher2d((LocalFeatureMatcher)innerMatcher, (RobustModelFitting)fitting);
        matcher.setModelFeatures(target.getKeys());
        matcher.findMatches(query.getKeys());
        double score = 0.0;
        for (Pair p : matcher.getMatches()) {
            double accum = 0.0;
            byte[] v1 = ((Keypoint)p.firstObject()).ivec;
            byte[] v2 = ((Keypoint)p.secondObject()).ivec;
            for (int i = 0; i < v1.length; ++i) {
                double v1i = v1[i];
                double v2i = v2[i];
                accum += (v1i - v2i) * (v1i - v2i);
            }
            score += Math.sqrt(accum);
        }
        if (matcher.getMatches().size() == 0) {
            return Math.sqrt(8323200.0);
        }
        return score / (double)matcher.getMatches().size();
    }

    public boolean isDistance() {
        return true;
    }
}

