/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.model.EigenImages;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.feature.FacialFeature;
import org.openimaj.image.processing.face.feature.FacialFeatureExtractor;
import org.openimaj.io.IOUtils;
import org.openimaj.ml.training.BatchTrainer;

@Reference(type=ReferenceType.Inproceedings, author={"Turk, M.A.", "Pentland, A.P."}, title="Face recognition using eigenfaces", year="1991", booktitle="Computer Vision and Pattern Recognition, 1991. Proceedings CVPR '91., IEEE Computer Society Conference on", pages={"586 ", "591"}, month="jun", number="", volume="", customData={"keywords", "eigenfaces;eigenvectors;face images;face recognition system;face space;feature space;human faces;two-dimensional recognition;unsupervised learning;computerised pattern recognition;eigenvalues and eigenfunctions;", "doi", "10.1109/CVPR.1991.139758"})
public class EigenFaceFeature
implements FacialFeature,
FeatureVectorProvider<DoubleFV> {
    private DoubleFV fv;

    protected EigenFaceFeature() {
        this(null);
    }

    public EigenFaceFeature(DoubleFV fv) {
        this.fv = fv;
    }

    public void readBinary(DataInput in) throws IOException {
        this.fv = new DoubleFV();
        this.fv.readBinary(in);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.fv.writeBinary(out);
    }

    public DoubleFV getFeatureVector() {
        return this.fv;
    }

    public static class Extractor<T extends DetectedFace>
    implements FacialFeatureExtractor<EigenFaceFeature, T>,
    BatchTrainer<T> {
        EigenImages eigen = null;
        FaceAligner<T> aligner = null;

        public Extractor(int numComponents, FaceAligner<T> aligner) {
            this(new EigenImages(numComponents), aligner);
        }

        public Extractor(EigenImages basis, FaceAligner<T> aligner) {
            this.eigen = basis;
            this.aligner = aligner;
        }

        public EigenFaceFeature extractFeature(T face) {
            FImage patch = this.aligner.align(face);
            DoubleFV fv = this.eigen.extractFeature(patch);
            return new EigenFaceFeature(fv);
        }

        public void readBinary(DataInput in) throws IOException {
            this.eigen.readBinary(in);
            String alignerClass = in.readUTF();
            this.aligner = (FaceAligner)IOUtils.newInstance((String)alignerClass);
            this.aligner.readBinary(in);
        }

        public byte[] binaryHeader() {
            return this.getClass().getName().getBytes();
        }

        public void writeBinary(DataOutput out) throws IOException {
            this.eigen.writeBinary(out);
            out.writeUTF(this.aligner.getClass().getName());
            this.aligner.writeBinary(out);
        }

        public void train(final List<? extends T> data) {
            AbstractList<FImage> patches = new AbstractList<FImage>(){

                @Override
                public FImage get(int index) {
                    return Extractor.this.aligner.align((DetectedFace)data.get(index));
                }

                @Override
                public int size() {
                    return data.size();
                }
            };
            this.eigen.train((List)patches);
        }

        public void train(Dataset<? extends T> data) {
            this.train(DatasetAdaptors.asList(data));
        }

        public String toString() {
            return String.format("EigenFaceFeature.Extractor[aligner=%s]", this.aligner);
        }
    }
}

