/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection.keypoints;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.EuclideanDistanceTransform;
import org.openimaj.image.analysis.algorithm.SummedAreaTable;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.image.processing.face.detection.keypoints.FacialKeypoint;
import org.openimaj.image.processing.face.detection.keypoints.MaskedHaarCascade;

@Reference(type=ReferenceType.Inproceedings, author={"Mark Everingham", "Josef Sivic", "Andrew Zisserman"}, title="Hello! My name is... Buffy - Automatic naming of characters in TV video", year="2006", booktitle="In BMVC")
public class FacialKeypointExtractor {
    protected Model model = Model.DEFAULT_MODEL;

    public int getCanonicalImageDimension() {
        return this.model.imgsize;
    }

    public FacialKeypoint[] extractFacialKeypoints(FImage canonicalImage) {
        SummedAreaTable sat = new SummedAreaTable(canonicalImage);
        FImage[] AC = new FImage[9];
        for (int i = 0; i < 9; ++i) {
            FImage map = MaskedHaarCascade.maskedHaarCascade(sat, this.model.winsize, this.model.winsize, this.model.part[i].HCas, this.model.part[i].talpha, this.model.part[i].M);
            AC[i] = map.multiplyInplace(-((float)this.model.appwt));
        }
        return this.findParts(AC);
    }

    protected FacialKeypoint[] findParts(FImage[] AC) {
        float maxconf = Float.NEGATIVE_INFINITY;
        float conf = 0.0f;
        FacialKeypoint[] Pbest = null;
        for (int t = 0; t < this.model.tree.length; ++t) {
            int c;
            int ci;
            FImage[] B = new FImage[this.model.part.length];
            int[][][] argB = new int[this.model.part.length][this.model.imgsize][this.model.imgsize];
            FacialKeypoint[] P = new FacialKeypoint[this.model.part.length];
            for (int i = 0; i < this.model.part.length; ++i) {
                P[i] = new FacialKeypoint(FacialKeypoint.FacialKeypointType.valueOf(i));
            }
            for (ci = this.model.tree[t].depthorder.length - 1; ci >= 0; --ci) {
                c = this.model.tree[t].depthorder[ci];
                int[] off = this.model.tree[t].MU[c];
                int[] bb = new int[4];
                if (off[0] >= 0) {
                    bb[0] = 0;
                    bb[1] = this.model.imgsize - off[0] - 1;
                } else {
                    bb[0] = -off[0];
                    bb[1] = this.model.imgsize - 1;
                }
                if (off[1] >= 0) {
                    bb[2] = 0;
                    bb[3] = this.model.imgsize - off[1] - 1;
                } else {
                    bb[2] = -off[1];
                    bb[3] = this.model.imgsize - 1;
                }
                FImage C = new FImage(this.model.imgsize, this.model.imgsize);
                C.fill(Float.POSITIVE_INFINITY);
                for (int rr = bb[2]; rr < bb[3]; ++rr) {
                    for (int cc = bb[0]; cc < bb[1]; ++cc) {
                        int tc = cc + off[0];
                        int tr = rr + off[1];
                        C.pixels[rr][cc] = AC[c].pixels[tr][tc];
                        for (int g : this.model.tree[t].children[c]) {
                            float[] fArray = C.pixels[rr];
                            int n = cc;
                            fArray[n] = fArray[n] + B[g].pixels[tr][tc];
                        }
                    }
                }
                if (this.model.tree[t].parent[c] != -1) {
                    C.divideInplace((float)this.model.tree[t].scale[c]);
                    FImage D = new FImage(C.width, C.height);
                    int[][] L = new int[C.height][C.width];
                    EuclideanDistanceTransform.squaredEuclideanDistance((FImage)C, (FImage)D, (int[][])L);
                    B[c] = D.multiplyInplace((float)this.model.tree[t].scale[c]);
                    for (int rr = 0; rr < L.length; ++rr) {
                        for (int cc = 0; cc < L[0].length; ++cc) {
                            argB[c][rr][cc] = L[rr][cc] + off[1] * this.model.imgsize + off[0];
                        }
                    }
                    continue;
                }
                FValuePixel min = C.minPixel();
                P[c].position.x = min.x;
                P[c].position.y = min.y;
                conf = -min.value;
            }
            for (ci = 1; ci < this.model.tree[t].depthorder.length; ++ci) {
                c = this.model.tree[t].depthorder[ci];
                int p = this.model.tree[t].parent[c];
                int mini = argB[c][(int)P[p].position.y][(int)P[p].position.x];
                P[c].position.y = mini / this.model.imgsize;
                P[c].position.x = (float)mini - P[c].position.y * (float)this.model.imgsize;
            }
            if (!((conf = (float)((double)conf + Math.log(this.model.tree[t].mix))) > maxconf)) continue;
            maxconf = conf;
            Pbest = P;
        }
        return Pbest;
    }

    public int hashCode() {
        int hashCode = 23;
        return hashCode;
    }

    static class Model
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Model DEFAULT_MODEL = Model.loadDefaultModel();
        Tree[] tree;
        Part[] part;
        int imgsize;
        int border;
        int winsize;
        double appwt;

        Model() {
        }

        private static Model loadDefaultModel() {
            try {
                return Model.buildDefaultModel();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static Model buildDefaultModel() throws IOException {
            Model model = new Model();
            model.appwt = 2.0;
            model.winsize = 15;
            model.border = 15;
            model.imgsize = 80;
            model.part = new Part[9];
            for (int i = 1; i <= 9; ++i) {
                model.part[i - 1] = new Part();
                model.part[i - 1].HCas = Model.readIntDataBin(Model.class.getResourceAsStream("haar" + i + ".bin"));
                model.part[i - 1].talpha = Model.readDoubleDataBin(Model.class.getResourceAsStream("talpha" + i + ".bin"));
                model.part[i - 1].M = Model.readBooleanDataBin(Model.class.getResourceAsStream("mask" + i + ".bin"));
                model.part[i - 1].type = FacialKeypoint.FacialKeypointType.valueOf(i - 1);
            }
            model.tree = new Tree[3];
            model.tree[0] = new Tree();
            model.tree[0].E = new double[][]{{1.0, 2.0}, {2.0, 3.0}, {3.0, 4.0}, {2.0, 5.0}, {5.0, 6.0}, {6.0, 7.0}, {5.0, 8.0}, {7.0, 9.0}};
            model.tree[0].var = new double[]{1.16, 1.03, 1.19, 2.49, 0.88, 0.92, 1.71, 1.81};
            model.tree[0].MU = new int[][]{{0, 0}, {9, 0}, {10, 0}, {9, 0}, {1, 12}, {5, 0}, {5, 0}, {-3, 7}, {3, 7}};
            model.tree[0].mix = 0.33;
            model.tree[0].scale = new double[]{0.0, 0.431203093871548, 0.48449246752124, 0.420546069849079, 0.200844044022372, 0.571191103033717, 0.546043956131382, 0.29239576280796, 0.275798316570445};
            model.tree[0].parent = new int[]{-1, 0, 1, 2, 1, 4, 5, 4, 6};
            model.tree[0].children = new int[][]{{1}, {2, 4}, {3}, new int[0], {5, 7}, {6}, {8}, new int[0], new int[0]};
            model.tree[0].depthorder = new int[]{0, 1, 2, 4, 3, 5, 7, 6, 8};
            model.tree[1] = new Tree();
            model.tree[1].E = new double[][]{{1.0, 2.0}, {2.0, 3.0}, {3.0, 4.0}, {3.0, 7.0}, {7.0, 6.0}, {6.0, 5.0}, {5.0, 8.0}, {7.0, 9.0}};
            model.tree[1].var = new double[]{1.97, 1.85, 1.89, 3.33, 1.89, 2.06, 3.6, 4.0};
            model.tree[1].MU = new int[][]{{0, 0}, {9, -1}, {10, -1}, {9, -1}, {-5, -2}, {-6, 3}, {2, 11}, {-2, 8}, {4, 7}};
            model.tree[1].mix = 0.36;
            model.tree[1].scale = new double[]{0.0, 0.254045277312314, 0.27007962004807, 0.264406629463902, 0.243204625087956, 0.263998194617104, 0.150044711363897, 0.138952250832562, 0.12499477454055};
            model.tree[1].parent = new int[]{-1, 0, 1, 2, 5, 6, 2, 4, 6};
            model.tree[1].children = new int[][]{{1}, {2}, {3, 6}, new int[0], {7}, {4}, {5, 8}, new int[0], new int[0]};
            model.tree[1].depthorder = new int[]{0, 1, 2, 3, 6, 5, 8, 4, 7};
            model.tree[2] = new Tree();
            model.tree[2].E = new double[][]{{1.0, 2.0}, {2.0, 3.0}, {3.0, 4.0}, {2.0, 5.0}, {5.0, 6.0}, {6.0, 7.0}, {7.0, 9.0}, {5.0, 8.0}};
            model.tree[2].var = new double[]{2.15, 1.95, 2.25, 3.77, 1.99, 2.49, 3.88, 4.23};
            model.tree[2].MU = new int[][]{{0, 0}, {9, 1}, {10, 1}, {9, 1}, {-1, 11}, {5, 3}, {6, -1}, {-4, 7}, {1, 8}};
            model.tree[2].mix = 0.31;
            model.tree[2].scale = new double[]{0.0, 0.232309551084211, 0.256560908278279, 0.221946733311257, 0.132713563105743, 0.251186367002818, 0.200459108303263, 0.118167093811055, 0.128771977977574};
            model.tree[2].parent = new int[]{-1, 0, 1, 2, 1, 4, 5, 4, 6};
            model.tree[2].children = new int[][]{{1}, {2, 4}, {3}, new int[0], {5, 7}, {6}, {8}, new int[0], new int[0]};
            model.tree[2].depthorder = new int[]{0, 1, 2, 4, 3, 5, 7, 6, 8};
            return model;
        }

        private static double[][] readDoubleDataBin(InputStream is) throws IOException {
            DataInputStream input = new DataInputStream(is);
            int rows = input.readInt();
            int cols = input.readInt();
            double[][] data = new double[rows][cols];
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    data[r][c] = input.readDouble();
                }
            }
            input.close();
            return data;
        }

        private static int[][] readIntDataBin(InputStream is) throws IOException {
            DataInputStream input = new DataInputStream(is);
            int rows = input.readInt();
            int cols = input.readInt();
            int[][] data = new int[rows][cols];
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    data[r][c] = input.readInt();
                }
            }
            input.close();
            return data;
        }

        private static boolean[][] readBooleanDataBin(InputStream is) throws IOException {
            DataInputStream input = new DataInputStream(is);
            int rows = input.readInt();
            int cols = input.readInt();
            boolean[][] data = new boolean[rows][cols];
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    data[r][c] = input.readInt() == 1;
                }
            }
            input.close();
            return data;
        }

        static class Part
        implements Serializable {
            private static final long serialVersionUID = 1L;
            double[][] talpha;
            int[][] HCas;
            int[] bb;
            boolean[][] M;
            FacialKeypoint.FacialKeypointType type;

            Part() {
            }
        }

        static class Tree
        implements Serializable {
            private static final long serialVersionUID = 1L;
            double[][] E;
            double[] var;
            int[][] MU;
            double mix;
            double[] scale;
            int[] parent;
            int[][] children;
            int[] depthorder;

            Tree() {
            }
        }
    }
}

