/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.list;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class ConcatenatedList<T>
extends AbstractList<T> {
    private List<List<T>> innerLists = new ArrayList<List<T>>();

    public ConcatenatedList(List<List<T>> lists) {
        this.innerLists = lists;
    }

    public ConcatenatedList(List<T> l1, List<T> l2) {
        this.innerLists.add(l1);
        this.innerLists.add(l2);
    }

    public ConcatenatedList(List<T> l1, List<T> l2, List<T> l3) {
        this.innerLists.add(l1);
        this.innerLists.add(l2);
        this.innerLists.add(l3);
    }

    public ConcatenatedList(List<T> l1, List<T> l2, List<T> l3, List<T> l4) {
        this.innerLists.add(l1);
        this.innerLists.add(l2);
        this.innerLists.add(l3);
        this.innerLists.add(l4);
    }

    @Override
    public T get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        for (List<T> d : this.innerLists) {
            if (index >= count + d.size()) {
                count += d.size();
                continue;
            }
            return d.get(index - count);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        int size = 0;
        for (List<T> d : this.innerLists) {
            size += d.size();
        }
        return size;
    }
}

