/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.iterator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ConcatenatedIterable<T>
implements Iterable<T> {
    private List<Iterator<T>> iterators;

    public ConcatenatedIterable(Iterable<T> ... iterables) {
        this.iterators = new ArrayList<Iterator<T>>();
        for (Iterable<T> i : iterables) {
            this.iterators.add(i.iterator());
        }
    }

    public ConcatenatedIterable(Collection<? extends Iterable<T>> iterables) {
        this.iterators = new ArrayList<Iterator<T>>();
        for (Iterable<T> i : iterables) {
            this.iterators.add(i.iterator());
        }
    }

    public ConcatenatedIterable(Iterator<T> ... iterables) {
        this.iterators = Arrays.asList(iterables);
    }

    @Override
    public Iterator<T> iterator() {
        return new ConcatenatedIterator();
    }

    class ConcatenatedIterator
    implements Iterator<T> {
        Iterator<Iterator<T>> it;
        Iterator<T> current;

        public ConcatenatedIterator() {
            if (ConcatenatedIterable.this.iterators == null) {
                return;
            }
            this.it = ConcatenatedIterable.this.iterators.iterator();
            if (!this.it.hasNext()) {
                this.it = null;
                return;
            }
            this.current = this.it.next();
        }

        @Override
        public boolean hasNext() {
            if (this.it == null) {
                return false;
            }
            if (this.current.hasNext()) {
                return true;
            }
            if (!this.it.hasNext()) {
                return false;
            }
            this.current = this.it.next();
            return this.hasNext();
        }

        @Override
        public T next() {
            if (!this.current.hasNext()) {
                if (!this.it.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.current = this.it.next();
            }
            return this.current.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

