/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.openimaj.util.array.ArrayIterator;
import org.openimaj.util.function.Predicate;

public class FilterUtils {
    private FilterUtils() {
    }

    public static <T, Q extends T> ArrayList<Q> filter(Collection<Q> in, Predicate<T> filter) {
        ArrayList<Q> out = new ArrayList<Q>();
        for (Q item : in) {
            if (!filter.test(item)) continue;
            out.add(item);
        }
        return out;
    }

    public static <T> Collection<T> filter(Collection<? extends T> in, Collection<T> out, Predicate<T> filter) {
        for (T item : in) {
            if (!filter.test(item)) continue;
            out.add(item);
        }
        return out;
    }

    public static <T> Iterator<T> filteredIterator(Iterable<? extends T> iterable, Predicate<T> filter) {
        return FilterUtils.filteredIterator(iterable.iterator(), filter);
    }

    public static <T> Iterator<T> filteredIterator(final Iterator<? extends T> iterator, final Predicate<T> filter) {
        return new Iterator<T>(){
            T next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                if (!iterator.hasNext()) {
                    return false;
                }
                while (iterator.hasNext()) {
                    this.next = iterator.next();
                    if (!filter.test(this.next)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    this.hasNext();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> Iterator<T> filteredIterator(T[] array, Predicate<T> filter) {
        return FilterUtils.filteredIterator(new ArrayIterator<T>(array), filter);
    }
}

