/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.logger;

import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class LoggerUtils {
    public static void prepareConsoleLogger() {
        ConsoleAppender console = new ConsoleAppender();
        String PATTERN = "%m\n";
        console.setLayout((Layout)new PatternLayout(PATTERN));
        console.setThreshold((Priority)Level.DEBUG);
        console.activateOptions();
        Logger.getRootLogger().addAppender((Appender)console);
    }

    public static void debug(Logger logger, String message, boolean b) {
        if (b) {
            logger.debug((Object)message);
        }
    }

    public static void debugFormat(Logger logger, String string, Object ... obj) {
        LoggerUtils.format(logger, string, Level.DEBUG, obj);
    }

    public static void format(Logger logger, String string, Level debug, Object ... obj) {
        Level l = logger.getEffectiveLevel();
        if (debug.isGreaterOrEqual((Priority)l)) {
            logger.log((Priority)debug, (Object)String.format(string, obj));
        }
    }
}

