/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data;

import java.lang.reflect.Array;
import org.openimaj.data.AbstractDataSource;
import org.openimaj.data.DataSource;

public class IndexedViewDataSource<DATATYPE>
extends AbstractDataSource<DATATYPE> {
    DataSource<DATATYPE> innerSource;
    int[] indexes;

    public IndexedViewDataSource(DataSource<DATATYPE> dataSource, int[] indexes) {
        this.innerSource = dataSource;
        this.indexes = indexes;
    }

    @Override
    public void getData(int startRow, int stopRow, DATATYPE[] data) {
        Object[] tmp = data[0] == null ? (Object[])Array.newInstance(this.getData(0).getClass(), 1) : (Object[])Array.newInstance(data[0].getClass(), 1);
        int i = 0;
        for (int j = startRow; j < stopRow; ++j) {
            int row = this.indexes[j];
            tmp[0] = data[i];
            this.innerSource.getData(row, row + 1, tmp);
            ++i;
        }
    }

    @Override
    public DATATYPE getData(int row) {
        return this.innerSource.getData(this.indexes[row]);
    }

    @Override
    public int numDimensions() {
        return this.innerSource.numDimensions();
    }

    @Override
    public int numRows() {
        return this.indexes.length;
    }
}

