/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data;

import java.util.Iterator;
import org.openimaj.data.DataSource;
import org.openimaj.data.RandomData;

public abstract class AbstractDataSource<DATATYPE>
implements DataSource<DATATYPE> {
    @Override
    public Iterator<DATATYPE> iterator() {
        return new Iterator<DATATYPE>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index + 1 < AbstractDataSource.this.numRows();
            }

            @Override
            public DATATYPE next() {
                ++this.index;
                return AbstractDataSource.this.getData(this.index);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void getRandomRows(DATATYPE[] data) {
        int[] rndIndexes = RandomData.getUniqueRandomInts(data.length, 0, this.numRows());
        for (int i = 0; i < rndIndexes.length; ++i) {
            data[i] = this.getData(rndIndexes[i]);
        }
    }
}

