/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data.dataset;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeSelector;
import org.apache.commons.vfs2.VFS;
import org.openimaj.data.dataset.ReadableGroupDataset;
import org.openimaj.data.dataset.VFSListDataset;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.io.ObjectReader;

public class VFSGroupDataset<INSTANCE>
extends ReadableGroupDataset<String, VFSListDataset<INSTANCE>, INSTANCE, FileObject>
implements Identifiable {
    private Map<String, VFSListDataset<INSTANCE>> files = new LinkedHashMap<String, VFSListDataset<INSTANCE>>();
    private Map<String, FileObject> directoryInfo = new LinkedHashMap<String, FileObject>();
    private FileObject base;

    public VFSGroupDataset(String path, InputStreamObjectReader<INSTANCE> reader) throws FileSystemException {
        this(path, new VFSListDataset.FileObjectISReader<INSTANCE>(reader));
    }

    public VFSGroupDataset(String path, ObjectReader<INSTANCE, FileObject> reader) throws FileSystemException {
        super(reader);
        FileSystemManager fsManager = VFS.getManager();
        this.base = fsManager.resolveFile(path);
        FileObject[] folders = this.base.findFiles((FileSelector)new FileTypeSelector(FileType.FOLDER));
        Arrays.sort(folders, new Comparator<FileObject>(){

            @Override
            public int compare(FileObject o1, FileObject o2) {
                return o1.getName().toString().compareToIgnoreCase(o2.getName().toString());
            }
        });
        for (FileObject folder : folders) {
            if (folder.equals(this.base)) continue;
            this.directoryInfo.put(folder.getName().getBaseName(), folder);
            VFSListDataset<INSTANCE> list = new VFSListDataset<INSTANCE>(folder.getName().getURI(), reader);
            if (list.size() <= 0) continue;
            this.files.put(folder.getName().getBaseName(), list);
        }
    }

    public Map<String, FileObject> getGroupDirectories() {
        return this.directoryInfo;
    }

    public FileObject getFileObject(String key) {
        return this.directoryInfo.get(key);
    }

    @Override
    public String toString() {
        return String.format("%s(%d groups with a total of %d instances)", this.getClass().getName(), this.size(), this.numInstances());
    }

    @Override
    public Set<Map.Entry<String, VFSListDataset<INSTANCE>>> entrySet() {
        return this.files.entrySet();
    }

    @Override
    public String getID() {
        return this.base.getName().getBaseName();
    }
}

