/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/core/core/src/main/jtemp/org/openimaj/util/pair/Object#T#Pair.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.util.pair;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import gnu.trove.list.array.TLongArrayList;

/**
 * A pair of a generic type <Q> and long
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 * 
 * @param <Q> type of first object
 */
public class ObjectLongPair<Q> {
	/**
     * Comparator for comparing the second element of a {@link ObjectLongPair} in ascending order.
     */
	public static final Comparator<ObjectLongPair<?>> SECOND_ITEM_ASCENDING_COMPARATOR = new Comparator<ObjectLongPair<?>>() {
    	@Override
		public int compare(ObjectLongPair<?> o1, ObjectLongPair<?> o2) {
			if (o1.second < o2.second)
				return -1;
			if (o1.second > o2.second)
				return 1;
			return 0;
		}
	};

	/**
     * Comparator for comparing the second element of a {@link ObjectLongPair} in descending order.
     */
	public static final Comparator<ObjectLongPair<?>> SECOND_ITEM_DESCENDING_COMPARATOR = new Comparator<ObjectLongPair<?>>() {
    	@Override
		public int compare(ObjectLongPair<?> o1, ObjectLongPair<?> o2) {
			if (o1.second < o2.second)
				return 1;
			if (o1.second > o2.second)
				return -1;
			return 0;
		}
	};
    
	/**
   	 * The first element of the pair  
 	 */
	public Q first;
	
	/**
 	 * The first element of the pair  
	 */
	public long second; 
	
	/**
	 * Construct pair with given values
	 * 
	 * @param f first value
	 * @param s second value
	 */
	public ObjectLongPair(Q f, long s) {first=f; second=s;} 
	
	/**
 	 * Construct empty pair 
	 */
	public ObjectLongPair() { }
	
	/**
	 * Get the value of the first element
	 * @return the first value
	 */
	public Q getFirst() {
		return first;
	}

	/**
	 * Set the value of the first element
	 * @param first the value to set
	 */
	public void setFirst(Q first) {
		this.first = first;
	}

	/**
	 * Get the value of the second element
	 * @return the second
	 */
	public long getSecond() {
		return second;
	}

	/**
	 * Set the value of the second element
	 * @param second the value to set
	 */
	public void setSecond(long second) {
		this.second = second;
	}
	
	/**
	 * Create a pair from the given objects.
	 * 
	 * @param <Q> Type of first object.
	 * @param q The first object.
	 * @param t The second object.
	 * @return The pair.
	 */
	public static <Q> ObjectLongPair<Q> pair(Q q, long t) {
		return new ObjectLongPair<Q>(q, t);
	}

	/**
	 * Extract the second objects from a list of pairs.
	 *
	 * @param <Q> type of first object
	 * @param data the data
	 * @return extracted second objects
	 */
	public static <Q> TLongArrayList getSecond(Iterable<ObjectLongPair<Q>> data) {
		TLongArrayList extracted = new TLongArrayList();

		for (ObjectLongPair<Q> item : data)
			extracted.add(item.second);

		return extracted;
	}

	/**
	 * Extract the first objects from a list of pairs.
	 * 
	 * @param <Q> type of first object
	 * @param data the data
	 * @return extracted first objects
	 */
	public static <Q> List<Q> getFirst(Iterable<ObjectLongPair<Q>> data) {
		List<Q> extracted = new ArrayList<Q>();

		for (ObjectLongPair<Q> item : data)
			extracted.add(item.first);

		return extracted;
	}
}
