/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/core/core/src/main/jtemp/org/openimaj/util/pair/#A##B#Pair.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.util.pair;

import java.util.Comparator;

/**
 * A pair of long and byte types
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 *
 */
public class LongBytePair {
    /**
     * Comparator for comparing the first element of a {@link LongBytePair} in ascending order.
     */
    public static final Comparator<LongBytePair> FIRST_ITEM_ASCENDING_COMPARATOR = new Comparator<LongBytePair>() {
    	@Override
		public int compare(LongBytePair o1, LongBytePair o2) {
			if (o1.first < o2.first)
				return -1;
			if (o1.first > o2.first)
				return 1;
			return 0;
		}
	};
	
	/**
     * Comparator for comparing the first element of a {@link LongBytePair} in descending order.
     */
	public static final Comparator<LongBytePair> FIRST_ITEM_DESCENDING_COMPARATOR = new Comparator<LongBytePair>() {
    	@Override
		public int compare(LongBytePair o1, LongBytePair o2) {
			if (o1.first < o2.first)
				return 1;
			if (o1.first > o2.first)
				return -1;
			return 0;
		}
	};
	
	/**
     * Comparator for comparing the second element of a {@link LongBytePair} in ascending order.
     */
	public static final Comparator<LongBytePair> SECOND_ITEM_ASCENDING_COMPARATOR = new Comparator<LongBytePair>() {
    	@Override
		public int compare(LongBytePair o1, LongBytePair o2) {
			if (o1.second < o2.second)
				return -1;
			if (o1.second > o2.second)
				return 1;
			return 0;
		}
	};
	
	/**
     * Comparator for comparing the second element of a {@link LongBytePair} in descending order.
     */
	public static final Comparator<LongBytePair> SECOND_ITEM_DESCENDING_COMPARATOR = new Comparator<LongBytePair>() {
    	@Override
		public int compare(LongBytePair o1, LongBytePair o2) {
			if (o1.second < o2.second)
				return 1;
			if (o1.second > o2.second)
				return -1;
			return 0;
		}
	};
    
	/**
	 * The first element of the pair  
	 */
	public long first; 
	
	/**
 	 * The first element of the pair  
	 */
	public byte second; 
	
	/**
	 * Construct pair with given values
	 * 
	 * @param f first value
	 * @param s second value
	 */
	public LongBytePair(long f, byte s) {first=f; second=s;}

	/**
 	 * Construct empty pair 
	 */
	public LongBytePair() {}
	
	/**
	 * Get the value of the first element
	 * @return the first value
	 */
	public long getFirst() {
		return first;
	}

	/**
	 * Set the value of the first element
	 * @param first the value to set
	 */
	public void setFirst(long first) {
		this.first = first;
	}

	/**
	 * Get the value of the second element
	 * @return the second
	 */
	public byte getSecond() {
		return second;
	}

	/**
	 * Set the value of the second element
	 * @param second the value to set
	 */
	public void setSecond(byte second) {
		this.second = second;
	}
	
	/**
	 * Create a pair from the given values.
	 * 
	 * @param a The first object.
	 * @param b The second object.
	 * @return The pair.
	 */
	public static LongBytePair pair(long a, byte b) {
		return new LongBytePair(a, b);
	}

	/**
	 * Extract the second values from a list of pairs.
	 *
	 * @param data the data
	 * @return extracted second values
	 */
	public static gnu.trove.list.array.TByteArrayList getSecond(Iterable<LongBytePair> data) {
		gnu.trove.list.array.TByteArrayList extracted = new gnu.trove.list.array.TByteArrayList();

		for (LongBytePair item : data)
			extracted.add(item.second);

		return extracted;
	}

	/**
	 * Extract the first values from a list of pairs.
	 * 
	 * @param data the data
	 * @return extracted first values
	 */
	public static gnu.trove.list.array.TLongArrayList getFirst(Iterable<LongBytePair> data) {
		gnu.trove.list.array.TLongArrayList extracted = new gnu.trove.list.array.TLongArrayList();

		for (LongBytePair item : data)
			extracted.add(item.first);

		return extracted;
	}	
	
	@Override
	public String toString() {
		return "("+first + ", "+ second+")";
	}
}
