/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/core/core/src/main/jtemp/org/openimaj/util/iterator/Uniform#T#RangeIterable.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.util.iterator;

import java.util.Iterator;

/**
 * Numeric range iterator for long types. A range goes from 
 * a number <code>start</code> (inclusive) to another number 
 * <code>stop</code> (exclusive). There is an optional step
 * size. 
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 */
public class UniformLongRangeIterable implements NumericIterable<Long> {
	private long stop;
	private long step;
	private long current;
	
	/**
	 * Construct a UniformLongRangeIterator with the given values
	 * @param start the starting value (inclusive)
	 * @param stop the stopping number (exclusive)
	 * @param step the step size
	 */
	public UniformLongRangeIterable(long start, long stop, long step) {
		this.stop = stop;
		this.step = step;
		this.current = start;
	}
	/**
	 * Construct a UniformLongRangeIterator with the given values
	 *
	 * @param start the starting value (inclusive)
	 * @param stop the stopping number (exclusive)
	 */
	public UniformLongRangeIterable(long start, long stop) {
		this(start, stop, (long)1);
	}
	
	@Override
	public Iterator<Long> iterator() {
		return new Iterator<Long>() {

			@Override
			public boolean hasNext() {
				return (current + step <= stop);
			}

			@Override
			public Long next() {
				long ret = current;
				current += step;
				return ret;
			}

			@Override
			public void remove() {
				throw new UnsupportedOperationException( "Not supported" );
			}
		};
	}
}
