/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/core/core/src/main/jtemp/org/openimaj/util/array/SparseHashed#T#Array.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntFloatIterator;
import gnu.trove.map.hash.TIntFloatHashMap;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * A {@link SparseFloatArray} implementation based on a
 * {@link TIntFloatHashMap}. Unlike the {@link SparseBinSearchFloatArray}
 * implementation, this class should be good for the case
 * where random insertion is used frequently (O(1) insert complexity).
 * In the worst-case search is O(n), although in practice it should be better.
 * <p>
 * Note that the {@link #entries()} method will in general not return
 * the entries in index order. 
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 *
 */
public class SparseHashedFloatArray extends SparseFloatArray {
	TIntFloatHashMap data;
	
	/**
	 * @param values
	 */
	public SparseHashedFloatArray(float[] values) {
		this(values.length);
		
		for (int i=0; i<values.length; i++) {
			if (values[i] != 0) set(i, values[i]);
		}
	}

	/**
	 * Construct the array with the given length
	 * @param length the length
	 */
	public SparseHashedFloatArray(int length) {
		this(length, DEFAULT_CAPACITY);
	}

	/**
	 * Construct the array with the given length and capacity for non-zero elements
	 * @param length the length
	 * @param capacity the capacity
	 */
	public SparseHashedFloatArray(int length, int capacity) {
		if (length < 0) throw new IllegalArgumentException("length must be >= 0");
		if (capacity <= 0) throw new IllegalArgumentException("capacity must be > 0");
	
		this.length = length;
		this.data = new TIntFloatHashMap(capacity);
	}

	/**
	 * Construct the array with the given length and expected density
	 * @param length the length
	 * @param density the density
	 */
	public SparseHashedFloatArray(int length, float density) {
		if (length < 0) throw new IllegalArgumentException("length must be >= 0");
		if (density <= 0 || density > 1) throw new IllegalArgumentException("density must be > 0 and < 1");
		
		this.length = length;
		int capacity = (int) (density * length);
		this.data = new TIntFloatHashMap(capacity);
	}
	
	@Override
	public float increment(int key, float value) {
		return data.adjustOrPutValue(key, value, value);
	}

	@Override
	public int[] indices() {
		return data.keys();
	}

	@Override
	public float[] values() {
		return data.values();
	}

	/* (non-Javadoc)
	 * @see org.openimaj.util.array.SparseFloatArray#entries()
	 */
	@Override
	public Iterable<Entry> entries() {
		return new Iterable<Entry>() {
			@Override
			public Iterator<Entry> iterator() {
				return new Iterator<Entry>() {
					private Entry entry = new Entry();
					private TIntFloatIterator iterator = data.iterator();

					@Override
					public boolean hasNext() {
						return iterator.hasNext();
					}

					@Override
					public Entry next() {
						if (!hasNext()) throw new NoSuchElementException();
						iterator.advance();
						entry.index = iterator.key();
						entry.value = iterator.value();
						
						return entry;
					}

					@Override
					public void remove() {
						throw new UnsupportedOperationException();
					}
				};
			}
		};
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof SparseHashedFloatArray)) return false;
		
		return length == ((SparseHashedFloatArray)obj).length &&
				data.equals(((SparseHashedFloatArray)obj).data);
	}

	@Override
	public float get(int key) {
		if (key < 0 || key >= length) throw new IndexOutOfBoundsException(Integer.toString(key)); 
		return data.get(key);
	}

	@Override
	public int hashCode() {
		return length ^ data.hashCode();
	}

	@Override
	public boolean isUsed(int key) {
		return data.contains(key);
	}

	@Override
	public float set(int key, float value) {
		return data.put(key, value);
	}

	@Override
	public int used() {
		return data.size();
	}

	@Override
	public void compact() {
		data.compact();
	}
	
	/* (non-Javadoc)
	 * @see org.openimaj.util.array.SparseDoubleArray#copy()
	 */
	@Override
	public SparseFloatArray copy() {
		SparseHashedFloatArray copy = new SparseHashedFloatArray(length);
		
		copy.data = new TIntFloatHashMap(data);
		
		return copy;
	}

	/* (non-Javadoc)
	 * @see org.openimaj.util.array.SparseDoubleArray#reverse()
	 */
	@Override
	public SparseFloatArray reverse() {
		//TODO: this could be more efficient and avoid the copy
		TIntFloatHashMap tmp = new TIntFloatHashMap(data.size());

		for (Entry e : entries())
			tmp.put(length - e.index, e.value);
		
		this.data = tmp;
		
		return this;
	}
}
