/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/core/core/src/main/jtemp/org/openimaj/util/array/ArrayUtils.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.util.array;

import java.lang.reflect.Array;

/**
 * Collection of utilities for primitive arrays.
 * 
 * @author Jonathan Hare
 * @author Sina Samangooei
 * 
 */
public class ArrayUtils {
    private ArrayUtils () {
        
    }

    
	/**
	 * Format the array as a string, using the provided format 
	 * string to control how each value is printed.
	 * 
	 * @param arr
	 *            array of double
	 * @param fmt
	 *            format string for each element
	 * @return the value
	 */
    public static String toString(double[] arr, String fmt) {
		StringBuffer localStringBuffer = new StringBuffer();
		localStringBuffer.append("[");
		int i = arr.length - 1;
		for (int j = 0; j <= i; ++j)
		{
			localStringBuffer.append(String.format(fmt, arr[j]));
			if (j >= i)
				continue;
			localStringBuffer.append(", ");
		}
		localStringBuffer.append("]");
		return localStringBuffer.toString();
	}
    
    
	/**
	 * Format the array as a string, using the provided format 
	 * string to control how each value is printed.
	 * 
	 * @param arr
	 *            array of float
	 * @param fmt
	 *            format string for each element
	 * @return the value
	 */
    public static String toString(float[] arr, String fmt) {
		StringBuffer localStringBuffer = new StringBuffer();
		localStringBuffer.append("[");
		int i = arr.length - 1;
		for (int j = 0; j <= i; ++j)
		{
			localStringBuffer.append(String.format(fmt, arr[j]));
			if (j >= i)
				continue;
			localStringBuffer.append(", ");
		}
		localStringBuffer.append("]");
		return localStringBuffer.toString();
	}
    
    
	/**
	 * Format the array as a string, using the provided format 
	 * string to control how each value is printed.
	 * 
	 * @param arr
	 *            array of int
	 * @param fmt
	 *            format string for each element
	 * @return the value
	 */
    public static String toString(int[] arr, String fmt) {
		StringBuffer localStringBuffer = new StringBuffer();
		localStringBuffer.append("[");
		int i = arr.length - 1;
		for (int j = 0; j <= i; ++j)
		{
			localStringBuffer.append(String.format(fmt, arr[j]));
			if (j >= i)
				continue;
			localStringBuffer.append(", ");
		}
		localStringBuffer.append("]");
		return localStringBuffer.toString();
	}
    
    
	/**
	 * Format the array as a string, using the provided format 
	 * string to control how each value is printed.
	 * 
	 * @param arr
	 *            array of long
	 * @param fmt
	 *            format string for each element
	 * @return the value
	 */
    public static String toString(long[] arr, String fmt) {
		StringBuffer localStringBuffer = new StringBuffer();
		localStringBuffer.append("[");
		int i = arr.length - 1;
		for (int j = 0; j <= i; ++j)
		{
			localStringBuffer.append(String.format(fmt, arr[j]));
			if (j >= i)
				continue;
			localStringBuffer.append(", ");
		}
		localStringBuffer.append("]");
		return localStringBuffer.toString();
	}
    
    
	/**
	 * Format the array as a string, using the provided format 
	 * string to control how each value is printed.
	 * 
	 * @param arr
	 *            array of byte
	 * @param fmt
	 *            format string for each element
	 * @return the value
	 */
    public static String toString(byte[] arr, String fmt) {
		StringBuffer localStringBuffer = new StringBuffer();
		localStringBuffer.append("[");
		int i = arr.length - 1;
		for (int j = 0; j <= i; ++j)
		{
			localStringBuffer.append(String.format(fmt, arr[j]));
			if (j >= i)
				continue;
			localStringBuffer.append(", ");
		}
		localStringBuffer.append("]");
		return localStringBuffer.toString();
	}
    
    
	/**
	 * Format the array as a string, using the provided format 
	 * string to control how each value is printed.
	 * 
	 * @param arr
	 *            array of short
	 * @param fmt
	 *            format string for each element
	 * @return the value
	 */
    public static String toString(short[] arr, String fmt) {
		StringBuffer localStringBuffer = new StringBuffer();
		localStringBuffer.append("[");
		int i = arr.length - 1;
		for (int j = 0; j <= i; ++j)
		{
			localStringBuffer.append(String.format(fmt, arr[j]));
			if (j >= i)
				continue;
			localStringBuffer.append(", ");
		}
		localStringBuffer.append("]");
		return localStringBuffer.toString();
	}
    
    
	/**
	 * Returns the largest value in the array.
	 * 
	 * @param arr
	 *            array of double
	 * @return the value
	 */
	public static double maxValue(final double[] arr) {
		if (arr.length < 0)
			return 0;

		double max = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
			}
		}

		return max;
	}

    
	/**
	 * Returns the largest value in the array.
	 * 
	 * @param arr
	 *            array of float
	 * @return the value
	 */
	public static float maxValue(final float[] arr) {
		if (arr.length < 0)
			return 0;

		float max = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
			}
		}

		return max;
	}

    
	/**
	 * Returns the largest value in the array.
	 * 
	 * @param arr
	 *            array of int
	 * @return the value
	 */
	public static int maxValue(final int[] arr) {
		if (arr.length < 0)
			return 0;

		int max = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
			}
		}

		return max;
	}

    
	/**
	 * Returns the largest value in the array.
	 * 
	 * @param arr
	 *            array of long
	 * @return the value
	 */
	public static long maxValue(final long[] arr) {
		if (arr.length < 0)
			return 0;

		long max = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
			}
		}

		return max;
	}

    
	/**
	 * Returns the largest value in the array.
	 * 
	 * @param arr
	 *            array of byte
	 * @return the value
	 */
	public static byte maxValue(final byte[] arr) {
		if (arr.length < 0)
			return 0;

		byte max = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
			}
		}

		return max;
	}

    
	/**
	 * Returns the largest value in the array.
	 * 
	 * @param arr
	 *            array of short
	 * @return the value
	 */
	public static short maxValue(final short[] arr) {
		if (arr.length < 0)
			return 0;

		short max = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
			}
		}

		return max;
	}

    
	/**
	 * Returns the smallest value in the array.
	 * 
	 * @param arr
	 *            array of double
	 * @return the value
	 */
	public static double minValue(final double[] arr) {
		if (arr.length < 0)
			return 0;

		double min = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
			}
		}

		return min;
	}

    
	/**
	 * Returns the smallest value in the array.
	 * 
	 * @param arr
	 *            array of float
	 * @return the value
	 */
	public static float minValue(final float[] arr) {
		if (arr.length < 0)
			return 0;

		float min = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
			}
		}

		return min;
	}

    
	/**
	 * Returns the smallest value in the array.
	 * 
	 * @param arr
	 *            array of int
	 * @return the value
	 */
	public static int minValue(final int[] arr) {
		if (arr.length < 0)
			return 0;

		int min = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
			}
		}

		return min;
	}

    
	/**
	 * Returns the smallest value in the array.
	 * 
	 * @param arr
	 *            array of long
	 * @return the value
	 */
	public static long minValue(final long[] arr) {
		if (arr.length < 0)
			return 0;

		long min = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
			}
		}

		return min;
	}

    
	/**
	 * Returns the smallest value in the array.
	 * 
	 * @param arr
	 *            array of byte
	 * @return the value
	 */
	public static byte minValue(final byte[] arr) {
		if (arr.length < 0)
			return 0;

		byte min = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
			}
		}

		return min;
	}

    
	/**
	 * Returns the smallest value in the array.
	 * 
	 * @param arr
	 *            array of short
	 * @return the value
	 */
	public static short minValue(final short[] arr) {
		if (arr.length < 0)
			return 0;

		short min = arr[0];
		for (int i = 1; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
			}
		}

		return min;
	}

    
	/**
	 * Returns the index to the biggest value in the array.
	 * 
	 * @param arr
	 *            array of double
	 * @return the index
	 */
	public static int maxIndex(final double[] arr) {
		double max = Double.MIN_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the biggest value in the array.
	 * 
	 * @param arr
	 *            array of float
	 * @return the index
	 */
	public static int maxIndex(final float[] arr) {
		float max = Float.MIN_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the biggest value in the array.
	 * 
	 * @param arr
	 *            array of int
	 * @return the index
	 */
	public static int maxIndex(final int[] arr) {
		int max = Integer.MIN_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the biggest value in the array.
	 * 
	 * @param arr
	 *            array of long
	 * @return the index
	 */
	public static int maxIndex(final long[] arr) {
		long max = Long.MIN_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the biggest value in the array.
	 * 
	 * @param arr
	 *            array of byte
	 * @return the index
	 */
	public static int maxIndex(final byte[] arr) {
		byte max = Byte.MIN_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the biggest value in the array.
	 * 
	 * @param arr
	 *            array of short
	 * @return the index
	 */
	public static int maxIndex(final short[] arr) {
		short max = Short.MIN_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] > max) {
				max = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the smallest value in the array.
	 * 
	 * @param arr
	 *            array of double
	 * @return the index
	 */
	public static int minIndex(final double[] arr) {
		double min = Double.MAX_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the smallest value in the array.
	 * 
	 * @param arr
	 *            array of float
	 * @return the index
	 */
	public static int minIndex(final float[] arr) {
		float min = Float.MAX_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the smallest value in the array.
	 * 
	 * @param arr
	 *            array of int
	 * @return the index
	 */
	public static int minIndex(final int[] arr) {
		int min = Integer.MAX_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the smallest value in the array.
	 * 
	 * @param arr
	 *            array of long
	 * @return the index
	 */
	public static int minIndex(final long[] arr) {
		long min = Long.MAX_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the smallest value in the array.
	 * 
	 * @param arr
	 *            array of byte
	 * @return the index
	 */
	public static int minIndex(final byte[] arr) {
		byte min = Byte.MAX_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Returns the index to the smallest value in the array.
	 * 
	 * @param arr
	 *            array of short
	 * @return the index
	 */
	public static int minIndex(final short[] arr) {
		short min = Short.MAX_VALUE;
		int index = 0;
		for (int i = 0; i < arr.length; i++) {
			if (arr[i] < min) {
				min = arr[i];
				index = i;
			}
		}

		return index;
	}

    
	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static double[][] sum(final double[][] a1, final double[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			sum(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static double[] sum(final double[] a1, final double[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] += a2[j];
		}
		return a1;
	}

    
	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static float[][] sum(final float[][] a1, final float[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			sum(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static float[] sum(final float[] a1, final float[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] += a2[j];
		}
		return a1;
	}

    
	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static int[][] sum(final int[][] a1, final int[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			sum(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static int[] sum(final int[] a1, final int[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] += a2[j];
		}
		return a1;
	}

    
	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static long[][] sum(final long[][] a1, final long[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			sum(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static long[] sum(final long[] a1, final long[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] += a2[j];
		}
		return a1;
	}

    
	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static byte[][] sum(final byte[][] a1, final byte[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			sum(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static byte[] sum(final byte[] a1, final byte[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] += a2[j];
		}
		return a1;
	}

    
	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static short[][] sum(final short[][] a1, final short[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			sum(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise summation of two arrays, output writes over first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static short[] sum(final short[] a1, final short[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] += a2[j];
		}
		return a1;
	}

    
	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static double[][] subtract(final double[][] a1, final double[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			subtract(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static double[] subtract(final double[] a1, final double[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] -= a2[j];
		}
		return a1;
	}

	
	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static float[][] subtract(final float[][] a1, final float[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			subtract(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static float[] subtract(final float[] a1, final float[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] -= a2[j];
		}
		return a1;
	}

	
	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static int[][] subtract(final int[][] a1, final int[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			subtract(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static int[] subtract(final int[] a1, final int[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] -= a2[j];
		}
		return a1;
	}

	
	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static long[][] subtract(final long[][] a1, final long[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			subtract(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static long[] subtract(final long[] a1, final long[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] -= a2[j];
		}
		return a1;
	}

	
	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static byte[][] subtract(final byte[][] a1, final byte[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			subtract(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static byte[] subtract(final byte[] a1, final byte[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] -= a2[j];
		}
		return a1;
	}

	
	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static short[][] subtract(final short[][] a1, final short[][] a2) {
		for (int j = 0; j < a1.length; j++) {
			subtract(a1[j], a2[j]);
		}
		return a1;
	}

	/**
	 * Element-wise subtraction of two arrays. Second array is subtracted from
	 * first, overwriting the first array
	 * 
	 * @param a1
	 *            first array
	 * @param a2
	 *            second array
	 * @return the first array
	 */
	public static short[] subtract(final short[] a1, final short[] a2) {
		for (int j = 0; j < a1.length; j++) {
			a1[j] -= a2[j];
		}
		return a1;
	}

	
	/**
	 * Subtracts <code>s</code> from all elements in <code>a1</code> overwriting
	 * the array. This is syntactic sugar for <code>add( a1, -s )</code>.
	 * 
	 * @param a1
	 *            The array
	 * @param s
	 *            The scalar
	 * @return the array
	 */
	public static double[] subtract(final double[] a1, final double s)
	{
		return add(a1, (double)(-s));
	}

    
	/**
	 * Subtracts <code>s</code> from all elements in <code>a1</code> overwriting
	 * the array. This is syntactic sugar for <code>add( a1, -s )</code>.
	 * 
	 * @param a1
	 *            The array
	 * @param s
	 *            The scalar
	 * @return the array
	 */
	public static float[] subtract(final float[] a1, final float s)
	{
		return add(a1, (float)(-s));
	}

    
	/**
	 * Subtracts <code>s</code> from all elements in <code>a1</code> overwriting
	 * the array. This is syntactic sugar for <code>add( a1, -s )</code>.
	 * 
	 * @param a1
	 *            The array
	 * @param s
	 *            The scalar
	 * @return the array
	 */
	public static int[] subtract(final int[] a1, final int s)
	{
		return add(a1, (int)(-s));
	}

    
	/**
	 * Subtracts <code>s</code> from all elements in <code>a1</code> overwriting
	 * the array. This is syntactic sugar for <code>add( a1, -s )</code>.
	 * 
	 * @param a1
	 *            The array
	 * @param s
	 *            The scalar
	 * @return the array
	 */
	public static long[] subtract(final long[] a1, final long s)
	{
		return add(a1, (long)(-s));
	}

    
	/**
	 * Subtracts <code>s</code> from all elements in <code>a1</code> overwriting
	 * the array. This is syntactic sugar for <code>add( a1, -s )</code>.
	 * 
	 * @param a1
	 *            The array
	 * @param s
	 *            The scalar
	 * @return the array
	 */
	public static byte[] subtract(final byte[] a1, final byte s)
	{
		return add(a1, (byte)(-s));
	}

    
	/**
	 * Subtracts <code>s</code> from all elements in <code>a1</code> overwriting
	 * the array. This is syntactic sugar for <code>add( a1, -s )</code>.
	 * 
	 * @param a1
	 *            The array
	 * @param s
	 *            The scalar
	 * @return the array
	 */
	public static short[] subtract(final short[] a1, final short s)
	{
		return add(a1, (short)(-s));
	}

    
	/**
	 * Add a constant to all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to add
	 * @return the input array
	 */
	public static double[] add(final double[] ds, final double x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] += x;
		}
		return ds;
	}

    
	/**
	 * Add a constant to all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to add
	 * @return the input array
	 */
	public static float[] add(final float[] ds, final float x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] += x;
		}
		return ds;
	}

    
	/**
	 * Add a constant to all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to add
	 * @return the input array
	 */
	public static int[] add(final int[] ds, final int x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] += x;
		}
		return ds;
	}

    
	/**
	 * Add a constant to all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to add
	 * @return the input array
	 */
	public static long[] add(final long[] ds, final long x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] += x;
		}
		return ds;
	}

    
	/**
	 * Add a constant to all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to add
	 * @return the input array
	 */
	public static byte[] add(final byte[] ds, final byte x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] += x;
		}
		return ds;
	}

    
	/**
	 * Add a constant to all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to add
	 * @return the input array
	 */
	public static short[] add(final short[] ds, final short x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] += x;
		}
		return ds;
	}

    
    /**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static double[] multiply(final double[] ds, final double x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] *= x;
		}
		return ds;
	}
	
	/**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static double[][] multiply(final double[][] ds, final double x) {
		for (int i = 0; i < ds.length; i++) {
			multiply(ds[i], x);
		}
		return ds;
	}

    
    /**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static float[] multiply(final float[] ds, final float x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] *= x;
		}
		return ds;
	}
	
	/**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static float[][] multiply(final float[][] ds, final float x) {
		for (int i = 0; i < ds.length; i++) {
			multiply(ds[i], x);
		}
		return ds;
	}

    
    /**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static int[] multiply(final int[] ds, final int x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] *= x;
		}
		return ds;
	}
	
	/**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static int[][] multiply(final int[][] ds, final int x) {
		for (int i = 0; i < ds.length; i++) {
			multiply(ds[i], x);
		}
		return ds;
	}

    
    /**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static long[] multiply(final long[] ds, final long x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] *= x;
		}
		return ds;
	}
	
	/**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static long[][] multiply(final long[][] ds, final long x) {
		for (int i = 0; i < ds.length; i++) {
			multiply(ds[i], x);
		}
		return ds;
	}

    
    /**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static byte[] multiply(final byte[] ds, final byte x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] *= x;
		}
		return ds;
	}
	
	/**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static byte[][] multiply(final byte[][] ds, final byte x) {
		for (int i = 0; i < ds.length; i++) {
			multiply(ds[i], x);
		}
		return ds;
	}

    
    /**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static short[] multiply(final short[] ds, final short x) {
		for (int i = 0; i < ds.length; i++) {
			ds[i] *= x;
		}
		return ds;
	}
	
	/**
	 * Multiply by a constant all elements and return the input
	 * 
	 * @param ds
	 *            input array
	 * @param x
	 *            constant to multiply by
	 * @return input
	 */
	public static short[][] multiply(final short[][] ds, final short x) {
		for (int i = 0; i < ds.length; i++) {
			multiply(ds[i], x);
		}
		return ds;
	}

    
	/**
	 * Element-wise multiplication, overwriting a1
	 * 
	 * @param a1
	 *            The first array
	 * @param a2
	 *            the second array
	 * @return The first array
	 */
	public static double[] multiply(final double[] a1, final double[] a2)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] *= a2[j];
		return a1;
	}

	/**
	 * Element-wise multiplication, overwriting a1.
	 * 
	 * @param a1
	 *            First array
	 * @param a2
	 *            second array
	 * @return Updated first array
	 */
	public static double[][] multiply(final double[][] a1, final double[][] a2)
	{
		for (int j = 0; j < a1.length; j++)
			multiply(a1[j], a2[j]);
		return a1;
	}

    
	/**
	 * Element-wise multiplication, overwriting a1
	 * 
	 * @param a1
	 *            The first array
	 * @param a2
	 *            the second array
	 * @return The first array
	 */
	public static float[] multiply(final float[] a1, final float[] a2)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] *= a2[j];
		return a1;
	}

	/**
	 * Element-wise multiplication, overwriting a1.
	 * 
	 * @param a1
	 *            First array
	 * @param a2
	 *            second array
	 * @return Updated first array
	 */
	public static float[][] multiply(final float[][] a1, final float[][] a2)
	{
		for (int j = 0; j < a1.length; j++)
			multiply(a1[j], a2[j]);
		return a1;
	}

    
	/**
	 * Element-wise multiplication, overwriting a1
	 * 
	 * @param a1
	 *            The first array
	 * @param a2
	 *            the second array
	 * @return The first array
	 */
	public static int[] multiply(final int[] a1, final int[] a2)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] *= a2[j];
		return a1;
	}

	/**
	 * Element-wise multiplication, overwriting a1.
	 * 
	 * @param a1
	 *            First array
	 * @param a2
	 *            second array
	 * @return Updated first array
	 */
	public static int[][] multiply(final int[][] a1, final int[][] a2)
	{
		for (int j = 0; j < a1.length; j++)
			multiply(a1[j], a2[j]);
		return a1;
	}

    
	/**
	 * Element-wise multiplication, overwriting a1
	 * 
	 * @param a1
	 *            The first array
	 * @param a2
	 *            the second array
	 * @return The first array
	 */
	public static long[] multiply(final long[] a1, final long[] a2)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] *= a2[j];
		return a1;
	}

	/**
	 * Element-wise multiplication, overwriting a1.
	 * 
	 * @param a1
	 *            First array
	 * @param a2
	 *            second array
	 * @return Updated first array
	 */
	public static long[][] multiply(final long[][] a1, final long[][] a2)
	{
		for (int j = 0; j < a1.length; j++)
			multiply(a1[j], a2[j]);
		return a1;
	}

    
	/**
	 * Element-wise multiplication, overwriting a1
	 * 
	 * @param a1
	 *            The first array
	 * @param a2
	 *            the second array
	 * @return The first array
	 */
	public static byte[] multiply(final byte[] a1, final byte[] a2)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] *= a2[j];
		return a1;
	}

	/**
	 * Element-wise multiplication, overwriting a1.
	 * 
	 * @param a1
	 *            First array
	 * @param a2
	 *            second array
	 * @return Updated first array
	 */
	public static byte[][] multiply(final byte[][] a1, final byte[][] a2)
	{
		for (int j = 0; j < a1.length; j++)
			multiply(a1[j], a2[j]);
		return a1;
	}

    
	/**
	 * Element-wise multiplication, overwriting a1
	 * 
	 * @param a1
	 *            The first array
	 * @param a2
	 *            the second array
	 * @return The first array
	 */
	public static short[] multiply(final short[] a1, final short[] a2)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] *= a2[j];
		return a1;
	}

	/**
	 * Element-wise multiplication, overwriting a1.
	 * 
	 * @param a1
	 *            First array
	 * @param a2
	 *            second array
	 * @return Updated first array
	 */
	public static short[][] multiply(final short[][] a1, final short[][] a2)
	{
		for (int j = 0; j < a1.length; j++)
			multiply(a1[j], a2[j]);
		return a1;
	}

    
	/**
	 * Divide by a constant, all elements and return the input
	 * 
	 * @param fs
	 *            The input array
	 * @param x
	 *            the constant to divide by
	 * @return THe input
	 */
	public static double[] divide(final double[] fs, final double x)
	{
		for (int i = 0; i < fs.length; i++)
			fs[i] /= x;
		return fs;
	}

    
	/**
	 * Divide by a constant, all elements and return the input
	 * 
	 * @param fs
	 *            The input array
	 * @param x
	 *            the constant to divide by
	 * @return THe input
	 */
	public static float[] divide(final float[] fs, final float x)
	{
		for (int i = 0; i < fs.length; i++)
			fs[i] /= x;
		return fs;
	}

    
	/**
	 * Divide by a constant, all elements and return the input
	 * 
	 * @param fs
	 *            The input array
	 * @param x
	 *            the constant to divide by
	 * @return THe input
	 */
	public static int[] divide(final int[] fs, final int x)
	{
		for (int i = 0; i < fs.length; i++)
			fs[i] /= x;
		return fs;
	}

    
	/**
	 * Divide by a constant, all elements and return the input
	 * 
	 * @param fs
	 *            The input array
	 * @param x
	 *            the constant to divide by
	 * @return THe input
	 */
	public static long[] divide(final long[] fs, final long x)
	{
		for (int i = 0; i < fs.length; i++)
			fs[i] /= x;
		return fs;
	}

    
	/**
	 * Divide by a constant, all elements and return the input
	 * 
	 * @param fs
	 *            The input array
	 * @param x
	 *            the constant to divide by
	 * @return THe input
	 */
	public static byte[] divide(final byte[] fs, final byte x)
	{
		for (int i = 0; i < fs.length; i++)
			fs[i] /= x;
		return fs;
	}

    
	/**
	 * Divide by a constant, all elements and return the input
	 * 
	 * @param fs
	 *            The input array
	 * @param x
	 *            the constant to divide by
	 * @return THe input
	 */
	public static short[] divide(final short[] fs, final short x)
	{
		for (int i = 0; i < fs.length; i++)
			fs[i] /= x;
		return fs;
	}

    
	/**
	 * Normalise length of array to 1.0. Writes over array. If the array is all
	 * zeros, it will be unchanged.
	 * 
	 * @param array
	 *            the array
	 * @return the array
	 */
	public static float[] normalise(final float[] array) {
		float sumsq = 0.0f;
		for (int i = 0; i < array.length; i++)
			sumsq += array[i] * array[i];

		if (sumsq == 0)
			return array;

		final float weight = 1.0f / (float) Math.sqrt(sumsq);
		for (int i = 0; i < array.length; i++)
			array[i] *= weight;
		return array;
	}

	/**
	 * Normalise length of array to 1.0. Writes over array. If the array is all
	 * zeros, it will be unchanged.
	 * 
	 * @param array
	 *            the array
	 * @return the array
	 */
	public static double[] normalise(final double[] array) {
		double sumsq = 0.0f;
		for (int i = 0; i < array.length; i++)
			sumsq += array[i] * array[i];

		if (sumsq == 0)
			return array;

		final double weight = 1.0f / Math.sqrt(sumsq);
		for (int i = 0; i < array.length; i++)
			array[i] *= weight;
		return array;
	}

    
	/**
	 * Reverse the elements in the input and return the input.
	 * 
	 * @param ds
	 *            input array
	 * @return input
	 */
	public static double[] reverse(final double[] ds) {
		final int len = ds.length;
		final int hlen = len / 2;

		for (int i = 0; i < hlen; i++) {
			final double tmp = ds[i];
			ds[i] = ds[len - i - 1];
			ds[len - i - 1] = tmp;
		}
		return ds;
	}

    
	/**
	 * Reverse the elements in the input and return the input.
	 * 
	 * @param ds
	 *            input array
	 * @return input
	 */
	public static float[] reverse(final float[] ds) {
		final int len = ds.length;
		final int hlen = len / 2;

		for (int i = 0; i < hlen; i++) {
			final float tmp = ds[i];
			ds[i] = ds[len - i - 1];
			ds[len - i - 1] = tmp;
		}
		return ds;
	}

    
	/**
	 * Reverse the elements in the input and return the input.
	 * 
	 * @param ds
	 *            input array
	 * @return input
	 */
	public static int[] reverse(final int[] ds) {
		final int len = ds.length;
		final int hlen = len / 2;

		for (int i = 0; i < hlen; i++) {
			final int tmp = ds[i];
			ds[i] = ds[len - i - 1];
			ds[len - i - 1] = tmp;
		}
		return ds;
	}

    
	/**
	 * Reverse the elements in the input and return the input.
	 * 
	 * @param ds
	 *            input array
	 * @return input
	 */
	public static long[] reverse(final long[] ds) {
		final int len = ds.length;
		final int hlen = len / 2;

		for (int i = 0; i < hlen; i++) {
			final long tmp = ds[i];
			ds[i] = ds[len - i - 1];
			ds[len - i - 1] = tmp;
		}
		return ds;
	}

    
	/**
	 * Reverse the elements in the input and return the input.
	 * 
	 * @param ds
	 *            input array
	 * @return input
	 */
	public static byte[] reverse(final byte[] ds) {
		final int len = ds.length;
		final int hlen = len / 2;

		for (int i = 0; i < hlen; i++) {
			final byte tmp = ds[i];
			ds[i] = ds[len - i - 1];
			ds[len - i - 1] = tmp;
		}
		return ds;
	}

    
	/**
	 * Reverse the elements in the input and return the input.
	 * 
	 * @param ds
	 *            input array
	 * @return input
	 */
	public static short[] reverse(final short[] ds) {
		final int len = ds.length;
		final int hlen = len / 2;

		for (int i = 0; i < hlen; i++) {
			final short tmp = ds[i];
			ds[i] = ds[len - i - 1];
			ds[len - i - 1] = tmp;
		}
		return ds;
	}

    
	/**
	 * Convert a double array to a double array.
	 * 
	 * @param array
	 *            array of doubles to convert
	 * @return array of doubles
	 */
	public static double[] convertToDouble(final double[] array) {
		final double[] darr = new double[array.length];

		for (int i = 0; i < array.length; i++) {
			darr[i] = array[i];
		}
		return darr;
	}

	/**
	 * Convert a double array to a double array.
	 * 
	 * @param array
	 *            array of doubles to convert
	 * @return array of doubles
	 */
	public static double[][] convertToDouble(final double[][] array)
	{
		final double[][] darr = new double[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToDouble(array[i]);
		return darr;
	}

    
	/**
	 * Convert a float array to a double array.
	 * 
	 * @param array
	 *            array of floats to convert
	 * @return array of doubles
	 */
	public static double[] convertToDouble(final float[] array) {
		final double[] darr = new double[array.length];

		for (int i = 0; i < array.length; i++) {
			darr[i] = array[i];
		}
		return darr;
	}

	/**
	 * Convert a float array to a double array.
	 * 
	 * @param array
	 *            array of floats to convert
	 * @return array of doubles
	 */
	public static double[][] convertToDouble(final float[][] array)
	{
		final double[][] darr = new double[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToDouble(array[i]);
		return darr;
	}

    
	/**
	 * Convert a int array to a double array.
	 * 
	 * @param array
	 *            array of ints to convert
	 * @return array of doubles
	 */
	public static double[] convertToDouble(final int[] array) {
		final double[] darr = new double[array.length];

		for (int i = 0; i < array.length; i++) {
			darr[i] = array[i];
		}
		return darr;
	}

	/**
	 * Convert a int array to a double array.
	 * 
	 * @param array
	 *            array of ints to convert
	 * @return array of doubles
	 */
	public static double[][] convertToDouble(final int[][] array)
	{
		final double[][] darr = new double[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToDouble(array[i]);
		return darr;
	}

    
	/**
	 * Convert a long array to a double array.
	 * 
	 * @param array
	 *            array of longs to convert
	 * @return array of doubles
	 */
	public static double[] convertToDouble(final long[] array) {
		final double[] darr = new double[array.length];

		for (int i = 0; i < array.length; i++) {
			darr[i] = array[i];
		}
		return darr;
	}

	/**
	 * Convert a long array to a double array.
	 * 
	 * @param array
	 *            array of longs to convert
	 * @return array of doubles
	 */
	public static double[][] convertToDouble(final long[][] array)
	{
		final double[][] darr = new double[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToDouble(array[i]);
		return darr;
	}

    
	/**
	 * Convert a byte array to a double array.
	 * 
	 * @param array
	 *            array of bytes to convert
	 * @return array of doubles
	 */
	public static double[] convertToDouble(final byte[] array) {
		final double[] darr = new double[array.length];

		for (int i = 0; i < array.length; i++) {
			darr[i] = array[i];
		}
		return darr;
	}

	/**
	 * Convert a byte array to a double array.
	 * 
	 * @param array
	 *            array of bytes to convert
	 * @return array of doubles
	 */
	public static double[][] convertToDouble(final byte[][] array)
	{
		final double[][] darr = new double[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToDouble(array[i]);
		return darr;
	}

    
	/**
	 * Convert a short array to a double array.
	 * 
	 * @param array
	 *            array of shorts to convert
	 * @return array of doubles
	 */
	public static double[] convertToDouble(final short[] array) {
		final double[] darr = new double[array.length];

		for (int i = 0; i < array.length; i++) {
			darr[i] = array[i];
		}
		return darr;
	}

	/**
	 * Convert a short array to a double array.
	 * 
	 * @param array
	 *            array of shorts to convert
	 * @return array of doubles
	 */
	public static double[][] convertToDouble(final short[][] array)
	{
		final double[][] darr = new double[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToDouble(array[i]);
		return darr;
	}

    
	/**
	 * Convert a double array to a float array.
	 * 
	 * @param array
	 *            array of doubles to convert
	 * @return array of floats
	 */
	public static float[] convertToFloat(final double[] array) {
		final float[] farr = new float[array.length];

		for (int i = 0; i < array.length; i++) {
			farr[i] = (float) array[i];
		}
		return farr;
	}

    /**
	 * Convert a double array to a float array.
	 * 
	 * @param array
	 *            array of doubles to convert
	 * @return array of doubles
	 */
	public static float[][] convertToFloat(final double[][] array)
	{
		final float[][] darr = new float[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToFloat(array[i]);
		return darr;
	}

    
	/**
	 * Convert a float array to a float array.
	 * 
	 * @param array
	 *            array of floats to convert
	 * @return array of floats
	 */
	public static float[] convertToFloat(final float[] array) {
		final float[] farr = new float[array.length];

		for (int i = 0; i < array.length; i++) {
			farr[i] = (float) array[i];
		}
		return farr;
	}

    /**
	 * Convert a float array to a float array.
	 * 
	 * @param array
	 *            array of floats to convert
	 * @return array of doubles
	 */
	public static float[][] convertToFloat(final float[][] array)
	{
		final float[][] darr = new float[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToFloat(array[i]);
		return darr;
	}

    
	/**
	 * Convert a int array to a float array.
	 * 
	 * @param array
	 *            array of ints to convert
	 * @return array of floats
	 */
	public static float[] convertToFloat(final int[] array) {
		final float[] farr = new float[array.length];

		for (int i = 0; i < array.length; i++) {
			farr[i] = (float) array[i];
		}
		return farr;
	}

    /**
	 * Convert a int array to a float array.
	 * 
	 * @param array
	 *            array of ints to convert
	 * @return array of doubles
	 */
	public static float[][] convertToFloat(final int[][] array)
	{
		final float[][] darr = new float[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToFloat(array[i]);
		return darr;
	}

    
	/**
	 * Convert a long array to a float array.
	 * 
	 * @param array
	 *            array of longs to convert
	 * @return array of floats
	 */
	public static float[] convertToFloat(final long[] array) {
		final float[] farr = new float[array.length];

		for (int i = 0; i < array.length; i++) {
			farr[i] = (float) array[i];
		}
		return farr;
	}

    /**
	 * Convert a long array to a float array.
	 * 
	 * @param array
	 *            array of longs to convert
	 * @return array of doubles
	 */
	public static float[][] convertToFloat(final long[][] array)
	{
		final float[][] darr = new float[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToFloat(array[i]);
		return darr;
	}

    
	/**
	 * Convert a byte array to a float array.
	 * 
	 * @param array
	 *            array of bytes to convert
	 * @return array of floats
	 */
	public static float[] convertToFloat(final byte[] array) {
		final float[] farr = new float[array.length];

		for (int i = 0; i < array.length; i++) {
			farr[i] = (float) array[i];
		}
		return farr;
	}

    /**
	 * Convert a byte array to a float array.
	 * 
	 * @param array
	 *            array of bytes to convert
	 * @return array of doubles
	 */
	public static float[][] convertToFloat(final byte[][] array)
	{
		final float[][] darr = new float[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToFloat(array[i]);
		return darr;
	}

    
	/**
	 * Convert a short array to a float array.
	 * 
	 * @param array
	 *            array of shorts to convert
	 * @return array of floats
	 */
	public static float[] convertToFloat(final short[] array) {
		final float[] farr = new float[array.length];

		for (int i = 0; i < array.length; i++) {
			farr[i] = (float) array[i];
		}
		return farr;
	}

    /**
	 * Convert a short array to a float array.
	 * 
	 * @param array
	 *            array of shorts to convert
	 * @return array of doubles
	 */
	public static float[][] convertToFloat(final short[][] array)
	{
		final float[][] darr = new float[array.length][];
		for (int i = 0; i < array.length; i++)
			darr[i] = convertToFloat(array[i]);
		return darr;
	}

    
	/**
	 * Return the first non-null item from an array.
	 * 
	 * @param <T>
	 *            the type of the elements in the array
	 * @param array
	 *            the array
	 * @return the first non-null object, or null if not found.
	 */
	public static <T> T firstNonNull(final T[] array) {
		if (array == null)
			return null;

		for (final T obj : array) {
			if (obj != null) {
				return obj;
			}
		}

		return null;
	}

    
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param <T>
	 *            Type of elements in the array.
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	@SafeVarargs
	public static <T> T[] concatenate(final T[]... arrays) {
		int length = 0;
		Class<?> type = null;

		for (final T[] arr : arrays) {
			if (arr != null) {
				length += arr.length;

				if (type == null) {
					type = arr.getClass().getComponentType();
				}
			}
		}

		@SuppressWarnings("unchecked")
		final T[] concat = (T[]) Array.newInstance(type, length);

		int current = 0;
		for (final T[] arr : arrays) {
			System.arraycopy(arr, 0, concat, current, arr.length);
			current += arr.length;
		}

		return concat;
	}

    
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static double[] concatenate(final double[]... arrays) {
		int length = 0;
		for (final double[] arr : arrays) {
			length += (arr == null ? 0 : arr.length);
		}

		final double[] concat = new double[length];

		int current = 0;
		for (final double[] arr : arrays) {
			System.arraycopy(arr, 0, concat, current, arr.length);
			current += arr.length;
		}

		return concat;
	}
	
	 
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static float[] concatenate(final float[]... arrays) {
		int length = 0;
		for (final float[] arr : arrays) {
			length += (arr == null ? 0 : arr.length);
		}

		final float[] concat = new float[length];

		int current = 0;
		for (final float[] arr : arrays) {
			System.arraycopy(arr, 0, concat, current, arr.length);
			current += arr.length;
		}

		return concat;
	}
	
	 
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static int[] concatenate(final int[]... arrays) {
		int length = 0;
		for (final int[] arr : arrays) {
			length += (arr == null ? 0 : arr.length);
		}

		final int[] concat = new int[length];

		int current = 0;
		for (final int[] arr : arrays) {
			System.arraycopy(arr, 0, concat, current, arr.length);
			current += arr.length;
		}

		return concat;
	}
	
	 
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static long[] concatenate(final long[]... arrays) {
		int length = 0;
		for (final long[] arr : arrays) {
			length += (arr == null ? 0 : arr.length);
		}

		final long[] concat = new long[length];

		int current = 0;
		for (final long[] arr : arrays) {
			System.arraycopy(arr, 0, concat, current, arr.length);
			current += arr.length;
		}

		return concat;
	}
	
	 
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static byte[] concatenate(final byte[]... arrays) {
		int length = 0;
		for (final byte[] arr : arrays) {
			length += (arr == null ? 0 : arr.length);
		}

		final byte[] concat = new byte[length];

		int current = 0;
		for (final byte[] arr : arrays) {
			System.arraycopy(arr, 0, concat, current, arr.length);
			current += arr.length;
		}

		return concat;
	}
	
	 
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static short[] concatenate(final short[]... arrays) {
		int length = 0;
		for (final short[] arr : arrays) {
			length += (arr == null ? 0 : arr.length);
		}

		final short[] concat = new short[length];

		int current = 0;
		for (final short[] arr : arrays) {
			System.arraycopy(arr, 0, concat, current, arr.length);
			current += arr.length;
		}

		return concat;
	}
	
	 
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static double[][] concatenate(final double[][]... arrays) {
		final double[][] concat = new double[arrays[0].length][];
		for(int i = 0; i < concat.length; i++){
			final double[][] row = new double[arrays.length][];
			for(int j = 0; j < row.length; j++){
				row[j] = arrays[j][i];
			} 
			concat[i] = concatenate(row);
		}
		
		return concat;
	}

	
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static float[][] concatenate(final float[][]... arrays) {
		final float[][] concat = new float[arrays[0].length][];
		for(int i = 0; i < concat.length; i++){
			final float[][] row = new float[arrays.length][];
			for(int j = 0; j < row.length; j++){
				row[j] = arrays[j][i];
			} 
			concat[i] = concatenate(row);
		}
		
		return concat;
	}

	
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static int[][] concatenate(final int[][]... arrays) {
		final int[][] concat = new int[arrays[0].length][];
		for(int i = 0; i < concat.length; i++){
			final int[][] row = new int[arrays.length][];
			for(int j = 0; j < row.length; j++){
				row[j] = arrays[j][i];
			} 
			concat[i] = concatenate(row);
		}
		
		return concat;
	}

	
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static long[][] concatenate(final long[][]... arrays) {
		final long[][] concat = new long[arrays[0].length][];
		for(int i = 0; i < concat.length; i++){
			final long[][] row = new long[arrays.length][];
			for(int j = 0; j < row.length; j++){
				row[j] = arrays[j][i];
			} 
			concat[i] = concatenate(row);
		}
		
		return concat;
	}

	
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static byte[][] concatenate(final byte[][]... arrays) {
		final byte[][] concat = new byte[arrays[0].length][];
		for(int i = 0; i < concat.length; i++){
			final byte[][] row = new byte[arrays.length][];
			for(int j = 0; j < row.length; j++){
				row[j] = arrays[j][i];
			} 
			concat[i] = concatenate(row);
		}
		
		return concat;
	}

	
	/**
	 * Concatenate multiple arrays into a single new array.
	 * 
	 * @param arrays
	 *            the arrays to concatenate.
	 * @return the new concatenated array
	 */
	public static short[][] concatenate(final short[][]... arrays) {
		final short[][] concat = new short[arrays[0].length][];
		for(int i = 0; i < concat.length; i++){
			final short[][] row = new short[arrays.length][];
			for(int j = 0; j < row.length; j++){
				row[j] = arrays[j][i];
			} 
			concat[i] = concatenate(row);
		}
		
		return concat;
	}

	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static double sumValues(final double[] vector) {
		double sum = 0;

		for (final double v : vector)
			sum += v;

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static float sumValues(final float[] vector) {
		float sum = 0;

		for (final float v : vector)
			sum += v;

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static long sumValues(final int[] vector) {
		long sum = 0;

		for (final int v : vector)
			sum += v;

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static long sumValues(final long[] vector) {
		long sum = 0;

		for (final long v : vector)
			sum += v;

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static int sumValues(final byte[] vector) {
		int sum = 0;

		for (final byte v : vector)
			sum += v;

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static int sumValues(final short[] vector) {
		int sum = 0;

		for (final short v : vector)
			sum += v;

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in a 2d array
	 * 
	 * @param array
	 * @return the sum of all values
	 */
	public static double sumValues(final double[][] array) {
		double sum = 0;

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in a 2d array
	 * 
	 * @param array
	 * @return the sum of all values
	 */
	public static float sumValues(final float[][] array) {
		float sum = 0;

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in a 2d array
	 * 
	 * @param array
	 * @return the sum of all values
	 */
	public static long sumValues(final int[][] array) {
		long sum = 0;

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in a 2d array
	 * 
	 * @param array
	 * @return the sum of all values
	 */
	public static long sumValues(final long[][] array) {
		long sum = 0;

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in a 2d array
	 * 
	 * @param array
	 * @return the sum of all values
	 */
	public static int sumValues(final byte[][] array) {
		int sum = 0;

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in a 2d array
	 * 
	 * @param array
	 * @return the sum of all values
	 */
	public static int sumValues(final short[][] array) {
		int sum = 0;

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values squared in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static double sumValuesSquared(final double[] vector) {
		double sum = 0;

		for (final double v : vector)
			sum += v * v;

		return sum;
	}

	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values squared in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static float sumValuesSquared(final float[] vector) {
		float sum = 0;

		for (final float v : vector)
			sum += v * v;

		return sum;
	}

	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values squared in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static long sumValuesSquared(final int[] vector) {
		long sum = 0;

		for (final int v : vector)
			sum += v * v;

		return sum;
	}

	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values squared in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static long sumValuesSquared(final long[] vector) {
		long sum = 0;

		for (final long v : vector)
			sum += v * v;

		return sum;
	}

	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values squared in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static int sumValuesSquared(final byte[] vector) {
		int sum = 0;

		for (final byte v : vector)
			sum += v * v;

		return sum;
	}

	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values squared in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static int sumValuesSquared(final short[] vector) {
		int sum = 0;

		for (final short v : vector)
			sum += v * v;

		return sum;
	}

	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the cumulative sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static double[] cumulativeSum(final double[] vector) {
		double[] sum = new double[vector.length];

		if (vector.length == 0) return sum;

		sum[0] = vector[0];
		for (int i=1; i<vector.length; i++)
			sum[i] = vector[i] + sum[i-1];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the cumulative sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static float[] cumulativeSum(final float[] vector) {
		float[] sum = new float[vector.length];

		if (vector.length == 0) return sum;

		sum[0] = vector[0];
		for (int i=1; i<vector.length; i++)
			sum[i] = vector[i] + sum[i-1];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the cumulative sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static long[] cumulativeSum(final int[] vector) {
		long[] sum = new long[vector.length];

		if (vector.length == 0) return sum;

		sum[0] = vector[0];
		for (int i=1; i<vector.length; i++)
			sum[i] = vector[i] + sum[i-1];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the cumulative sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static long[] cumulativeSum(final long[] vector) {
		long[] sum = new long[vector.length];

		if (vector.length == 0) return sum;

		sum[0] = vector[0];
		for (int i=1; i<vector.length; i++)
			sum[i] = vector[i] + sum[i-1];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the cumulative sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static int[] cumulativeSum(final byte[] vector) {
		int[] sum = new int[vector.length];

		if (vector.length == 0) return sum;

		sum[0] = vector[0];
		for (int i=1; i<vector.length; i++)
			sum[i] = vector[i] + sum[i-1];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the cumulative sum of values in an array
	 * 
	 * @param vector
	 * @return the sum of all values
	 */
	public static int[] cumulativeSum(final short[] vector) {
		int[] sum = new int[vector.length];

		if (vector.length == 0) return sum;

		sum[0] = vector[0];
		for (int i=1; i<vector.length; i++)
			sum[i] = vector[i] + sum[i-1];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each row of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each row
	 */
	public static double[] rowSum(final double[][] array) {
		double[] sum = new double[array.length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum[i] += array[i][j];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each row of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each row
	 */
	public static float[] rowSum(final float[][] array) {
		float[] sum = new float[array.length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum[i] += array[i][j];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each row of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each row
	 */
	public static long[] rowSum(final int[][] array) {
		long[] sum = new long[array.length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum[i] += array[i][j];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each row of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each row
	 */
	public static long[] rowSum(final long[][] array) {
		long[] sum = new long[array.length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum[i] += array[i][j];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each row of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each row
	 */
	public static int[] rowSum(final byte[][] array) {
		int[] sum = new int[array.length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum[i] += array[i][j];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each row of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each row
	 */
	public static int[] rowSum(final short[][] array) {
		int[] sum = new int[array.length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[i].length; j++)
				sum[i] += array[i][j];

		return sum;
	}
	
	
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each column of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each column
	 */
	public static double[] colSum(final double[][] array) {
		double[] sum = new double[array[0].length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[0].length; j++)
				sum[j] += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each column of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each column
	 */
	public static float[] colSum(final float[][] array) {
		float[] sum = new float[array[0].length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[0].length; j++)
				sum[j] += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each column of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each column
	 */
	public static long[] colSum(final int[][] array) {
		long[] sum = new long[array[0].length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[0].length; j++)
				sum[j] += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each column of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each column
	 */
	public static long[] colSum(final long[][] array) {
		long[] sum = new long[array[0].length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[0].length; j++)
				sum[j] += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each column of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each column
	 */
	public static int[] colSum(final byte[][] array) {
		int[] sum = new int[array[0].length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[0].length; j++)
				sum[j] += array[i][j];

		return sum;
	}

    
	/*** 
    	{ m -> 
    		if (m['T'] == DOUBLE) {
    			return (m['R'] == DOUBLE); 		
    		}
    		if (m['T'] == LONG) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == INT) {
    			return (m['R'] == LONG);
    		}
    		if (m['T'] == SHORT) {
    			return (m['R'] == INT);
    		}
    		if (m['T'] == BYTE) {
    			return (m['R'] == INT);
    		}
    		return (m['R'] == FLOAT);
    	}
    ***/
	/**
	 * Compute the sum of values in each column of a 2d array
	 * 
	 * @param array the array 
	 * @return the sum of each column
	 */
	public static int[] colSum(final short[][] array) {
		int[] sum = new int[array[0].length];

		for (int i=0; i<array.length; i++)
			for (int j=0; j<array[0].length; j++)
				sum[j] += array[i][j];

		return sum;
	}

    
	/**
	 * Extract a range
	 * 
	 * @param start
	 * @param length
	 * @return [start...length] (inclusive)
	 */
	public static int[] range(final int start, final int length) {
		final int[] range = new int[length - start + 1];
		for (int i = start; i <= length; i++) {
			range[i - start] = i;
		}
		return range;
	}

    
	/**
	 * Find the given value in the array, and return all indices at which it occurs.
	 * 
	 * @param a
	 *            array to search
	 * @param value
	 * 			  value to search for
	 * @return the found values
	 */
	public static int[] search(final double[] a, double value) {
		int count = 0;

		for (int i = 0; i < a.length; i++)
			if (a[i] == value) 
				count++;
		
		int [] ret = new int[count];
		for (int i = 0, j=0; i < a.length; i++)
			if (a[i] == value) ret[j++] = i;
		
		return ret;
	}

    
	/**
	 * Find the given value in the array, and return all indices at which it occurs.
	 * 
	 * @param a
	 *            array to search
	 * @param value
	 * 			  value to search for
	 * @return the found values
	 */
	public static int[] search(final float[] a, float value) {
		int count = 0;

		for (int i = 0; i < a.length; i++)
			if (a[i] == value) 
				count++;
		
		int [] ret = new int[count];
		for (int i = 0, j=0; i < a.length; i++)
			if (a[i] == value) ret[j++] = i;
		
		return ret;
	}

    
	/**
	 * Find the given value in the array, and return all indices at which it occurs.
	 * 
	 * @param a
	 *            array to search
	 * @param value
	 * 			  value to search for
	 * @return the found values
	 */
	public static int[] search(final int[] a, int value) {
		int count = 0;

		for (int i = 0; i < a.length; i++)
			if (a[i] == value) 
				count++;
		
		int [] ret = new int[count];
		for (int i = 0, j=0; i < a.length; i++)
			if (a[i] == value) ret[j++] = i;
		
		return ret;
	}

    
	/**
	 * Find the given value in the array, and return all indices at which it occurs.
	 * 
	 * @param a
	 *            array to search
	 * @param value
	 * 			  value to search for
	 * @return the found values
	 */
	public static int[] search(final long[] a, long value) {
		int count = 0;

		for (int i = 0; i < a.length; i++)
			if (a[i] == value) 
				count++;
		
		int [] ret = new int[count];
		for (int i = 0, j=0; i < a.length; i++)
			if (a[i] == value) ret[j++] = i;
		
		return ret;
	}

    
	/**
	 * Find the given value in the array, and return all indices at which it occurs.
	 * 
	 * @param a
	 *            array to search
	 * @param value
	 * 			  value to search for
	 * @return the found values
	 */
	public static int[] search(final byte[] a, byte value) {
		int count = 0;

		for (int i = 0; i < a.length; i++)
			if (a[i] == value) 
				count++;
		
		int [] ret = new int[count];
		for (int i = 0, j=0; i < a.length; i++)
			if (a[i] == value) ret[j++] = i;
		
		return ret;
	}

    
	/**
	 * Find the given value in the array, and return all indices at which it occurs.
	 * 
	 * @param a
	 *            array to search
	 * @param value
	 * 			  value to search for
	 * @return the found values
	 */
	public static int[] search(final short[] a, short value) {
		int count = 0;

		for (int i = 0; i < a.length; i++)
			if (a[i] == value) 
				count++;
		
		int [] ret = new int[count];
		for (int i = 0, j=0; i < a.length; i++)
			if (a[i] == value) ret[j++] = i;
		
		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static double[] reshape(final double[][] a) {
		final double[] ret = new double[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static float[] reshape(final float[][] a) {
		final float[] ret = new float[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static int[] reshape(final int[][] a) {
		final int[] ret = new int[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static long[] reshape(final long[][] a) {
		final long[] ret = new long[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static byte[] reshape(final byte[][] a) {
		final byte[] ret = new byte[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static short[] reshape(final short[][] a) {
		final short[] ret = new short[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array of doubles
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static double[] reshapeDouble(final double[][] a) {
		final double[] ret = new double[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array of doubles
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static double[] reshapeDouble(final float[][] a) {
		final double[] ret = new double[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array of doubles
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static double[] reshapeDouble(final int[][] a) {
		final double[] ret = new double[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array of doubles
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static double[] reshapeDouble(final long[][] a) {
		final double[] ret = new double[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array of doubles
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static double[] reshapeDouble(final byte[][] a) {
		final double[] ret = new double[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 2D array into a 1D array of doubles
	 * 
	 * @param a
	 *            array to reshape
	 * @return the reshaped array
	 */
	public static double[] reshapeDouble(final short[][] a) {
		final double[] ret = new double[a.length * a[0].length];

		for (int r = 0, i = 0; r < a.length; r++)
			for (int c = 0; c < a[0].length; c++, i++)
				ret[i] = a[r][c];

		return ret;
	}

    
	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param out
	 *            the return array, correctly sized
	 * @return the reshaped array
	 */
	public static double[][] reshape(final double[] a, final double[][] out) {
		for (int r = 0, i = 0; r < out.length; r++)
			for (int c = 0; c < out[0].length; c++, i++)
				out[r][c] = a[i];

		return out;
	}

	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param width
	 *            the width of the return array
	 * @param height
	 *            the height of the return array
	 * @return the reshaped array
	 */
	public static double[][] reshape(final double[] a, final int width, final int height) {
		final double[][] ret = new double[height][width];
		return reshape(a, ret);
	}

    
	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param out
	 *            the return array, correctly sized
	 * @return the reshaped array
	 */
	public static float[][] reshape(final float[] a, final float[][] out) {
		for (int r = 0, i = 0; r < out.length; r++)
			for (int c = 0; c < out[0].length; c++, i++)
				out[r][c] = a[i];

		return out;
	}

	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param width
	 *            the width of the return array
	 * @param height
	 *            the height of the return array
	 * @return the reshaped array
	 */
	public static float[][] reshape(final float[] a, final int width, final int height) {
		final float[][] ret = new float[height][width];
		return reshape(a, ret);
	}

    
	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param out
	 *            the return array, correctly sized
	 * @return the reshaped array
	 */
	public static int[][] reshape(final int[] a, final int[][] out) {
		for (int r = 0, i = 0; r < out.length; r++)
			for (int c = 0; c < out[0].length; c++, i++)
				out[r][c] = a[i];

		return out;
	}

	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param width
	 *            the width of the return array
	 * @param height
	 *            the height of the return array
	 * @return the reshaped array
	 */
	public static int[][] reshape(final int[] a, final int width, final int height) {
		final int[][] ret = new int[height][width];
		return reshape(a, ret);
	}

    
	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param out
	 *            the return array, correctly sized
	 * @return the reshaped array
	 */
	public static long[][] reshape(final long[] a, final long[][] out) {
		for (int r = 0, i = 0; r < out.length; r++)
			for (int c = 0; c < out[0].length; c++, i++)
				out[r][c] = a[i];

		return out;
	}

	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param width
	 *            the width of the return array
	 * @param height
	 *            the height of the return array
	 * @return the reshaped array
	 */
	public static long[][] reshape(final long[] a, final int width, final int height) {
		final long[][] ret = new long[height][width];
		return reshape(a, ret);
	}

    
	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param out
	 *            the return array, correctly sized
	 * @return the reshaped array
	 */
	public static byte[][] reshape(final byte[] a, final byte[][] out) {
		for (int r = 0, i = 0; r < out.length; r++)
			for (int c = 0; c < out[0].length; c++, i++)
				out[r][c] = a[i];

		return out;
	}

	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param width
	 *            the width of the return array
	 * @param height
	 *            the height of the return array
	 * @return the reshaped array
	 */
	public static byte[][] reshape(final byte[] a, final int width, final int height) {
		final byte[][] ret = new byte[height][width];
		return reshape(a, ret);
	}

    
	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param out
	 *            the return array, correctly sized
	 * @return the reshaped array
	 */
	public static short[][] reshape(final short[] a, final short[][] out) {
		for (int r = 0, i = 0; r < out.length; r++)
			for (int c = 0; c < out[0].length; c++, i++)
				out[r][c] = a[i];

		return out;
	}

	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param width
	 *            the width of the return array
	 * @param height
	 *            the height of the return array
	 * @return the reshaped array
	 */
	public static short[][] reshape(final short[] a, final int width, final int height) {
		final short[][] ret = new short[height][width];
		return reshape(a, ret);
	}

    
	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param out
	 *            the return array, correctly sized
	 * @return the reshaped array
	 */
	public static float[][] reshapeFloat(final double[] a, final float[][] out) {
		for (int r = 0, i = 0; r < out.length; r++)
			for (int c = 0; c < out[0].length; c++, i++)
				out[r][c] = (float) a[i];

		return out;
	}

	/**
	 * Reshape a 1D array into a 2D array
	 * 
	 * @param a
	 *            array to reshape
	 * @param width
	 *            the width of the return array
	 * @param height
	 *            the height of the return array
	 * @return the reshaped array
	 */
	public static float[][] reshapeFloat(final double[] a, final int width, final int height) {
		final float[][] ret = new float[height][width];
		return reshapeFloat(a, ret);
	}

    
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final double[] main, final double[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final double[] main, final double[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final double[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final double[] main, final float[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final double[] main, final float[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final double[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final double[] main, final int[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final double[] main, final int[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final double[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final double[] main, final long[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final double[] main, final long[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final double[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final double[] main, final byte[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final double[] main, final byte[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final double[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final double[] main, final short[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final double[] main, final short[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final double[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final float[] main, final double[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final float[] main, final double[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final float[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final float[] main, final float[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final float[] main, final float[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final float[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final float[] main, final int[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final float[] main, final int[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final float[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final float[] main, final long[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final float[] main, final long[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final float[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final float[] main, final byte[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final float[] main, final byte[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final float[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final float[] main, final short[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final float[] main, final short[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final float[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final int[] main, final double[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final int[] main, final double[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final int[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final int[] main, final float[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final int[] main, final float[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final int[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final int[] main, final int[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final int[] main, final int[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final int[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final int[] main, final long[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final int[] main, final long[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final int[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final int[] main, final byte[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final int[] main, final byte[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final int[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final int[] main, final short[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final int[] main, final short[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final int[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final long[] main, final double[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final long[] main, final double[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final long[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final long[] main, final float[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final long[] main, final float[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final long[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final long[] main, final int[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final long[] main, final int[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final long[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final long[] main, final long[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final long[] main, final long[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final long[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final long[] main, final byte[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final long[] main, final byte[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final long[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final long[] main, final short[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final long[] main, final short[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final long[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final byte[] main, final double[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final byte[] main, final double[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final byte[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final byte[] main, final float[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final byte[] main, final float[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final byte[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final byte[] main, final int[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final byte[] main, final int[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final byte[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final byte[] main, final long[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final byte[] main, final long[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final byte[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final byte[] main, final byte[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final byte[] main, final byte[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final byte[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final byte[] main, final short[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final byte[] main, final short[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final byte[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final short[] main, final double[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final short[] main, final double[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final short[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final short[] main, final float[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final short[] main, final float[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final short[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final short[] main, final int[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final short[] main, final int[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final short[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final short[] main, final long[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final short[] main, final long[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final short[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final short[] main, final byte[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final short[] main, final byte[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final short[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortDescending(final short[] main, final short[] indices) {
		parallelQuicksortDescending(main, indices, 0, indices.length - 1);
	}

	/**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into descending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void parallelQuicksortDescending(final short[] main, final short[] indices, final int left,
			final int right)
	{
		if (right <= left)
			return;

		final int i = partitionDesc(main, indices, left, right);

		parallelQuicksortDescending(main, indices, left, i - 1);
		parallelQuicksortDescending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionDesc(final short[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] > a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] > a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}
	
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final double[] main, final double[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final double[] main, final double[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final double[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final double[] main, final float[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final double[] main, final float[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final double[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final double[] main, final int[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final double[] main, final int[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final double[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final double[] main, final long[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final double[] main, final long[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final double[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final double[] main, final byte[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final double[] main, final byte[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final double[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final double[] main, final short[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final double[] main, final short[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final double[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final float[] main, final double[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final float[] main, final double[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final float[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final float[] main, final float[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final float[] main, final float[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final float[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final float[] main, final int[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final float[] main, final int[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final float[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final float[] main, final long[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final float[] main, final long[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final float[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final float[] main, final byte[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final float[] main, final byte[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final float[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final float[] main, final short[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final float[] main, final short[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final float[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final int[] main, final double[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final int[] main, final double[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final int[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final int[] main, final float[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final int[] main, final float[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final int[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final int[] main, final int[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final int[] main, final int[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final int[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final int[] main, final long[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final int[] main, final long[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final int[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final int[] main, final byte[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final int[] main, final byte[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final int[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final int[] main, final short[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final int[] main, final short[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final int[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final long[] main, final double[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final long[] main, final double[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final long[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final long[] main, final float[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final long[] main, final float[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final long[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final long[] main, final int[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final long[] main, final int[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final long[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final long[] main, final long[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final long[] main, final long[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final long[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final long[] main, final byte[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final long[] main, final byte[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final long[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final long[] main, final short[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final long[] main, final short[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final long[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final byte[] main, final double[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final byte[] main, final double[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final byte[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final byte[] main, final float[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final byte[] main, final float[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final byte[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final byte[] main, final int[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final byte[] main, final int[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final byte[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final byte[] main, final long[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final byte[] main, final long[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final byte[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final byte[] main, final byte[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final byte[] main, final byte[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final byte[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final byte[] main, final short[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final byte[] main, final short[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final byte[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final short[] main, final double[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final short[] main, final double[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final short[] a, final double[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final short[] main, final float[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final short[] main, final float[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final short[] a, final float[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final short[] main, final int[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final short[] main, final int[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final short[] a, final int[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final short[] main, final long[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final short[] main, final long[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final short[] a, final long[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final short[] main, final byte[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final short[] main, final byte[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final short[] a, final byte[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 */
	public static void parallelQuicksortAscending(final short[] main, final short[] indices) {
		ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
	}
	
    /**
	 * Sort parallel arrays. Arrays are sorted in-place. The first array
	 * determines the order, and is sorted into ascending order.
	 * <p>
	 * Implementation inspired by this stackoverflow page: <a href=
	 * "http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-get-a-sorted-list-of-indices-of-an-array"
	 * > http://stackoverflow.com/questions/951848/java-array-sort-quick-way-to-
	 * get-a-sorted-list-of-indices-of-an-array </a>
	 * 
	 * @param main
	 *            the values to use for determining the order
	 * @param indices
	 *            the second array
	 * @param left
	 *            the starting index
	 * @param right
	 *            the ending index
	 */
	public static void
			parallelQuicksortAscending(final short[] main, final short[] indices, final int left, final int right)
	{
		if (right <= left)
			return;

		final int i = partitionAsc(main, indices, left, right);

		parallelQuicksortAscending(main, indices, left, i - 1);
		parallelQuicksortAscending(main, indices, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partitionAsc(final short[] a, final short[] index, final int left, final int right) {
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[++i] < a[right])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[right] < a[--j])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(a, index, i, j); // swap two elements into place
		}
		exch(a, index, i, right); // swap with partition element
		return i;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final double[] a, final double[] index, final int i, final int j) {
		final double swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final double b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final double[] a, final float[] index, final int i, final int j) {
		final double swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final float b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final double[] a, final int[] index, final int i, final int j) {
		final double swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final int b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final double[] a, final long[] index, final int i, final int j) {
		final double swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final long b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final double[] a, final byte[] index, final int i, final int j) {
		final double swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final byte b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final double[] a, final short[] index, final int i, final int j) {
		final double swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final short b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final float[] a, final double[] index, final int i, final int j) {
		final float swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final double b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final float[] a, final float[] index, final int i, final int j) {
		final float swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final float b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final float[] a, final int[] index, final int i, final int j) {
		final float swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final int b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final float[] a, final long[] index, final int i, final int j) {
		final float swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final long b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final float[] a, final byte[] index, final int i, final int j) {
		final float swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final byte b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final float[] a, final short[] index, final int i, final int j) {
		final float swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final short b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final int[] a, final double[] index, final int i, final int j) {
		final int swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final double b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final int[] a, final float[] index, final int i, final int j) {
		final int swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final float b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final int[] a, final int[] index, final int i, final int j) {
		final int swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final int b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final int[] a, final long[] index, final int i, final int j) {
		final int swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final long b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final int[] a, final byte[] index, final int i, final int j) {
		final int swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final byte b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final int[] a, final short[] index, final int i, final int j) {
		final int swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final short b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final long[] a, final double[] index, final int i, final int j) {
		final long swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final double b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final long[] a, final float[] index, final int i, final int j) {
		final long swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final float b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final long[] a, final int[] index, final int i, final int j) {
		final long swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final int b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final long[] a, final long[] index, final int i, final int j) {
		final long swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final long b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final long[] a, final byte[] index, final int i, final int j) {
		final long swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final byte b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final long[] a, final short[] index, final int i, final int j) {
		final long swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final short b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final byte[] a, final double[] index, final int i, final int j) {
		final byte swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final double b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final byte[] a, final float[] index, final int i, final int j) {
		final byte swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final float b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final byte[] a, final int[] index, final int i, final int j) {
		final byte swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final int b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final byte[] a, final long[] index, final int i, final int j) {
		final byte swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final long b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final byte[] a, final byte[] index, final int i, final int j) {
		final byte swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final byte b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final byte[] a, final short[] index, final int i, final int j) {
		final byte swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final short b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final short[] a, final double[] index, final int i, final int j) {
		final short swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final double b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final short[] a, final float[] index, final int i, final int j) {
		final short swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final float b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final short[] a, final int[] index, final int i, final int j) {
		final short swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final int b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final short[] a, final long[] index, final int i, final int j) {
		final short swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final long b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final short[] a, final byte[] index, final int i, final int j) {
		final short swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final byte b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
    // exchange a[i] and a[j]
	private static void exch(final short[] a, final short[] index, final int i, final int j) {
		final short swap = a[i];
		a[i] = a[j];
		a[j] = swap;

		final short b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
	/**
	 * Determine the indices of the given array if it were to be sorted into
	 * ascending order.
	 * 
	 * @param arr
	 *            the array
	 * @return the sorted indices
	 */
	public static int[] indexSort(final double[] arr) {
		final int[] index = new int[arr.length];

		for (int i = 0; i < index.length; i++)
			index[i] = i;

		quicksort(arr, index, 0, index.length - 1);

		return index;
	}

	// quicksort a[left] to a[right]
	private static void quicksort(final double[] a, final int[] index, final int left, final int right) {
		if (right <= left)
			return;
		final int i = partition(a, index, left, right);
		quicksort(a, index, left, i - 1);
		quicksort(a, index, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partition(final double[] a, final int[] index,
			final int left, final int right)
	{
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[index[++i]] < a[index[right]])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[index[right]] < a[index[--j]])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(index, i, j); // swap two elements into place
		}
		exch(index, i, right); // swap with partition element
		return i;
	}

    
	/**
	 * Determine the indices of the given array if it were to be sorted into
	 * ascending order.
	 * 
	 * @param arr
	 *            the array
	 * @return the sorted indices
	 */
	public static int[] indexSort(final float[] arr) {
		final int[] index = new int[arr.length];

		for (int i = 0; i < index.length; i++)
			index[i] = i;

		quicksort(arr, index, 0, index.length - 1);

		return index;
	}

	// quicksort a[left] to a[right]
	private static void quicksort(final float[] a, final int[] index, final int left, final int right) {
		if (right <= left)
			return;
		final int i = partition(a, index, left, right);
		quicksort(a, index, left, i - 1);
		quicksort(a, index, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partition(final float[] a, final int[] index,
			final int left, final int right)
	{
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[index[++i]] < a[index[right]])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[index[right]] < a[index[--j]])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(index, i, j); // swap two elements into place
		}
		exch(index, i, right); // swap with partition element
		return i;
	}

    
	/**
	 * Determine the indices of the given array if it were to be sorted into
	 * ascending order.
	 * 
	 * @param arr
	 *            the array
	 * @return the sorted indices
	 */
	public static int[] indexSort(final int[] arr) {
		final int[] index = new int[arr.length];

		for (int i = 0; i < index.length; i++)
			index[i] = i;

		quicksort(arr, index, 0, index.length - 1);

		return index;
	}

	// quicksort a[left] to a[right]
	private static void quicksort(final int[] a, final int[] index, final int left, final int right) {
		if (right <= left)
			return;
		final int i = partition(a, index, left, right);
		quicksort(a, index, left, i - 1);
		quicksort(a, index, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partition(final int[] a, final int[] index,
			final int left, final int right)
	{
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[index[++i]] < a[index[right]])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[index[right]] < a[index[--j]])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(index, i, j); // swap two elements into place
		}
		exch(index, i, right); // swap with partition element
		return i;
	}

    
	/**
	 * Determine the indices of the given array if it were to be sorted into
	 * ascending order.
	 * 
	 * @param arr
	 *            the array
	 * @return the sorted indices
	 */
	public static int[] indexSort(final long[] arr) {
		final int[] index = new int[arr.length];

		for (int i = 0; i < index.length; i++)
			index[i] = i;

		quicksort(arr, index, 0, index.length - 1);

		return index;
	}

	// quicksort a[left] to a[right]
	private static void quicksort(final long[] a, final int[] index, final int left, final int right) {
		if (right <= left)
			return;
		final int i = partition(a, index, left, right);
		quicksort(a, index, left, i - 1);
		quicksort(a, index, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partition(final long[] a, final int[] index,
			final int left, final int right)
	{
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[index[++i]] < a[index[right]])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[index[right]] < a[index[--j]])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(index, i, j); // swap two elements into place
		}
		exch(index, i, right); // swap with partition element
		return i;
	}

    
	/**
	 * Determine the indices of the given array if it were to be sorted into
	 * ascending order.
	 * 
	 * @param arr
	 *            the array
	 * @return the sorted indices
	 */
	public static int[] indexSort(final byte[] arr) {
		final int[] index = new int[arr.length];

		for (int i = 0; i < index.length; i++)
			index[i] = i;

		quicksort(arr, index, 0, index.length - 1);

		return index;
	}

	// quicksort a[left] to a[right]
	private static void quicksort(final byte[] a, final int[] index, final int left, final int right) {
		if (right <= left)
			return;
		final int i = partition(a, index, left, right);
		quicksort(a, index, left, i - 1);
		quicksort(a, index, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partition(final byte[] a, final int[] index,
			final int left, final int right)
	{
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[index[++i]] < a[index[right]])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[index[right]] < a[index[--j]])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(index, i, j); // swap two elements into place
		}
		exch(index, i, right); // swap with partition element
		return i;
	}

    
	/**
	 * Determine the indices of the given array if it were to be sorted into
	 * ascending order.
	 * 
	 * @param arr
	 *            the array
	 * @return the sorted indices
	 */
	public static int[] indexSort(final short[] arr) {
		final int[] index = new int[arr.length];

		for (int i = 0; i < index.length; i++)
			index[i] = i;

		quicksort(arr, index, 0, index.length - 1);

		return index;
	}

	// quicksort a[left] to a[right]
	private static void quicksort(final short[] a, final int[] index, final int left, final int right) {
		if (right <= left)
			return;
		final int i = partition(a, index, left, right);
		quicksort(a, index, left, i - 1);
		quicksort(a, index, i + 1, right);
	}

	// partition a[left] to a[right], assumes left < right
	private static int partition(final short[] a, final int[] index,
			final int left, final int right)
	{
		int i = left - 1;
		int j = right;
		while (true) {
			while (a[index[++i]] < a[index[right]])
				// find item on left to swap
				; // a[right] acts as sentinel
			while (a[index[right]] < a[index[--j]])
				// find item on right to swap
				if (j == left)
					break; // don't go out-of-bounds
			if (i >= j)
				break; // check if pointers cross
			exch(index, i, j); // swap two elements into place
		}
		exch(index, i, right); // swap with partition element
		return i;
	}

    
	// exchange a[i] and a[j]
	static void exch(final int[] index, final int i, final int j) {
		final int b = index[i];
		index[i] = index[j];
		index[j] = b;
	}

    
	/**
	 * Normalise and scale the values so that the maximum value in the array is
	 * 1.
	 * 
	 * @param array
	 *            The array to normalise
	 * @return The array
	 */
	public static double[] normaliseMax(final double[] array) {
		return normaliseMax(array, 1d);
	}

	/**
	 * Normalise and scale the values so that the maximum value in the array is
	 * max
	 * 
	 * @param array
	 *            The array to normalise
	 * @param max
	 *            The maximum value
	 * @return The array
	 */
	public static double[] normaliseMax(final double[] array, final double max) {
		final double m = maxValue(array);
		for (int i = 0; i < array.length; i++)
			array[i] = (array[i] / m) * max;
		return array;
	}

    
	/**
	 * Convert the array to a {@link String} by joining the elements with the
	 * given glue.
	 * 
	 * @param s
	 *            the array
	 * @param glue
	 *            the glue
	 * @return the string
	 */
	public static String toString(final String[] s, final String glue) {
		final int k = s.length;

		if (k == 0)
			return null;

		final StringBuilder out = new StringBuilder();
		out.append(s[0]);

		for (int x = 1; x < k; ++x)
			out.append(glue).append(s[x]);

		return out.toString();
	}

    
	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static double[][] fill(final double[][] a1, final double i)
	{
		for (int j = 0; j < a1.length; j++)
			fill(a1[j], i);
		return a1;
	}

	/**
	 * Fill the array with the value from the start index for the length given
	 * 
	 * @param a1
	 *            The array to fill
	 * @param i
	 *            The value to fill with
	 * @param s
	 *            The start index
	 * @param l
	 *            The length of the fill
	 * @return The array
	 */
	public static double[] fill(final double[] a1, final double i, final int s, final int l)
	{
		for (int j = s; j < s + l; j++)
			a1[j] = i;
		return a1;
	}

	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static double[] fill(final double[] a1, final double i)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] = i;
		return a1;
	}

    
	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static float[][] fill(final float[][] a1, final float i)
	{
		for (int j = 0; j < a1.length; j++)
			fill(a1[j], i);
		return a1;
	}

	/**
	 * Fill the array with the value from the start index for the length given
	 * 
	 * @param a1
	 *            The array to fill
	 * @param i
	 *            The value to fill with
	 * @param s
	 *            The start index
	 * @param l
	 *            The length of the fill
	 * @return The array
	 */
	public static float[] fill(final float[] a1, final float i, final int s, final int l)
	{
		for (int j = s; j < s + l; j++)
			a1[j] = i;
		return a1;
	}

	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static float[] fill(final float[] a1, final float i)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] = i;
		return a1;
	}

    
	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static int[][] fill(final int[][] a1, final int i)
	{
		for (int j = 0; j < a1.length; j++)
			fill(a1[j], i);
		return a1;
	}

	/**
	 * Fill the array with the value from the start index for the length given
	 * 
	 * @param a1
	 *            The array to fill
	 * @param i
	 *            The value to fill with
	 * @param s
	 *            The start index
	 * @param l
	 *            The length of the fill
	 * @return The array
	 */
	public static int[] fill(final int[] a1, final int i, final int s, final int l)
	{
		for (int j = s; j < s + l; j++)
			a1[j] = i;
		return a1;
	}

	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static int[] fill(final int[] a1, final int i)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] = i;
		return a1;
	}

    
	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static long[][] fill(final long[][] a1, final long i)
	{
		for (int j = 0; j < a1.length; j++)
			fill(a1[j], i);
		return a1;
	}

	/**
	 * Fill the array with the value from the start index for the length given
	 * 
	 * @param a1
	 *            The array to fill
	 * @param i
	 *            The value to fill with
	 * @param s
	 *            The start index
	 * @param l
	 *            The length of the fill
	 * @return The array
	 */
	public static long[] fill(final long[] a1, final long i, final int s, final int l)
	{
		for (int j = s; j < s + l; j++)
			a1[j] = i;
		return a1;
	}

	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static long[] fill(final long[] a1, final long i)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] = i;
		return a1;
	}

    
	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static byte[][] fill(final byte[][] a1, final byte i)
	{
		for (int j = 0; j < a1.length; j++)
			fill(a1[j], i);
		return a1;
	}

	/**
	 * Fill the array with the value from the start index for the length given
	 * 
	 * @param a1
	 *            The array to fill
	 * @param i
	 *            The value to fill with
	 * @param s
	 *            The start index
	 * @param l
	 *            The length of the fill
	 * @return The array
	 */
	public static byte[] fill(final byte[] a1, final byte i, final int s, final int l)
	{
		for (int j = s; j < s + l; j++)
			a1[j] = i;
		return a1;
	}

	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static byte[] fill(final byte[] a1, final byte i)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] = i;
		return a1;
	}

    
	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static short[][] fill(final short[][] a1, final short i)
	{
		for (int j = 0; j < a1.length; j++)
			fill(a1[j], i);
		return a1;
	}

	/**
	 * Fill the array with the value from the start index for the length given
	 * 
	 * @param a1
	 *            The array to fill
	 * @param i
	 *            The value to fill with
	 * @param s
	 *            The start index
	 * @param l
	 *            The length of the fill
	 * @return The array
	 */
	public static short[] fill(final short[] a1, final short i, final int s, final int l)
	{
		for (int j = s; j < s + l; j++)
			a1[j] = i;
		return a1;
	}

	/**
	 * Fill the array with the value
	 * 
	 * @param a1
	 *            The array
	 * @param i
	 *            The value
	 * @return The array
	 */
	public static short[] fill(final short[] a1, final short i)
	{
		for (int j = 0; j < a1.length; j++)
			a1[j] = i;
		return a1;
	}

    
	/**
	 * Fills the array with ordinal values
	 * 
	 * @param array
	 *            The array to fill
	 * @return the array
	 */
	public static int[] fill(final int[] array)
	{
		for (int i = 0; i < array.length; i++)
			array[i] = i;
		return array;
	}

    
	/**
	 * Truncates the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static double[] truncate(final double[] array, final int index)
	{
		final double[] d = new double[index];
		System.arraycopy(array, 0, d, 0, index);
		return d;
	}

	/**
	 * Truncates every element in the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static double[][] truncate(final double[][] array, final int index)
	{
		final double[][] d = new double[Math.min(array.length, index)][index];
		for (int i = 0; i < d.length; i++)
			d[i] = truncate(array[i], index);
		return d;
	}

    
	/**
	 * Truncates the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static float[] truncate(final float[] array, final int index)
	{
		final float[] d = new float[index];
		System.arraycopy(array, 0, d, 0, index);
		return d;
	}

	/**
	 * Truncates every element in the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static float[][] truncate(final float[][] array, final int index)
	{
		final float[][] d = new float[Math.min(array.length, index)][index];
		for (int i = 0; i < d.length; i++)
			d[i] = truncate(array[i], index);
		return d;
	}

    
	/**
	 * Truncates the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static int[] truncate(final int[] array, final int index)
	{
		final int[] d = new int[index];
		System.arraycopy(array, 0, d, 0, index);
		return d;
	}

	/**
	 * Truncates every element in the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static int[][] truncate(final int[][] array, final int index)
	{
		final int[][] d = new int[Math.min(array.length, index)][index];
		for (int i = 0; i < d.length; i++)
			d[i] = truncate(array[i], index);
		return d;
	}

    
	/**
	 * Truncates the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static long[] truncate(final long[] array, final int index)
	{
		final long[] d = new long[index];
		System.arraycopy(array, 0, d, 0, index);
		return d;
	}

	/**
	 * Truncates every element in the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static long[][] truncate(final long[][] array, final int index)
	{
		final long[][] d = new long[Math.min(array.length, index)][index];
		for (int i = 0; i < d.length; i++)
			d[i] = truncate(array[i], index);
		return d;
	}

    
	/**
	 * Truncates the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static byte[] truncate(final byte[] array, final int index)
	{
		final byte[] d = new byte[index];
		System.arraycopy(array, 0, d, 0, index);
		return d;
	}

	/**
	 * Truncates every element in the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static byte[][] truncate(final byte[][] array, final int index)
	{
		final byte[][] d = new byte[Math.min(array.length, index)][index];
		for (int i = 0; i < d.length; i++)
			d[i] = truncate(array[i], index);
		return d;
	}

    
	/**
	 * Truncates the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static short[] truncate(final short[] array, final int index)
	{
		final short[] d = new short[index];
		System.arraycopy(array, 0, d, 0, index);
		return d;
	}

	/**
	 * Truncates every element in the given array to the given size.
	 * 
	 * @param array
	 *            The array to truncate
	 * @param index
	 *            The size to truncate it to
	 * @return The truncated array
	 */
	public static short[][] truncate(final short[][] array, final int index)
	{
		final short[][] d = new short[Math.min(array.length, index)][index];
		for (int i = 0; i < d.length; i++)
			d[i] = truncate(array[i], index);
		return d;
	}

    
	/**
	 * Quick Select algorithm for getting the nth item from the array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @return the selected item
	 */
	public static double quickSelect(double arr[], int n) {
		return quickSelect(arr, n, 0, arr.length - 1);
	}

	/**
	 * Quick Select algorithm for getting the nth item from a sub-array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @param low
	 *            the starting position in the array (inclusive)
	 * @param high
	 *            the ending position in the array (exclusive)
	 * @return the selected item
	 */
	public static double quickSelect(double arr[], int n, int low, int high) {
		high--; // make high inclusive

		int middle, ll, hh;
		double tmp = 0;
		final int median = (low + high) / 2;

		while (true) {
			if (high <= low) /* One element only */
				return arr[median];

			if (high == low + 1) { /* Two elements only */
				if (arr[low] > arr[high]) {
					tmp = arr[low];
					arr[low] = arr[high];
					arr[high] = tmp;
				}
				return arr[median];
			}

			/* Find median of low, middle and high items; swap into position low */
			middle = (low + high) / 2;
			if (arr[middle] > arr[high]) {
				tmp = arr[middle];
				arr[middle] = arr[high];
				arr[high] = tmp;
				;
			}
			if (arr[low] > arr[high]) {
				tmp = arr[low];
				arr[low] = arr[high];
				arr[high] = tmp;
			}
			if (arr[middle] > arr[low]) {
				tmp = arr[low];
				arr[low] = arr[middle];
				arr[middle] = tmp;
			}

			/* Swap low item (now in position middle) into position (low+1) */
			tmp = arr[middle];
			arr[middle] = arr[low + 1];
			arr[low + 1] = tmp;

			/* Nibble from each end towards middle, swapping items when stuck */
			ll = low + 1;
			hh = high;
			for (;;) {
				do
					ll++;
				while (arr[low] > arr[ll]);
				do
					hh--;
				while (arr[hh] > arr[low]);

				if (hh < ll)
					break;

				tmp = arr[ll];
				arr[ll] = arr[hh];
				arr[hh] = tmp;
			}

			/* Swap middle item (in position low) back into correct position */
			tmp = arr[low];
			arr[low] = arr[hh];
			arr[hh] = tmp;

			/* Re-set active partition */
			if (hh <= median)
				low = ll;
			if (hh >= median)
				high = hh - 1;
		}
	}	

	
	/**
	 * Quick Select algorithm for getting the nth item from the array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @return the selected item
	 */
	public static float quickSelect(float arr[], int n) {
		return quickSelect(arr, n, 0, arr.length - 1);
	}

	/**
	 * Quick Select algorithm for getting the nth item from a sub-array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @param low
	 *            the starting position in the array (inclusive)
	 * @param high
	 *            the ending position in the array (exclusive)
	 * @return the selected item
	 */
	public static float quickSelect(float arr[], int n, int low, int high) {
		high--; // make high inclusive

		int middle, ll, hh;
		float tmp = 0;
		final int median = (low + high) / 2;

		while (true) {
			if (high <= low) /* One element only */
				return arr[median];

			if (high == low + 1) { /* Two elements only */
				if (arr[low] > arr[high]) {
					tmp = arr[low];
					arr[low] = arr[high];
					arr[high] = tmp;
				}
				return arr[median];
			}

			/* Find median of low, middle and high items; swap into position low */
			middle = (low + high) / 2;
			if (arr[middle] > arr[high]) {
				tmp = arr[middle];
				arr[middle] = arr[high];
				arr[high] = tmp;
				;
			}
			if (arr[low] > arr[high]) {
				tmp = arr[low];
				arr[low] = arr[high];
				arr[high] = tmp;
			}
			if (arr[middle] > arr[low]) {
				tmp = arr[low];
				arr[low] = arr[middle];
				arr[middle] = tmp;
			}

			/* Swap low item (now in position middle) into position (low+1) */
			tmp = arr[middle];
			arr[middle] = arr[low + 1];
			arr[low + 1] = tmp;

			/* Nibble from each end towards middle, swapping items when stuck */
			ll = low + 1;
			hh = high;
			for (;;) {
				do
					ll++;
				while (arr[low] > arr[ll]);
				do
					hh--;
				while (arr[hh] > arr[low]);

				if (hh < ll)
					break;

				tmp = arr[ll];
				arr[ll] = arr[hh];
				arr[hh] = tmp;
			}

			/* Swap middle item (in position low) back into correct position */
			tmp = arr[low];
			arr[low] = arr[hh];
			arr[hh] = tmp;

			/* Re-set active partition */
			if (hh <= median)
				low = ll;
			if (hh >= median)
				high = hh - 1;
		}
	}	

	
	/**
	 * Quick Select algorithm for getting the nth item from the array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @return the selected item
	 */
	public static int quickSelect(int arr[], int n) {
		return quickSelect(arr, n, 0, arr.length - 1);
	}

	/**
	 * Quick Select algorithm for getting the nth item from a sub-array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @param low
	 *            the starting position in the array (inclusive)
	 * @param high
	 *            the ending position in the array (exclusive)
	 * @return the selected item
	 */
	public static int quickSelect(int arr[], int n, int low, int high) {
		high--; // make high inclusive

		int middle, ll, hh;
		int tmp = 0;
		final int median = (low + high) / 2;

		while (true) {
			if (high <= low) /* One element only */
				return arr[median];

			if (high == low + 1) { /* Two elements only */
				if (arr[low] > arr[high]) {
					tmp = arr[low];
					arr[low] = arr[high];
					arr[high] = tmp;
				}
				return arr[median];
			}

			/* Find median of low, middle and high items; swap into position low */
			middle = (low + high) / 2;
			if (arr[middle] > arr[high]) {
				tmp = arr[middle];
				arr[middle] = arr[high];
				arr[high] = tmp;
				;
			}
			if (arr[low] > arr[high]) {
				tmp = arr[low];
				arr[low] = arr[high];
				arr[high] = tmp;
			}
			if (arr[middle] > arr[low]) {
				tmp = arr[low];
				arr[low] = arr[middle];
				arr[middle] = tmp;
			}

			/* Swap low item (now in position middle) into position (low+1) */
			tmp = arr[middle];
			arr[middle] = arr[low + 1];
			arr[low + 1] = tmp;

			/* Nibble from each end towards middle, swapping items when stuck */
			ll = low + 1;
			hh = high;
			for (;;) {
				do
					ll++;
				while (arr[low] > arr[ll]);
				do
					hh--;
				while (arr[hh] > arr[low]);

				if (hh < ll)
					break;

				tmp = arr[ll];
				arr[ll] = arr[hh];
				arr[hh] = tmp;
			}

			/* Swap middle item (in position low) back into correct position */
			tmp = arr[low];
			arr[low] = arr[hh];
			arr[hh] = tmp;

			/* Re-set active partition */
			if (hh <= median)
				low = ll;
			if (hh >= median)
				high = hh - 1;
		}
	}	

	
	/**
	 * Quick Select algorithm for getting the nth item from the array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @return the selected item
	 */
	public static long quickSelect(long arr[], int n) {
		return quickSelect(arr, n, 0, arr.length - 1);
	}

	/**
	 * Quick Select algorithm for getting the nth item from a sub-array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @param low
	 *            the starting position in the array (inclusive)
	 * @param high
	 *            the ending position in the array (exclusive)
	 * @return the selected item
	 */
	public static long quickSelect(long arr[], int n, int low, int high) {
		high--; // make high inclusive

		int middle, ll, hh;
		long tmp = 0;
		final int median = (low + high) / 2;

		while (true) {
			if (high <= low) /* One element only */
				return arr[median];

			if (high == low + 1) { /* Two elements only */
				if (arr[low] > arr[high]) {
					tmp = arr[low];
					arr[low] = arr[high];
					arr[high] = tmp;
				}
				return arr[median];
			}

			/* Find median of low, middle and high items; swap into position low */
			middle = (low + high) / 2;
			if (arr[middle] > arr[high]) {
				tmp = arr[middle];
				arr[middle] = arr[high];
				arr[high] = tmp;
				;
			}
			if (arr[low] > arr[high]) {
				tmp = arr[low];
				arr[low] = arr[high];
				arr[high] = tmp;
			}
			if (arr[middle] > arr[low]) {
				tmp = arr[low];
				arr[low] = arr[middle];
				arr[middle] = tmp;
			}

			/* Swap low item (now in position middle) into position (low+1) */
			tmp = arr[middle];
			arr[middle] = arr[low + 1];
			arr[low + 1] = tmp;

			/* Nibble from each end towards middle, swapping items when stuck */
			ll = low + 1;
			hh = high;
			for (;;) {
				do
					ll++;
				while (arr[low] > arr[ll]);
				do
					hh--;
				while (arr[hh] > arr[low]);

				if (hh < ll)
					break;

				tmp = arr[ll];
				arr[ll] = arr[hh];
				arr[hh] = tmp;
			}

			/* Swap middle item (in position low) back into correct position */
			tmp = arr[low];
			arr[low] = arr[hh];
			arr[hh] = tmp;

			/* Re-set active partition */
			if (hh <= median)
				low = ll;
			if (hh >= median)
				high = hh - 1;
		}
	}	

	
	/**
	 * Quick Select algorithm for getting the nth item from the array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @return the selected item
	 */
	public static byte quickSelect(byte arr[], int n) {
		return quickSelect(arr, n, 0, arr.length - 1);
	}

	/**
	 * Quick Select algorithm for getting the nth item from a sub-array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @param low
	 *            the starting position in the array (inclusive)
	 * @param high
	 *            the ending position in the array (exclusive)
	 * @return the selected item
	 */
	public static byte quickSelect(byte arr[], int n, int low, int high) {
		high--; // make high inclusive

		int middle, ll, hh;
		byte tmp = 0;
		final int median = (low + high) / 2;

		while (true) {
			if (high <= low) /* One element only */
				return arr[median];

			if (high == low + 1) { /* Two elements only */
				if (arr[low] > arr[high]) {
					tmp = arr[low];
					arr[low] = arr[high];
					arr[high] = tmp;
				}
				return arr[median];
			}

			/* Find median of low, middle and high items; swap into position low */
			middle = (low + high) / 2;
			if (arr[middle] > arr[high]) {
				tmp = arr[middle];
				arr[middle] = arr[high];
				arr[high] = tmp;
				;
			}
			if (arr[low] > arr[high]) {
				tmp = arr[low];
				arr[low] = arr[high];
				arr[high] = tmp;
			}
			if (arr[middle] > arr[low]) {
				tmp = arr[low];
				arr[low] = arr[middle];
				arr[middle] = tmp;
			}

			/* Swap low item (now in position middle) into position (low+1) */
			tmp = arr[middle];
			arr[middle] = arr[low + 1];
			arr[low + 1] = tmp;

			/* Nibble from each end towards middle, swapping items when stuck */
			ll = low + 1;
			hh = high;
			for (;;) {
				do
					ll++;
				while (arr[low] > arr[ll]);
				do
					hh--;
				while (arr[hh] > arr[low]);

				if (hh < ll)
					break;

				tmp = arr[ll];
				arr[ll] = arr[hh];
				arr[hh] = tmp;
			}

			/* Swap middle item (in position low) back into correct position */
			tmp = arr[low];
			arr[low] = arr[hh];
			arr[hh] = tmp;

			/* Re-set active partition */
			if (hh <= median)
				low = ll;
			if (hh >= median)
				high = hh - 1;
		}
	}	

	
	/**
	 * Quick Select algorithm for getting the nth item from the array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @return the selected item
	 */
	public static short quickSelect(short arr[], int n) {
		return quickSelect(arr, n, 0, arr.length - 1);
	}

	/**
	 * Quick Select algorithm for getting the nth item from a sub-array as if it
	 * were sorted. Expected complexity is O(N); worst case is O(N^2). The input
	 * array will be reordered; clone it first if this is a problem.
	 * Implementation based on public domain code from Nicolas Devillard.
	 * 
	 * @see "http://ndevilla.free.fr/median/median/src/quickselect.c"
	 * 
	 * @param arr
	 *            the array to select from
	 * @param n
	 *            the item to select
	 * @param low
	 *            the starting position in the array (inclusive)
	 * @param high
	 *            the ending position in the array (exclusive)
	 * @return the selected item
	 */
	public static short quickSelect(short arr[], int n, int low, int high) {
		high--; // make high inclusive

		int middle, ll, hh;
		short tmp = 0;
		final int median = (low + high) / 2;

		while (true) {
			if (high <= low) /* One element only */
				return arr[median];

			if (high == low + 1) { /* Two elements only */
				if (arr[low] > arr[high]) {
					tmp = arr[low];
					arr[low] = arr[high];
					arr[high] = tmp;
				}
				return arr[median];
			}

			/* Find median of low, middle and high items; swap into position low */
			middle = (low + high) / 2;
			if (arr[middle] > arr[high]) {
				tmp = arr[middle];
				arr[middle] = arr[high];
				arr[high] = tmp;
				;
			}
			if (arr[low] > arr[high]) {
				tmp = arr[low];
				arr[low] = arr[high];
				arr[high] = tmp;
			}
			if (arr[middle] > arr[low]) {
				tmp = arr[low];
				arr[low] = arr[middle];
				arr[middle] = tmp;
			}

			/* Swap low item (now in position middle) into position (low+1) */
			tmp = arr[middle];
			arr[middle] = arr[low + 1];
			arr[low + 1] = tmp;

			/* Nibble from each end towards middle, swapping items when stuck */
			ll = low + 1;
			hh = high;
			for (;;) {
				do
					ll++;
				while (arr[low] > arr[ll]);
				do
					hh--;
				while (arr[hh] > arr[low]);

				if (hh < ll)
					break;

				tmp = arr[ll];
				arr[ll] = arr[hh];
				arr[hh] = tmp;
			}

			/* Swap middle item (in position low) back into correct position */
			tmp = arr[low];
			arr[low] = arr[hh];
			arr[hh] = tmp;

			/* Re-set active partition */
			if (hh <= median)
				low = ll;
			if (hh >= median)
				high = hh - 1;
		}
	}	

	
	/**
	 * Convert from Double[] to double[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public double[] convert(Double[] array) {
		double[] out = new double[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}
	
	/**
	 * Convert from Double[] to Double[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public Double[] convert(double[] array) {
		Double[] out = new Double[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}

	
	/**
	 * Convert from Float[] to float[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public float[] convert(Float[] array) {
		float[] out = new float[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}
	
	/**
	 * Convert from Float[] to Float[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public Float[] convert(float[] array) {
		Float[] out = new Float[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}

	
	/**
	 * Convert from Integer[] to int[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public int[] convert(Integer[] array) {
		int[] out = new int[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}
	
	/**
	 * Convert from Int[] to Integer[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public Integer[] convert(int[] array) {
		Integer[] out = new Integer[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}

	
	/**
	 * Convert from Long[] to long[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public long[] convert(Long[] array) {
		long[] out = new long[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}
	
	/**
	 * Convert from Long[] to Long[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public Long[] convert(long[] array) {
		Long[] out = new Long[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}

	
	/**
	 * Convert from Byte[] to byte[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public byte[] convert(Byte[] array) {
		byte[] out = new byte[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}
	
	/**
	 * Convert from Byte[] to Byte[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public Byte[] convert(byte[] array) {
		Byte[] out = new Byte[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}

	
	/**
	 * Convert from Short[] to short[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public short[] convert(Short[] array) {
		short[] out = new short[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}
	
	/**
	 * Convert from Short[] to Short[]. This will create a new array and copy the contents.
	 *
	 * @param array input array
	 * @return the converted array
	 */
	public Short[] convert(short[] array) {
		Short[] out = new Short[array.length];
		
		for (int i=0; i<array.length; i++) {
			out[i] = array[i];
		}
		
		return out;
	}

	
	/**
	 * Compute the p-norm of the array
	 * 
	 * @param array the array 
	 * @param p the p value
	 * @return the p-norm
	 */
	public static double pnorm(final double[] array, final int p) {
		double sum = 0;

		for (int i=0; i<array.length; i++)
			sum += Math.pow(Math.abs(array[i]), p);

		return Math.pow(sum, 1.0/p);
	}

	
	/**
	 * Compute the p-norm of the array
	 * 
	 * @param array the array 
	 * @param p the p value
	 * @return the p-norm
	 */
	public static double pnorm(final float[] array, final int p) {
		double sum = 0;

		for (int i=0; i<array.length; i++)
			sum += Math.pow(Math.abs(array[i]), p);

		return Math.pow(sum, 1.0/p);
	}

	
	/**
	 * Compute the p-norm of the array
	 * 
	 * @param array the array 
	 * @param p the p value
	 * @return the p-norm
	 */
	public static double pnorm(final int[] array, final int p) {
		double sum = 0;

		for (int i=0; i<array.length; i++)
			sum += Math.pow(Math.abs(array[i]), p);

		return Math.pow(sum, 1.0/p);
	}

	
	/**
	 * Compute the p-norm of the array
	 * 
	 * @param array the array 
	 * @param p the p value
	 * @return the p-norm
	 */
	public static double pnorm(final long[] array, final int p) {
		double sum = 0;

		for (int i=0; i<array.length; i++)
			sum += Math.pow(Math.abs(array[i]), p);

		return Math.pow(sum, 1.0/p);
	}

	
	/**
	 * Compute the p-norm of the array
	 * 
	 * @param array the array 
	 * @param p the p value
	 * @return the p-norm
	 */
	public static double pnorm(final byte[] array, final int p) {
		double sum = 0;

		for (int i=0; i<array.length; i++)
			sum += Math.pow(Math.abs(array[i]), p);

		return Math.pow(sum, 1.0/p);
	}

	
	/**
	 * Compute the p-norm of the array
	 * 
	 * @param array the array 
	 * @param p the p value
	 * @return the p-norm
	 */
	public static double pnorm(final short[] array, final int p) {
		double sum = 0;

		for (int i=0; i<array.length; i++)
			sum += Math.pow(Math.abs(array[i]), p);

		return Math.pow(sum, 1.0/p);
	}

	
}
