/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/core/core/src/main/jtemp/org/openimaj/data/#T#ArrayBackedDataSource.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.data;

import java.util.Iterator;
import java.util.Random;

import org.openimaj.util.array.ArrayIterator;

/**
 * A {@link DataSource} backed by a 2D array of shorts.
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 *
 */
public class ShortArrayBackedDataSource implements DataSource<short[]> {
	protected short[][] data;
	protected Random rng;
	
	/**
	 * Construct with data
	 * @param data the data
	 */
	public ShortArrayBackedDataSource(short[][] data) {
		this.data = data;
		this.rng = new Random();
	}
	
	/**
	 * Construct with data and a random generator for random sampling
	 * @param data the data
	 * @param rng the random generator
	 */
	public ShortArrayBackedDataSource(short[][] data, Random rng) {
		this.data = data;
		this.rng = rng;
	}

	@Override
	public final void getData(int startRow, int stopRow, short[][] output) {
		for (int i=startRow, j=0; i<stopRow; i++, j++)
			System.arraycopy(data[i], 0, output[j], 0, data[i].length);
	}

	@Override
	public final void getRandomRows(short[][] output) {
		final int k = output.length;
		final int [] ind = RandomData.getUniqueRandomInts(k, 0, data.length, rng);
		
		for (int i=0; i<k; i++)
			System.arraycopy(data[ind[i]], 0, output[i], 0, data[ind[i]].length);
	}

	@Override
	public int numDimensions() {
		return data[0].length;
	}

	@Override
	public int size() {
		return data.length;
	}
	
	@Override
	public short[] getData(int row) {
		return data[row];
	}
	
	@Override
	public Iterator<short[]> iterator() {
		return new ArrayIterator<short[]>(data);
	}
	
	@Override
	public short[][] createTemporaryArray(int size) {
		return new short[size][data[0].length];
	}
}