/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.capture;

import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.capture.Device;
import org.openimaj.video.capture.DeviceList;
import org.openimaj.video.capture.OpenIMAJGrabber;
import org.openimaj.video.capture.VideoCaptureException;

public class VideoCapture
extends Video<MBFImage> {
    public static final String DEFAULT_DEVICE_NUMBER_PROPERTY = "openimaj.grabber.camera";
    private OpenIMAJGrabber grabber;
    private MBFImage frame;
    private int width;
    private int height;
    private boolean isStopped;
    private double fps;
    private long captureStartedTimestamp;
    private long currentTimestamp;

    public VideoCapture(int width, int height) throws VideoCaptureException {
        Device defaultDevice;
        block12: {
            this.isStopped = true;
            this.fps = 25.0;
            this.captureStartedTimestamp = 0L;
            this.currentTimestamp = 0L;
            List<Device> devices = VideoCapture.getVideoDevices();
            defaultDevice = null;
            String defaultDeviceStr = System.getProperty(DEFAULT_DEVICE_NUMBER_PROPERTY);
            if (defaultDeviceStr != null) {
                try {
                    int i = Integer.parseInt(defaultDeviceStr);
                    if (i >= 0 && i < devices.size()) {
                        defaultDevice = devices.get(i);
                    } else {
                        System.err.println("Warning: The openimaj.grabber.camera property setting is out of range (0..<" + devices.size() + ") and will be ignored.");
                        System.err.println("Valid devices are:");
                        for (int x = 0; x < devices.size(); ++x) {
                            System.err.println(x + " : " + devices.get(x).getIdentifierStr());
                        }
                    }
                }
                catch (NumberFormatException e) {
                    for (Device d : devices) {
                        if (!d.getIdentifierStr().contains(defaultDeviceStr)) continue;
                        defaultDevice = d;
                        break;
                    }
                    if (defaultDevice != null) break block12;
                    System.err.println("Warning: The device name given by the openimaj.grabber.camera property (" + defaultDeviceStr + ") setting was not found and has been ignored.");
                    System.err.println("Valid devices are:");
                    for (int x = 0; x < devices.size(); ++x) {
                        System.err.println(x + " : " + devices.get(x).getIdentifierStr());
                    }
                }
            }
        }
        this.grabber = new OpenIMAJGrabber();
        if (defaultDevice == null) {
            if (!this.startSession(width, height, this.fps)) {
                throw new VideoCaptureException("No webcams found!");
            }
        } else if (!this.startSession(width, height, 0.0, defaultDevice)) {
            throw new VideoCaptureException("An error occured opening the capture device");
        }
    }

    public VideoCapture(int width, int height, Device device) throws VideoCaptureException {
        this.isStopped = true;
        this.fps = 25.0;
        this.captureStartedTimestamp = 0L;
        this.currentTimestamp = 0L;
        this.grabber = new OpenIMAJGrabber();
        if (!this.startSession(width, height, 0.0, device)) {
            throw new VideoCaptureException("An error occured opening the capture device");
        }
    }

    public VideoCapture(int width, int height, double fps, Device device) throws VideoCaptureException {
        this.isStopped = true;
        this.fps = 25.0;
        this.captureStartedTimestamp = 0L;
        this.currentTimestamp = 0L;
        this.fps = fps;
        this.grabber = new OpenIMAJGrabber();
        if (!this.startSession(width, height, fps, device)) {
            throw new VideoCaptureException("An error occured opening the capture device");
        }
    }

    public static List<Device> getVideoDevices() {
        OpenIMAJGrabber grabber = new OpenIMAJGrabber();
        DeviceList list = (DeviceList)((Object)grabber.getVideoDevices().get());
        return list.asArrayList();
    }

    protected synchronized boolean startSession(int requestedWidth, int requestedHeight, double requestedFPS, Device device) {
        int millisPerFrame = (int)(1000.0 / requestedFPS);
        if (this.grabber.startSession(requestedWidth, requestedHeight, millisPerFrame, (Pointer<Device>)Pointer.getPointer((NativeObject)device))) {
            this.width = this.grabber.getWidth();
            this.height = this.grabber.getHeight();
            this.frame = new MBFImage(this.width, this.height, ColourSpace.RGB);
            this.isStopped = false;
            return true;
        }
        return false;
    }

    protected synchronized boolean startSession(int requestedWidth, int requestedHeight, double requestedFPS) {
        int millisPerFrame = (int)(1000.0 / requestedFPS);
        if (this.grabber.startSession(requestedWidth, requestedHeight, millisPerFrame)) {
            this.width = this.grabber.getWidth();
            this.height = this.grabber.getHeight();
            this.frame = new MBFImage(this.width, this.height, ColourSpace.RGB);
            this.isStopped = false;
            return true;
        }
        return false;
    }

    public synchronized void stopCapture() {
        if (!this.isStopped) {
            this.isStopped = true;
            this.grabber.stopSession();
        }
    }

    public MBFImage getCurrentFrame() {
        return this.frame;
    }

    public synchronized MBFImage getNextFrame() {
        if (this.isStopped) {
            return this.frame;
        }
        int err = this.grabber.nextFrame();
        if (err == -1) {
            throw new RuntimeException(new VideoCaptureException("Timed out waiting for next frame"));
        }
        if (err < -1) {
            throw new RuntimeException(new VideoCaptureException("Error occurred getting next frame"));
        }
        Pointer<Byte> data = this.grabber.getImage();
        if (data == null) {
            return this.frame;
        }
        byte[] d = data.getBytes(this.width * this.height * 3);
        float[][] r = ((FImage)this.frame.bands.get((int)0)).pixels;
        float[][] g = ((FImage)this.frame.bands.get((int)1)).pixels;
        float[][] b = ((FImage)this.frame.bands.get((int)2)).pixels;
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int red = d[i + 0] & 0xFF;
                int green = d[i + 1] & 0xFF;
                int blue = d[i + 2] & 0xFF;
                r[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[red];
                g[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[green];
                b[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[blue];
                ++x;
                i += 3;
            }
        }
        ++this.currentFrame;
        if (this.captureStartedTimestamp == 0L) {
            this.captureStartedTimestamp = System.currentTimeMillis();
        }
        this.currentTimestamp = System.currentTimeMillis() - this.captureStartedTimestamp;
        return this.frame;
    }

    public boolean hasNextFrame() {
        return true;
    }

    public long countFrames() {
        return -1L;
    }

    public static void main(String[] args) throws VideoCaptureException {
        List<Device> devices = VideoCapture.getVideoDevices();
        for (Device d : devices) {
            System.out.println((Object)d);
        }
        if (devices.size() == 1) {
            VideoCapture grabber1 = new VideoCapture(640, 480, devices.get(0));
            VideoDisplay.createVideoDisplay((Video)grabber1);
        } else {
            int w = 320;
            int h = 240;
            double rate = 10.0;
            int i = 0;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3 && i < devices.size(); ++x, ++i) {
                    VideoCapture grabber2 = new VideoCapture(320, 240, 10.0, devices.get(i));
                    VideoDisplay disp = VideoDisplay.createVideoDisplay((Video)grabber2);
                    SwingUtilities.getRoot((Component)disp.getScreen()).setLocation(320 * x, 240 * y);
                }
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void reset() {
        this.stopCapture();
        this.startSession(this.width, this.height, this.fps);
    }

    public long getTimeStamp() {
        return this.currentTimestamp;
    }

    public void setCurrentFrameIndex(long newFrame) {
    }

    public double getFPS() {
        return this.fps;
    }

    public void setFPS(double fps) {
        this.fps = fps;
    }

    public void close() {
        this.stopCapture();
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

