/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.RotatedRectangle;
import org.openimaj.math.geometry.shape.Shape;

public class Rectangle
implements Shape,
ReadWriteable,
Serializable {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float width;
    public float height;

    public Rectangle() {
        this(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public Rectangle(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public Rectangle(Point2d topLeft, Point2d bottomRight) {
        this.x = topLeft.getX();
        this.y = topLeft.getY();
        this.width = bottomRight.getX() - this.x;
        this.height = bottomRight.getY() - this.y;
    }

    @Override
    public boolean isInside(Point2d point) {
        float px = point.getX();
        float py = point.getY();
        return px >= this.x && px <= this.x + this.width && py >= this.y && py <= this.y + this.height;
    }

    @Override
    public Rectangle calculateRegularBoundingBox() {
        return new Rectangle(Math.round(this.x), Math.round(this.y), Math.round(this.width), Math.round(this.height));
    }

    @Override
    public void translate(float x, float y) {
        this.x += x;
        this.y += y;
    }

    @Override
    public void scale(float sc) {
        this.x *= sc;
        this.y *= sc;
        this.width *= sc;
        this.height *= sc;
    }

    @Override
    public void scale(Point2d centre, float sc) {
        this.translate(-centre.getX(), -centre.getY());
        this.scale(sc);
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public void scaleCentroid(float sc) {
        Point2d centre = this.calculateCentroid();
        this.translate(-centre.getX(), -centre.getY());
        this.scale(sc);
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public Point2d calculateCentroid() {
        return new Point2dImpl(this.x + this.width / 2.0f, this.y + this.height / 2.0f);
    }

    @Override
    public double calculateArea() {
        return this.width * this.height;
    }

    @Override
    public double minX() {
        return this.x;
    }

    @Override
    public double minY() {
        return this.y;
    }

    @Override
    public double maxX() {
        return this.x + this.width;
    }

    @Override
    public double maxY() {
        return this.y + this.height;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public Point2d getTopLeft() {
        return new Point2dImpl((float)this.minX(), (float)this.minY());
    }

    public Point2d getBottomRight() {
        return new Point2dImpl((float)this.maxX(), (float)this.maxY());
    }

    @Override
    public Shape transform(Matrix transform) {
        return this.asPolygon().transform(transform);
    }

    @Override
    public Polygon asPolygon() {
        Polygon polygon = new Polygon();
        polygon.points.add(new Point2dImpl(this.x, this.y));
        polygon.points.add(new Point2dImpl(this.x + this.width, this.y));
        polygon.points.add(new Point2dImpl(this.x + this.width, this.y + this.height));
        polygon.points.add(new Point2dImpl(this.x, this.y + this.height));
        return polygon;
    }

    public void setBounds(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public String toString() {
        return String.format("Rectangle[x=%2.2f,y=%2.2f,width=%2.2f,height=%2.2f]", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public boolean isOverlapping(Rectangle other) {
        float left = this.x;
        float right = this.x + this.width;
        float top = this.y;
        float bottom = this.y + this.height;
        float otherleft = other.x;
        float otherright = other.x + other.width;
        float othertop = other.y;
        float otherbottom = other.y + other.height;
        return !(left > otherright || right < otherleft || top > otherbottom || bottom < othertop);
    }

    public boolean isInside(Rectangle that) {
        return this.x <= that.x && this.y <= that.y && this.x + this.width >= that.x + that.width && this.y + this.height >= that.y + that.height;
    }

    public Rectangle overlapping(Rectangle other) {
        if (!this.isOverlapping(other)) {
            return null;
        }
        float left = this.x;
        float right = this.x + this.width;
        float top = this.y;
        float bottom = this.y + this.height;
        float otherleft = other.x;
        float otherright = other.x + other.width;
        float othertop = other.y;
        float otherbottom = other.y + other.height;
        float overlapleft = Math.max(left, otherleft);
        float overlaptop = Math.max(top, othertop);
        float overlapwidth = Math.min(right, otherright) - overlapleft;
        float overlapheight = Math.min(bottom, otherbottom) - overlaptop;
        return new Rectangle(overlapleft, overlaptop, overlapwidth, overlapheight);
    }

    public double percentageOverlap(Rectangle other) {
        Rectangle overlap = this.overlapping(other);
        if (overlap == null) {
            return 0.0;
        }
        return overlap.calculateArea() / this.calculateArea();
    }

    public Rectangle union(Rectangle other) {
        float left = this.x;
        float right = this.x + this.width;
        float top = this.y;
        float bottom = this.y + this.height;
        float otherleft = other.x;
        float otherright = other.x + other.width;
        float othertop = other.y;
        float otherbottom = other.y + other.height;
        float intersectleft = Math.min(left, otherleft);
        float intersecttop = Math.min(top, othertop);
        float intersectwidth = Math.max(right, otherright) - intersectleft;
        float intersectheight = Math.max(bottom, otherbottom) - intersecttop;
        return new Rectangle(intersectleft, intersecttop, intersectwidth, intersectheight);
    }

    @Override
    public double intersectionArea(Shape that) {
        return this.intersectionArea(that, 1);
    }

    @Override
    public double intersectionArea(Shape that, int nStepsPerDimention) {
        Rectangle overlapping = this.calculateRegularBoundingBox().overlapping(that.calculateRegularBoundingBox());
        if (overlapping == null) {
            return 0.0;
        }
        if (that instanceof Rectangle) {
            return overlapping.calculateArea();
        }
        double intersection = 0.0;
        double step = (double)Math.max(overlapping.width, overlapping.height) / (double)nStepsPerDimention;
        double nReads = 0.0;
        float x = overlapping.x;
        while (x < overlapping.x + overlapping.width) {
            float y = overlapping.y;
            while (y < overlapping.y + overlapping.height) {
                boolean insideThis = this.isInside(new Point2dImpl(x, y));
                boolean insideThat = that.isInside(new Point2dImpl(x, y));
                nReads += 1.0;
                if (insideThis && insideThat) {
                    intersection += 1.0;
                }
                y = (float)((double)y + step);
            }
            x = (float)((double)x + step);
        }
        return intersection / nReads * (double)(overlapping.width * overlapping.height);
    }

    public void readASCII(Scanner in) throws IOException {
        this.x = in.nextFloat();
        this.y = in.nextFloat();
        this.width = in.nextFloat();
        this.height = in.nextFloat();
    }

    public String asciiHeader() {
        return "Rectangle";
    }

    public void readBinary(DataInput in) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.width = in.readFloat();
        this.height = in.readFloat();
    }

    public byte[] binaryHeader() {
        return "Rectangle".getBytes();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.write(String.format("%f %f %f %f\n", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height)));
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.width);
        out.writeFloat(this.height);
    }

    @Override
    public Rectangle clone() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.height);
        result = 31 * result + Float.floatToIntBits(this.width);
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (Float.floatToIntBits(this.width) != Float.floatToIntBits(other.width)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }

    @Override
    public double calculatePerimeter() {
        return 2.0f * (this.width + this.height);
    }

    @Override
    public RotatedRectangle minimumBoundingRectangle() {
        return new RotatedRectangle(this, 0.0f);
    }

    public RotatedRectangle rotate(Point2d p, double angle) {
        Point2dImpl c = (Point2dImpl)this.calculateCentroid();
        float sin = (float)Math.sin(angle);
        float cos = (float)Math.cos(angle);
        c.translate(-p.getX(), -p.getY());
        float xnew = c.x * cos - c.y * sin;
        float ynew = c.x * sin + c.y * cos;
        c.x = xnew;
        c.y = ynew;
        c.translate(p);
        return new RotatedRectangle((double)c.x, (double)c.y, (double)this.width, (double)this.height, angle);
    }

    @Override
    public boolean isConvex() {
        return true;
    }
}

