/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.line;

import Jama.Matrix;
import java.util.Arrays;
import org.openimaj.math.geometry.GeometricObject;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Rectangle;

public class Line2d
implements GeometricObject,
Cloneable {
    public Point2d begin;
    public Point2d end;

    public Line2d() {
    }

    public Line2d(Point2d begin, Point2d end) {
        this.begin = begin;
        this.end = end;
    }

    public Line2d(float x1, float y1, float x2, float y2) {
        this.begin = new Point2dImpl(x1, y1);
        this.end = new Point2dImpl(x2, y2);
    }

    public void setBeginPoint(Point2d begin) {
        this.begin = begin;
    }

    public void setEndPoint(Point2d end) {
        this.end = end;
    }

    public Point2d getBeginPoint() {
        return this.begin;
    }

    public Point2d getEndPoint() {
        return this.end;
    }

    public Point2d setEndPoint() {
        return this.end;
    }

    public IntersectionResult getIntersection(Line2d otherLine) {
        double denom = (otherLine.end.getY() - otherLine.begin.getY()) * (this.end.getX() - this.begin.getX()) - (otherLine.end.getX() - otherLine.begin.getX()) * (this.end.getY() - this.begin.getY());
        double numea = (otherLine.end.getX() - otherLine.begin.getX()) * (this.begin.getY() - otherLine.begin.getY()) - (otherLine.end.getY() - otherLine.begin.getY()) * (this.begin.getX() - otherLine.begin.getX());
        double numeb = (this.end.getX() - this.begin.getX()) * (this.begin.getY() - otherLine.begin.getY()) - (this.end.getY() - this.begin.getY()) * (this.begin.getX() - otherLine.begin.getX());
        if (denom == 0.0) {
            if (numea == 0.0 && numeb == 0.0) {
                return new IntersectionResult(IntersectionType.COINCIDENT);
            }
            return new IntersectionResult(IntersectionType.PARALLEL);
        }
        double ua = numea / denom;
        double ub = numeb / denom;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
            double intX = (double)this.begin.getX() + ua * (double)(this.end.getX() - this.begin.getX());
            double intY = (double)this.begin.getY() + ua * (double)(this.end.getY() - this.begin.getY());
            return new IntersectionResult(new Point2dImpl((float)intX, (float)intY));
        }
        return new IntersectionResult(IntersectionType.NOT_INTERESECTING);
    }

    public Point2d reflectAroundLine(Point2d pointToReflect) {
        double nx = this.end.getX() - this.begin.getX();
        double ny = this.end.getY() - this.begin.getY();
        double d = Math.sqrt(nx * nx + ny * ny);
        double px = pointToReflect.getX() - this.begin.getX();
        double py = pointToReflect.getY() - this.begin.getY();
        double w = (nx /= d) * px + (ny /= d) * py;
        double rx = (double)(2.0f * this.begin.getX() - pointToReflect.getX()) + 2.0 * w * nx;
        double ry = (double)(2.0f * this.begin.getY() - pointToReflect.getY()) + 2.0 * w * ny;
        return new Point2dImpl((float)rx, (float)ry);
    }

    float CalcY(float xval, float x0, float y0, float x1, float y1) {
        if (x1 == x0) {
            return Float.NaN;
        }
        return y0 + (xval - x0) * (y1 - y0) / (x1 - x0);
    }

    float CalcX(float yval, float x0, float y0, float x1, float y1) {
        if (y1 == y0) {
            return Float.NaN;
        }
        return x0 + (yval - y0) * (x1 - x0) / (y1 - y0);
    }

    public Line2d lineWithinSquare(Rectangle r) {
        boolean beginInside = r.isInside(this.begin);
        int nInside = (beginInside ? 1 : 0) + (r.isInside(this.end) ? 1 : 0);
        if (nInside == 2) {
            return new Line2d(this.begin.copy(), this.end.copy());
        }
        Point2dImpl begin = null;
        Point2dImpl end = null;
        float x0 = this.begin.getX();
        float y0 = this.begin.getY();
        float x1 = this.end.getX();
        float y1 = this.end.getY();
        float bottom = r.y + r.height;
        float top = r.y;
        float left = r.x;
        float right = r.x + r.width;
        float bottomIntersect = this.CalcX(bottom, x0, y0, x1, y1);
        float topIntersect = this.CalcX(top, x0, y0, x1, y1);
        float leftIntersect = this.CalcY(left, x0, y0, x1, y1);
        float rightIntersect = this.CalcY(right, x0, y0, x1, y1);
        if (bottomIntersect <= right && bottomIntersect >= left && end == null) {
            end = new Point2dImpl(bottomIntersect, bottom);
        }
        if (topIntersect <= right && topIntersect >= left) {
            if (end == null) {
                end = new Point2dImpl(topIntersect, top);
            } else if (begin == null && ((Object)end).equals(begin = new Point2dImpl(topIntersect, top))) {
                end = null;
            }
        }
        if (leftIntersect >= top && leftIntersect <= bottom) {
            if (end == null) {
                end = new Point2dImpl(left, leftIntersect);
            } else if (begin == null && ((Object)end).equals(begin = new Point2dImpl(left, leftIntersect))) {
                end = null;
            }
        }
        if (rightIntersect >= top && rightIntersect <= bottom) {
            if (end == null) {
                end = new Point2dImpl(right, rightIntersect);
            } else if (begin == null && ((Object)end).equals(begin = new Point2dImpl(right, rightIntersect))) {
                end = null;
            }
        }
        if (end == null || begin == null) {
            return null;
        }
        if (nInside == 0) {
            if (Line2d.distance(this.end, end) < Line2d.distance(this.end, begin) == Line2d.distance(this.begin, end) < Line2d.distance(this.begin, begin)) {
                return null;
            }
            return new Line2d(begin, end);
        }
        if (beginInside) {
            if (Line2d.distance(this.end, end) < Line2d.distance(this.end, begin)) {
                return new Line2d(this.begin, end);
            }
            return new Line2d(this.begin, begin);
        }
        if (Line2d.distance(this.begin, begin) < Line2d.distance(this.begin, end)) {
            return new Line2d(begin, this.end);
        }
        return new Line2d(end, this.end);
    }

    public static double distance(Point2d p1, Point2d p2) {
        return Math.sqrt((p1.getX() - p2.getX()) * (p1.getX() - p2.getX()) + (p1.getY() - p2.getY()) * (p1.getY() - p2.getY()));
    }

    public static double distance(float p1x, float p1y, float p2x, float p2y) {
        return Math.sqrt((p1x - p2x) * (p1x - p2x) + (p1y - p2y) * (p1y - p2y));
    }

    public static Line2d lineFromRotation(int x1, int y1, double theta, int length) {
        int x2 = x1 + (int)Math.round(Math.cos(theta) * (double)length);
        int y2 = y1 + (int)Math.round(Math.sin(theta) * (double)length);
        return new Line2d(new Point2dImpl(x1, y1), new Point2dImpl(x2, y2));
    }

    public double calculateLength() {
        return Line2d.distance(this.begin, this.end);
    }

    public double calculateHorizontalAngle() {
        return Math.atan((this.end.getY() - this.begin.getY()) / (this.end.getX() - this.begin.getX()));
    }

    public double calculateVerticalAngle() {
        return Math.atan((this.end.getX() - this.begin.getX()) / (this.end.getY() - this.begin.getY()));
    }

    @Override
    public Line2d transform(Matrix transform) {
        return new Line2d(this.begin.transform(transform), this.end.transform(transform));
    }

    public Line2d getNormal() {
        float dx = this.end.getX() - this.begin.getX();
        float dy = this.end.getY() - this.begin.getY();
        return new Line2d(new Point2dImpl(-dy, dx), new Point2dImpl(dy, -dx));
    }

    public Line2d getNormal(Point2d p) {
        return new Line2d(this.reflectAroundLine(p), p);
    }

    @Override
    public void translate(float x, float y) {
        this.begin.translate(x, y);
        this.end.translate(x, y);
    }

    public boolean isOnLine(Point2d p, float tolerance) {
        if (this.begin.getX() == this.end.getX() && this.begin.getX() == p.getX()) {
            return true;
        }
        if (this.begin.getY() == this.end.getY() && this.begin.getY() == p.getY()) {
            return true;
        }
        float a = (this.end.getY() - this.begin.getY()) / (this.end.getX() - this.begin.getX());
        float b = this.begin.getY() - a * this.begin.getX();
        return Math.abs(p.getY() - (a * p.getX() + b)) < tolerance;
    }

    public boolean isInLine(Point2d p, float tolerance) {
        float bx = this.begin.getX() <= this.end.getX() ? this.begin.getX() : this.end.getX();
        float ex = this.begin.getX() > this.end.getX() ? this.begin.getX() : this.end.getX();
        return this.isOnLine(p, tolerance) && p.getX() + tolerance > bx && p.getX() + tolerance < ex;
    }

    public String toString() {
        return "Line(" + this.begin + "->" + this.end + ")";
    }

    @Override
    public Rectangle calculateRegularBoundingBox() {
        float x = Math.min(this.begin.getX(), this.end.getX());
        float y = Math.min(this.begin.getY(), this.end.getY());
        float width = Math.abs(this.begin.getX() - this.end.getX());
        float height = Math.abs(this.begin.getY() - this.end.getY());
        return new Rectangle(x, y, width, height);
    }

    @Override
    public void scale(float sc) {
        this.begin.setX(this.begin.getX() * sc);
        this.begin.setY(this.begin.getY() * sc);
        this.end.setX(this.end.getX() * sc);
        this.end.setY(this.end.getY() * sc);
    }

    @Override
    public void scale(Point2d centre, float sc) {
        this.translate(-centre.getX(), -centre.getY());
        this.begin.setX(this.begin.getX() * sc);
        this.begin.setY(this.begin.getY() * sc);
        this.end.setX(this.end.getX() * sc);
        this.end.setY(this.end.getY() * sc);
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public void scaleCentroid(float sc) {
        this.scale(this.calculateCentroid(), sc);
    }

    @Override
    public Point2d calculateCentroid() {
        float xSum = this.begin.getX() + this.end.getX();
        float ySum = this.begin.getY() + this.end.getY();
        return new Point2dImpl(xSum /= 2.0f, ySum /= 2.0f);
    }

    @Override
    public double minX() {
        return Math.min(this.begin.getX(), this.end.getX());
    }

    @Override
    public double minY() {
        return Math.min(this.begin.getY(), this.end.getY());
    }

    @Override
    public double maxX() {
        return Math.max(this.begin.getX(), this.end.getX());
    }

    @Override
    public double maxY() {
        return Math.max(this.begin.getY(), this.end.getY());
    }

    @Override
    public double getWidth() {
        return Math.abs(this.begin.getX() - this.end.getX());
    }

    @Override
    public double getHeight() {
        return Math.abs(this.begin.getY() - this.end.getY());
    }

    public Point2dImpl toUnitVector() {
        float dx = this.end.getX() - this.begin.getX();
        float dy = this.end.getY() - this.begin.getY();
        float norm = (float)Math.sqrt(dx * dx + dy * dy);
        return new Point2dImpl(dx / norm, dy / norm);
    }

    public Line2d clone() {
        return new Line2d(this.begin.copy(), this.end.copy());
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.begin, this.end});
    }

    public boolean equals(Object other) {
        if (!(other instanceof Line2d)) {
            return false;
        }
        Line2d o = (Line2d)other;
        return o.begin.equals(this.begin) && o.end.equals(this.end);
    }

    public static class IntersectionResult {
        public IntersectionType type;
        public Point2d intersectionPoint;

        public IntersectionResult(IntersectionType type) {
            this.type = type;
        }

        public IntersectionResult(Point2d point) {
            this.type = IntersectionType.INTERSECTING;
            this.intersectionPoint = point;
        }
    }

    public static enum IntersectionType {
        INTERSECTING,
        PARALLEL,
        COINCIDENT,
        NOT_INTERESECTING;

    }
}

