/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel;

import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.image.renderer.ScanRasteriser;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.RotatedRectangle;
import org.openimaj.math.geometry.shape.Shape;

public class ConnectedComponent
extends PixelSet {
    public ConnectedComponent() {
    }

    public ConnectedComponent(Shape shape) {
        this.fromShape(shape);
    }

    public ConnectedComponent(Polygon poly) {
        if (poly.getNumInnerPoly() == 1) {
            ScanRasteriser.scanFill(poly.points, new ScanRasteriser.ScanLineListener(){

                @Override
                public void process(int x1, int x2, int y) {
                    for (int x = x1; x <= x2; ++x) {
                        ConnectedComponent.this.addPixel(x, y);
                    }
                }
            });
        } else {
            this.fromShape((Shape)poly);
        }
    }

    public ConnectedComponent(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public ConnectedComponent(int[][] img) {
        super(img);
    }

    public ConnectedComponent(FImage mask, float thresh) {
        super(mask, thresh);
    }

    public ConnectedComponent(Set<Pixel> pixels) {
        super(pixels);
    }

    public int estimateNumberOfVertices(int smoothWidth, int windowWidth) {
        int k;
        int j;
        float sum;
        int i;
        TFloatArrayList distances = this.calculateBoundaryDistanceFromCentre();
        if (smoothWidth % 2 == 0) {
            ++smoothWidth;
        }
        if (windowWidth % 2 == 0) {
            ++windowWidth;
        }
        int n = distances.size();
        float[] kernel = new float[windowWidth];
        float[] response = new float[n];
        for (i = 0; i < n; ++i) {
            sum = 0.0f;
            for (j = 0; j < smoothWidth; ++j) {
                k = i + j - smoothWidth / 2;
                if (k < 0) {
                    k = n + k;
                } else if (k >= n) {
                    k -= n;
                }
                sum += distances.get(k);
            }
            distances.set(i, sum / (float)smoothWidth);
        }
        for (i = 0; i < windowWidth; ++i) {
            kernel[i] = -(windowWidth / 2) + i;
        }
        for (i = 0; i < n; ++i) {
            sum = 0.0f;
            for (j = 0; j < windowWidth; ++j) {
                k = i + j - windowWidth / 2;
                if (k < 0) {
                    k = n + k;
                } else if (k >= n) {
                    k -= n;
                }
                sum += kernel[j] * distances.get(k);
            }
            response[i] = sum;
        }
        int peaks = 0;
        for (int i2 = 1; i2 < n; ++i2) {
            if (!(response[i2 - 1] >= 0.0f) || !(response[i2] < 0.0f)) continue;
            ++peaks;
        }
        if (response[n - 1] >= 0.0f && response[0] < 0.0f) {
            ++peaks;
        }
        return peaks;
    }

    protected int isLeft(Pixel P0, Pixel P1, Pixel P2) {
        return (P1.x - P0.x) * (P2.y - P0.y) - (P2.x - P0.x) * (P1.y - P0.y);
    }

    public Polygon calculateConvexHull() {
        return this.calculateConvexHull_AndrewsMontone();
    }

    public double calculateAreaRatio(ConnectedComponent ch) {
        return (double)this.calculateArea() / (double)ch.calculateArea();
    }

    public double calculateAreaRatio(Polygon ch) {
        return this.calculateAreaRatio(new ConnectedComponent(ch));
    }

    public double calculatePercentageConvexHullFit() {
        return this.calculateAreaRatio(this.calculateConvexHull());
    }

    protected Polygon calculateConvexHull_Melkman(List<Pixel> V) {
        int n = V.size();
        Pixel[] D = new Pixel[2 * n + 1];
        int bot = n - 2;
        int top = bot + 3;
        D[bot] = D[top] = V.get(2);
        if (this.isLeft(V.get(0), V.get(1), V.get(2)) > 0) {
            D[bot + 1] = V.get(0);
            D[bot + 2] = V.get(1);
        } else {
            D[bot + 1] = V.get(1);
            D[bot + 2] = V.get(0);
        }
        for (int i = 3; i < n; ++i) {
            if (this.isLeft(D[bot], D[bot + 1], V.get(i)) > 0 && this.isLeft(D[top - 1], D[top], V.get(i)) > 0) continue;
            while (this.isLeft(D[bot], D[bot + 1], V.get(i)) <= 0) {
                ++bot;
            }
            D[--bot] = V.get(i);
            while (this.isLeft(D[top - 1], D[top], V.get(i)) <= 0) {
                --top;
            }
            D[++top] = V.get(i);
        }
        Polygon H = new Polygon();
        List vertices = H.getVertices();
        for (int h = 0; h <= top - bot; ++h) {
            vertices.add(D[bot + h]);
        }
        return H;
    }

    protected Polygon calculateConvexHull_AndrewsMontone() {
        int i;
        if (this.calculateArea() == 1) {
            return new Polygon(new Point2d[]{(Point2d)this.pixels.iterator().next()});
        }
        ArrayList<Pixel> P = new ArrayList<Pixel>();
        int minx = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxy = Integer.MIN_VALUE;
        for (Pixel p : this.pixels) {
            if (p.x < minx) {
                minx = p.x;
            }
            if (p.x > maxx) {
                maxx = p.x;
            }
            if (p.y < miny) {
                miny = p.y;
            }
            if (p.y <= maxy) continue;
            maxy = p.y;
        }
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                Pixel p = new Pixel(x, y);
                if (!this.pixels.contains(p)) continue;
                P.add(p);
            }
        }
        int bot = 0;
        int top = -1;
        int n = P.size();
        Polygon poly = new Polygon();
        Pixel[] H = new Pixel[P.size()];
        boolean minmin = false;
        float xmin = ((Pixel)P.get((int)0)).x;
        for (i = 1; i < n && (float)((Pixel)P.get((int)i)).x == xmin; ++i) {
        }
        int minmax = i - 1;
        if (minmax == n - 1) {
            H[++top] = (Pixel)P.get(0);
            if (((Pixel)P.get((int)minmax)).y != ((Pixel)P.get((int)0)).y) {
                H[++top] = (Pixel)P.get(minmax);
            }
            H[++top] = (Pixel)P.get(0);
            for (int k = 0; k < top + 1; ++k) {
                poly.getVertices().add(H[k]);
            }
            return poly;
        }
        int maxmax = n - 1;
        float xmax = ((Pixel)P.get((int)(n - 1))).x;
        for (i = n - 2; i >= 0 && (float)((Pixel)P.get((int)i)).x == xmax; --i) {
        }
        int maxmin = i + 1;
        H[++top] = (Pixel)P.get(0);
        i = minmax;
        while (++i <= maxmin) {
            if (this.isLeft((Pixel)P.get(0), (Pixel)P.get(maxmin), (Pixel)P.get(i)) >= 0 && i < maxmin) continue;
            while (top > 0 && this.isLeft(H[top - 1], H[top], (Pixel)P.get(i)) <= 0) {
                --top;
            }
            H[++top] = (Pixel)P.get(i);
        }
        if (maxmax != maxmin) {
            H[++top] = (Pixel)P.get(maxmax);
        }
        bot = top;
        i = maxmin;
        while (--i >= minmax) {
            if (this.isLeft((Pixel)P.get(maxmax), (Pixel)P.get(minmax), (Pixel)P.get(i)) >= 0 && i > minmax) continue;
            while (top > bot && this.isLeft(H[top - 1], H[top], (Pixel)P.get(i)) <= 0) {
                --top;
            }
            H[++top] = (Pixel)P.get(i);
        }
        if (minmax != 0) {
            H[++top] = (Pixel)P.get(0);
        }
        for (int k = 0; k < top + 1; ++k) {
            poly.getVertices().add(H[k]);
        }
        return poly;
    }

    protected Pixel nextEdgePixelACW4(Pixel current, int lastdir) {
        return this.nextEdgePixelACW4(current, lastdir, null);
    }

    protected Pixel nextEdgePixelACW4(Pixel current, int lastdir, List<Pixel> outer) {
        int startdir = (lastdir + 3) % 4;
        Pixel[] target = new Pixel[]{new Pixel(current.x + 1, current.y), new Pixel(current.x, current.y - 1), new Pixel(current.x - 1, current.y), new Pixel(current.x, current.y + 1)};
        for (int i = 0; i < 4; ++i) {
            int dir = startdir + i;
            if (dir >= 4) {
                dir -= 4;
            }
            if (this.pixels.contains(target[dir])) {
                return target[dir];
            }
            if (outer == null) continue;
            outer.add(target[dir]);
        }
        return current;
    }

    protected Pixel nextEdgePixelACW8(Pixel current, int lastdir) {
        int startdir = (lastdir + 7 - lastdir % 2) % 8;
        Pixel[] target = new Pixel[]{new Pixel(current.x + 1, current.y), new Pixel(current.x + 1, current.y - 1), new Pixel(current.x, current.y - 1), new Pixel(current.x - 1, current.y - 1), new Pixel(current.x - 1, current.y), new Pixel(current.x - 1, current.y + 1), new Pixel(current.x, current.y + 1), new Pixel(current.x + 1, current.y + 1)};
        for (int i = 0; i < 8; ++i) {
            int dir = startdir + i;
            if (dir >= 8) {
                dir -= 8;
            }
            if (!this.pixels.contains(target[dir])) continue;
            return target[dir];
        }
        return current;
    }

    protected int code4(Pixel current, Pixel next) {
        if (current.x - 1 == next.x) {
            return 2;
        }
        if (current.y + 1 == next.y) {
            return 3;
        }
        if (current.x + 1 == next.x) {
            return 0;
        }
        if (current.y - 1 == next.y) {
            return 1;
        }
        return -1;
    }

    protected int code8(Pixel current, Pixel next) {
        if (current.x + 1 == next.x && current.y == next.y) {
            return 0;
        }
        if (current.x + 1 == next.x && current.y - 1 == next.y) {
            return 1;
        }
        if (current.x == next.x && current.y - 1 == next.y) {
            return 2;
        }
        if (current.x - 1 == next.x && current.y - 1 == next.y) {
            return 3;
        }
        if (current.x - 1 == next.x && current.y == next.y) {
            return 4;
        }
        if (current.x - 1 == next.x && current.y + 1 == next.y) {
            return 5;
        }
        if (current.x == next.x && current.y + 1 == next.y) {
            return 6;
        }
        if (current.x + 1 == next.x && current.y + 1 == next.y) {
            return 7;
        }
        return -1;
    }

    public Polygon toPolygon() {
        Polygon poly = new Polygon();
        for (Pixel p : this.getInnerBoundary(ConnectMode.CONNECT_4)) {
            poly.getVertices().add(p);
        }
        return poly;
    }

    public List<Pixel> getInnerBoundary(ConnectMode mode) {
        Pixel start;
        ArrayList<Pixel> pset = new ArrayList<Pixel>();
        Pixel current = start = this.topLeftMostPixel();
        block0 : switch (mode) {
            case CONNECT_4: {
                int dir = 3;
                while (true) {
                    Pixel next = this.nextEdgePixelACW4(current, dir);
                    if (pset.size() >= 2 && next.equals(pset.get(1)) && current.equals(start)) break block0;
                    dir = this.code4(current, next);
                    pset.add(current);
                    current = next;
                }
            }
            case CONNECT_8: {
                int dir = 7;
                while (true) {
                    Pixel next = this.nextEdgePixelACW8(current, dir);
                    if (pset.size() >= 2 && next.equals(pset.get(1)) && current.equals(start)) break block0;
                    dir = this.code8(current, next);
                    pset.add(current);
                    current = next;
                }
            }
        }
        return pset;
    }

    public List<Pixel> getOuterBoundary() {
        Pixel start;
        ArrayList<Pixel> pset = new ArrayList<Pixel>();
        List<Pixel> outer = new ArrayList<Pixel>();
        Pixel current = start = this.topLeftMostPixel();
        int dir = 3;
        while (true) {
            Pixel next = this.nextEdgePixelACW4(current, dir, outer);
            if (pset.size() >= 2 && next.equals(pset.get(1)) && current.equals(start) || this.pixels.size() == 1) break;
            dir = this.code4(current, next);
            pset.add(current);
            current = next;
        }
        if (outer.size() > 4) {
            for (int i = 3; i > 0; --i) {
                boolean found = true;
                for (int j = 0; j < i; ++j) {
                    if (((Pixel)outer.get(j)).equals(outer.get(outer.size() - i + j))) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                outer = outer.subList(0, outer.size() - i);
                break;
            }
        }
        return outer;
    }

    public TIntArrayList freemanChainCode(ConnectMode mode) {
        Pixel start;
        TIntArrayList code = new TIntArrayList();
        Pixel current = start = this.topLeftMostPixel();
        switch (mode) {
            case CONNECT_8: {
                Pixel next;
                int dir = 7;
                while (!(next = this.nextEdgePixelACW8(current, dir)).equals(start)) {
                    dir = this.code8(current, next);
                    code.add(dir);
                    current = next;
                }
                code.add(this.code8(current, next));
                break;
            }
            case CONNECT_4: {
                Pixel next;
                int dir = 3;
                while (!(next = this.nextEdgePixelACW4(current, dir)).equals(start)) {
                    dir = this.code4(current, next);
                    code.add(dir);
                    current = next;
                }
                code.add(this.code4(current, next));
            }
        }
        return code;
    }

    public static void process(Collection<ConnectedComponent> components, ConnectedComponentProcessor p) {
        for (ConnectedComponent c : components) {
            c.processInplace(p);
        }
    }

    public ConnectedComponent process(ConnectedComponentProcessor p) {
        ConnectedComponent tmp = this.clone();
        p.process(tmp);
        return tmp;
    }

    public ConnectedComponent processInplace(ConnectedComponentProcessor p) {
        p.process(this);
        return this;
    }

    public static ConnectedComponent floodFill(FImage image, Pixel start) {
        ConnectedComponent cc = new ConnectedComponent();
        float val = image.pixels[start.y][start.x];
        int[][] output = new int[image.height][image.width];
        LinkedHashSet<Pixel> queue = new LinkedHashSet<Pixel>();
        if (image.pixels[start.y][start.x] > val) {
            return cc;
        }
        queue.add(start);
        while (queue.size() > 0) {
            Pixel n = (Pixel)queue.iterator().next();
            queue.remove(n);
            if (!(image.pixels[n.y][n.x] <= val)) continue;
            int e = n.x;
            for (int w = n.x; w > 0 && image.pixels[n.y][w - 1] <= val; --w) {
            }
            while (e < image.width - 1 && image.pixels[n.y][e + 1] <= val) {
                ++e;
            }
            for (int i = w; i <= e; ++i) {
                output[n.y][i] = 1;
                cc.addPixel(i, n.y);
                int north = n.y - 1;
                int south = n.y + 1;
                if (north >= 0 && image.pixels[north][i] <= val && output[north][i] != 1) {
                    queue.add(new Pixel(i, north));
                }
                if (south >= image.height || !(image.pixels[south][i] <= val) || output[south][i] == 1) continue;
                queue.add(new Pixel(i, south));
            }
        }
        return cc;
    }

    public ConnectedComponent clone() {
        try {
            ConnectedComponent tmp = (ConnectedComponent)super.clone();
            tmp.pixels = new HashSet();
            for (Pixel p : this.pixels) {
                tmp.pixels.add(p.clone());
            }
            return tmp;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public TFloatArrayList calculateBoundaryDistanceFromCentre() {
        TFloatArrayList distances = new TFloatArrayList();
        List<Pixel> bound = this.getInnerBoundary(ConnectMode.CONNECT_8);
        double[] centroid = this.calculateCentroid();
        for (Pixel p : bound) {
            float dist = (float)Math.sqrt((centroid[0] - (double)p.x) * (centroid[0] - (double)p.x) + (centroid[1] - (double)p.y) * (centroid[1] - (double)p.y));
            distances.add(dist);
        }
        return distances;
    }

    @Override
    public String asciiHeader() {
        return "ConnectedComponent";
    }

    @Override
    public byte[] binaryHeader() {
        return "CC".getBytes();
    }

    public double calculateOrientatedBoundingBoxAspectRatio() {
        RotatedRectangle r = this.toPolygon().minimumBoundingRectangle();
        return r.height / r.width;
    }

    public RotatedRectangle calculateOrientatedBoundingBox() {
        return this.toPolygon().minimumBoundingRectangle();
    }

    public static enum ConnectMode {
        CONNECT_4,
        CONNECT_8;


        public List<Pixel> getNeighbours(FImage image, int x, int y, float bgThreshold) {
            ArrayList<Pixel> neighbours = new ArrayList<Pixel>(this == CONNECT_8 ? 8 : 4);
            switch (this) {
                case CONNECT_8: {
                    if (x > 0 && y > 0 && image.pixels[y - 1][x - 1] > bgThreshold) {
                        neighbours.add(new Pixel(x - 1, y - 1));
                    }
                    if (x + 1 < image.width && y > 0 && image.pixels[y - 1][x + 1] > bgThreshold) {
                        neighbours.add(new Pixel(x + 1, y - 1));
                    }
                    if (x > 0 && y + 1 < image.height && image.pixels[y + 1][x - 1] > bgThreshold) {
                        neighbours.add(new Pixel(x - 1, y + 1));
                    }
                    if (x + 1 < image.width && y + 1 < image.height && image.pixels[y + 1][x + 1] > bgThreshold) {
                        neighbours.add(new Pixel(x + 1, y + 1));
                    }
                }
                case CONNECT_4: {
                    if (x > 0 && image.pixels[y][x - 1] > bgThreshold) {
                        neighbours.add(new Pixel(x - 1, y));
                    }
                    if (x + 1 < image.width && image.pixels[y][x + 1] > bgThreshold) {
                        neighbours.add(new Pixel(x + 1, y));
                    }
                    if (y > 0 && image.pixels[y - 1][x] > bgThreshold) {
                        neighbours.add(new Pixel(x, y - 1));
                    }
                    if (y + 1 >= image.height || !(image.pixels[y + 1][x] > bgThreshold)) break;
                    neighbours.add(new Pixel(x, y + 1));
                }
            }
            return neighbours;
        }
    }
}

