/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import gnu.trove.set.hash.TLongHashSet;
import org.openimaj.feature.FVComparator;
import org.openimaj.feature.SparseLongFV;
import org.openimaj.math.util.distance.HammingUtils;
import org.openimaj.util.array.SparseLongArray;

public enum SparseLongFVComparison implements FVComparator<SparseLongFV>
{
    EUCLIDEAN(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double d = 0.0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                double diff = e.value - e.otherValue;
                d += diff * diff;
            }
            return Math.sqrt(d);
        }
    }
    ,
    CORRELATION(false){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double N = h1.length;
            double SH1 = 0.0;
            double SH2 = 0.0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                SH1 += (double)e.value;
                SH2 += (double)e.otherValue;
            }
            SH1 /= N;
            SH2 /= N;
            double d = 0.0;
            double SH1S = 0.0;
            double SH2S = 0.0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                double h1prime = (double)e.value - SH1;
                double h2prime = (double)e.otherValue - SH2;
                d += h1prime * h2prime;
                SH1S += h1prime * h1prime;
                SH2S += h2prime * h2prime;
            }
            return d / Math.sqrt(SH1S * SH2S);
        }
    }
    ,
    CHI_SQUARE(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double d = 0.0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                double a = e.value - e.otherValue;
                double b = e.value + e.otherValue;
                if (!(Math.abs(b) > 0.0)) continue;
                d += a * a / b;
            }
            return d / 2.0;
        }
    }
    ,
    INTERSECTION(false){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double d = 0.0;
            for (SparseLongArray.DualEntry e : h1.intersectEntries(h2)) {
                d += (double)Math.min(e.value, e.otherValue);
            }
            return d;
        }
    }
    ,
    BHATTACHARYYA(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double SH1 = 0.0;
            double SH2 = 0.0;
            double d = 0.0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                SH1 += (double)e.value;
                SH2 += (double)e.otherValue;
                d += Math.sqrt(e.value * e.otherValue);
            }
            double den = SH1 * SH2;
            if (den == 0.0) {
                return 1.0;
            }
            return Math.sqrt(1.0 - (d /= Math.sqrt(den)));
        }
    }
    ,
    HAMMING(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            int d = 0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                if (e.value == e.otherValue) continue;
                ++d;
            }
            return d;
        }
    }
    ,
    PACKED_HAMMING(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            int d = 0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                d += HammingUtils.packedHamming((long)e.value, (long)e.otherValue);
            }
            return d;
        }
    }
    ,
    CITY_BLOCK(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double d = 0.0;
            for (SparseLongArray.DualEntry e : h1.intersectEntries(h2)) {
                d += (double)Math.abs(e.value - e.otherValue);
            }
            return d;
        }
    }
    ,
    COSINE_SIM(false){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double h12 = 0.0;
            double h11 = 0.0;
            double h22 = 0.0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                h12 += (double)(e.value * e.otherValue);
                h11 += (double)(e.value * e.value);
                h22 += (double)(e.otherValue * e.otherValue);
            }
            return h12 / (Math.sqrt(h11) * Math.sqrt(h22));
        }
    }
    ,
    COSINE_DIST(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            return -1.0 * COSINE_SIM.compare(h1, h2);
        }
    }
    ,
    ARCCOS(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            return Math.acos(COSINE_SIM.compare(h1, h2));
        }
    }
    ,
    SYMMETRIC_KL_DIVERGENCE(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            if (h1.length != h2.length) {
                throw new IllegalArgumentException("Vectors have differing lengths");
            }
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                sum1 += (double)e.value;
                sum2 += (double)e.otherValue;
            }
            double d = 0.0;
            for (SparseLongArray.DualEntry e : h1.unionEntries(h2)) {
                double h1n = (double)e.value / sum1;
                double h2n = (double)e.otherValue / sum2;
                double q1 = h1n / h2n;
                double q2 = h2n / h1n;
                if (h1n != 0.0) {
                    d += h1n * Math.log(q1) / Math.log(2.0);
                }
                if (h2n == 0.0) continue;
                d += h2n * Math.log(q2) / Math.log(2.0);
            }
            return d / 2.0;
        }
    }
    ,
    JACCARD_DISTANCE(true){

        @Override
        public double compare(SparseLongArray h1, SparseLongArray h2) {
            long[] h1v = h1.values();
            long[] h2v = h2.values();
            TLongHashSet union = new TLongHashSet(h1v);
            union.addAll(h2v);
            if (h1v.length != h1.length || h2v.length != h2.length) {
                union.add(0L);
            }
            TLongHashSet intersection = new TLongHashSet(h1v);
            intersection.retainAll(h2v);
            if (h1v.length != h1.length && h2v.length != h2.length) {
                union.add(0L);
            }
            return 1.0 - (double)intersection.size() / (double)union.size();
        }
    };

    private boolean isDistance;

    private SparseLongFVComparison(boolean isDistance) {
        this.isDistance = isDistance;
    }

    public boolean isDistance() {
        return this.isDistance;
    }

    public double compare(SparseLongFV h1, SparseLongFV h2) {
        return this.compare(h1.values, h2.values);
    }

    public abstract double compare(SparseLongArray var1, SparseLongArray var2);
}

