/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVector;
import org.openimaj.util.array.SparseBinSearchIntArray;
import org.openimaj.util.array.SparseIntArray;
import org.openimaj.util.concatenate.Concatenatable;

public class SparseIntFV
implements FeatureVector,
Concatenatable<SparseIntFV, SparseIntFV> {
    private static final long serialVersionUID = 1L;
    public SparseIntArray values;

    protected SparseIntFV() {
    }

    public SparseIntFV(int nbins) {
        this.values = new SparseBinSearchIntArray(nbins);
    }

    public SparseIntFV(SparseIntArray values) {
        this.values = values;
    }

    public SparseIntFV(int[] values) {
        this.values = new SparseBinSearchIntArray(values);
    }

    public void readASCII(Scanner in) throws IOException {
        this.values = new SparseBinSearchIntArray(0);
        this.values.readASCII(in);
    }

    public String asciiHeader() {
        return "SIntFV";
    }

    public void readBinary(DataInput in) throws IOException {
        this.values = new SparseBinSearchIntArray(0);
        this.values.readBinary(in);
    }

    public byte[] binaryHeader() {
        return "SIntFV".getBytes();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.values.writeASCII(out);
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.values.writeBinary(out);
    }

    public SparseIntArray getVector() {
        return this.values;
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public DoubleFV normaliseFV(double[] min, double[] max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min[i];
            int n2 = i;
            dvals[n2] = dvals[n2] / (max[i] - min[i]);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double min, double max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min;
            int n2 = i;
            dvals[n2] = dvals[n2] / (max - min);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV() {
        int i;
        double[] dvals = this.asDoubleVector();
        double sum = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            sum += dvals[i];
        }
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / sum;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double p) {
        return this.asDoubleFV().normaliseFV(p);
    }

    @Override
    public DoubleFV asDoubleFV() {
        return new DoubleFV(this.asDoubleVector());
    }

    @Override
    public double[] asDoubleVector() {
        double[] d = new double[this.values.length];
        for (SparseIntArray.Entry e : this.values.entries()) {
            d[e.index] = e.value;
        }
        return d;
    }

    public SparseIntFV concatenate(SparseIntFV ... ins) {
        SparseIntArray[] insValues = new SparseIntArray[ins.length];
        for (int i = 0; i < ins.length; ++i) {
            insValues[i] = ins[i].values;
        }
        SparseIntArray vals = this.values.concatenate(insValues);
        return new SparseIntFV(vals);
    }

    public SparseIntFV concatenate(List<SparseIntFV> ins) {
        SparseIntArray[] insValues = new SparseIntArray[ins.size()];
        for (int i = 0; i < ins.size(); ++i) {
            insValues[i] = ins.get((int)i).values;
        }
        SparseIntArray vals = this.values.concatenate(insValues);
        return new SparseIntFV(vals);
    }
}

