/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVector;

public class EnumFV<T extends Enum<T>>
implements FeatureVector {
    private static final long serialVersionUID = 1L;
    private T enumValue;

    public EnumFV(T value) {
        this.enumValue = value;
    }

    public void readBinary(DataInput in) throws IOException {
        try {
            Class<?> clz = Class.forName(in.readUTF());
            String name = in.readUTF();
            this.enumValue = Enum.valueOf(clz, name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void readASCII(Scanner in) throws IOException {
        try {
            Class<?> clz = Class.forName(in.nextLine());
            String name = in.nextLine();
            this.enumValue = Enum.valueOf(clz, name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] binaryHeader() {
        return "EnFV".getBytes();
    }

    public String asciiHeader() {
        return this.getClass().getName() + " ";
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeUTF(((Enum)this.enumValue).getDeclaringClass().getName());
        out.writeUTF(((Enum)this.enumValue).toString());
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.println(((Enum)this.enumValue).getDeclaringClass().getName());
        out.println(((Enum)this.enumValue).toString());
    }

    @Override
    public Enum<T> getVector() {
        return this.enumValue;
    }

    @Override
    public int length() {
        return ((Enum[])((Enum)this.enumValue).getDeclaringClass().getEnumConstants()).length;
    }

    @Override
    public DoubleFV normaliseFV(double[] min, double[] max) {
        return this.asDoubleFV().normaliseFV(min, max);
    }

    @Override
    public DoubleFV normaliseFV(double min, double max) {
        return this.asDoubleFV().normaliseFV(min, max);
    }

    @Override
    public DoubleFV normaliseFV() {
        return this.asDoubleFV().normaliseFV();
    }

    @Override
    public DoubleFV normaliseFV(double p) {
        return this.asDoubleFV().normaliseFV(p);
    }

    @Override
    public DoubleFV asDoubleFV() {
        return new DoubleFV(this.asDoubleVector());
    }

    @Override
    public double[] asDoubleVector() {
        double[] vec = new double[this.length()];
        vec[((Enum)this.enumValue).ordinal()] = 1.0;
        return vec;
    }
}

