/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.validation;

import java.util.concurrent.ThreadPoolExecutor;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.ResultAggregator;
import org.openimaj.experiment.validation.ValidationData;
import org.openimaj.experiment.validation.ValidationOperation;
import org.openimaj.experiment.validation.cross.CrossValidator;
import org.openimaj.util.function.Operation;
import org.openimaj.util.parallel.GlobalExecutorPool;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class ValidationRunner {
    private ValidationRunner() {
    }

    public static <DATASET extends Dataset<?>, ANALYSIS_RESULT, AGGREGATE_ANALYSIS_RESULT extends AnalysisResult> AGGREGATE_ANALYSIS_RESULT run(ResultAggregator<ANALYSIS_RESULT, AGGREGATE_ANALYSIS_RESULT> aggregator, DATASET dataset, CrossValidator<DATASET> cv, ValidationOperation<DATASET, ANALYSIS_RESULT> round) {
        return ValidationRunner.run(aggregator, dataset, cv, round, GlobalExecutorPool.getPool());
    }

    public static <DATASET extends Dataset<?>, ANALYSIS_RESULT, AGGREGATE_ANALYSIS_RESULT extends AnalysisResult> AGGREGATE_ANALYSIS_RESULT run(final ResultAggregator<ANALYSIS_RESULT, AGGREGATE_ANALYSIS_RESULT> aggregator, DATASET dataset, CrossValidator<DATASET> cv, final ValidationOperation<DATASET, ANALYSIS_RESULT> round, ThreadPoolExecutor pool) {
        Parallel.forEach((Partitioner)new FixedSizeChunkPartitioner(cv.createIterable(dataset), 1), (Operation)new Operation<ValidationData<DATASET>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(ValidationData<DATASET> cv) {
                Object result = round.evaluate(cv.getTrainingDataset(), cv.getValidationDataset());
                ResultAggregator resultAggregator = aggregator;
                synchronized (resultAggregator) {
                    aggregator.add(result);
                }
            }
        }, (ThreadPoolExecutor)pool);
        return aggregator.getAggregatedResult();
    }
}

