/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.retrieval.analysers;

import com.googlecode.jatl.Html;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.lemurproject.ireval.IREval;
import org.lemurproject.ireval.RetrievalEvaluator;
import org.lemurproject.ireval.SetRetrievalEvaluator;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.util.pair.IndependentPair;

public class IREvalResult
implements AnalysisResult {
    protected SetRetrievalEvaluator eval;

    public IREvalResult(SetRetrievalEvaluator sre) {
        this.eval = sre;
    }

    public String toString() {
        return this.getSummaryReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHTML(File file, final String title, final String info) throws IOException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            new Html(fw){
                {
                    super(x0);
                    this.html();
                    this.head();
                    this.title(title);
                    this.end();
                    this.body();
                    ((Html)((Html)this.h1()).text(title)).end();
                    ((Html)((Html)this.div()).text(info)).end();
                    this.hr();
                    this.writeEvaluation();
                    this.hr();
                    ((Html)((Html)this.h2()).text("Individual Query Results:")).end();
                    this.writeIndividualQueries();
                    this.endAll();
                    this.done();
                }

                void writeIndividualQueries() {
                    for (RetrievalEvaluator evaluator : IREvalResult.this.eval.getEvaluators()) {
                        String query = evaluator.queryName();
                        this.writeIndividual(query, evaluator);
                    }
                }

                void writeIndividual(String name, RetrievalEvaluator re) {
                    this.table();
                    this.tr();
                    ((Html)this.td()).colspan("2");
                    ((Html)((Html)this.h3()).text(name)).end();
                    this.end();
                    this.end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("num_ret")).end()).td()).text(re.retrievedDocuments().size() + "")).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("num_rel")).end()).td()).text(re.relevantDocuments().size() + "")).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("num_rel_ret")).end()).td()).text(re.relevantRetrievedDocuments().size() + "")).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("map")).end()).td()).text(String.format("%3.4f", re.averagePrecision()))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("ndcg")).end()).td()).text(String.format("%3.4f", re.normalizedDiscountedCumulativeGain()))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("ndcg15")).end()).td()).text(String.format("%3.4f", re.normalizedDiscountedCumulativeGain(15)))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("R-prec")).end()).td()).text(String.format("%3.4f", re.rPrecision()))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("bpref")).end()).td()).text(String.format("%3.4f", re.binaryPreference()))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("recip_rank")).end()).td()).text(String.format("%3.4f", re.reciprocalRank()))).end()).end();
                    int[] fixedPoints = RetrievalEvaluator.getFixedPoints();
                    double[] vals = re.precisionAtFixedPoints();
                    for (int i = 0; i < fixedPoints.length; ++i) {
                        int point = fixedPoints[i];
                        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("P" + point)).end()).td()).text(String.format("%3.4f", vals[i]))).end()).end();
                    }
                    double[] precs = re.interpolatedPrecision();
                    double prec = 0.0;
                    for (int i = 0; i < precs.length; ++i) {
                        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text(String.format("ircl_prn.%3.2f", prec))).end()).td()).text(String.format("%3.4f", precs[i]))).end()).end();
                        prec += 0.1;
                    }
                    this.end();
                }

                void writeEvaluation() {
                    this.table();
                    this.tr();
                    ((Html)this.td()).colspan("2");
                    ((Html)((Html)this.h2()).text("Summary Results:")).end();
                    this.end();
                    this.end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("num_q")).end()).td()).text(IREvalResult.this.eval.getEvaluators().size() + "")).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("num_ret")).end()).td()).text(IREvalResult.this.eval.numberRetrieved() + "")).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("num_rel")).end()).td()).text(IREvalResult.this.eval.numberRetrieved() + "")).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("num_rel_ret")).end()).td()).text(IREvalResult.this.eval.numberRelevantRetrieved() + "")).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("map")).end()).td()).text(String.format("%3.4f", IREvalResult.this.eval.meanAveragePrecision()))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("gm_ap")).end()).td()).text(String.format("%3.4f", IREvalResult.this.eval.geometricMeanAveragePrecision()))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("ndcg")).end()).td()).text(String.format("%3.4f", IREvalResult.this.eval.meanNormalizedDiscountedCumulativeGain()))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("R-prec")).end()).td()).text(String.format("%3.4f", IREvalResult.this.eval.meanRPrecision()))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("bpref")).end()).td()).text(String.format("%3.4f", IREvalResult.this.eval.meanBinaryPreference()))).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("recip_rank")).end()).td()).text(String.format("%3.4f", IREvalResult.this.eval.meanReciprocalRank()))).end()).end();
                    int[] fixedPoints = SetRetrievalEvaluator.getFixedPoints();
                    double[] precs = IREvalResult.this.eval.precisionAtFixedPoints();
                    for (int i = 0; i < fixedPoints.length; ++i) {
                        int point = fixedPoints[i];
                        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text("P" + point)).end()).td()).text(String.format("%3.4f", precs[i]))).end()).end();
                    }
                    double prec = 0.0;
                    precs = IREvalResult.this.eval.interpolatedPrecision();
                    for (int i = 0; i < precs.length; ++i) {
                        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.tr()).td()).text(String.format("ircl_prn.%3.2f", prec))).end()).td()).text(String.format("%3.4f", precs[i]))).end()).end();
                        prec += 0.1;
                    }
                    this.end();
                }
            };
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public List<IndependentPair<String, Number>> getSummaryData() {
        ArrayList<IndependentPair<String, Number>> data = new ArrayList<IndependentPair<String, Number>>();
        data.add(new IndependentPair((Object)"num_q", (Object)this.eval.getEvaluators().size()));
        data.add(new IndependentPair((Object)"num_ret", (Object)this.eval.numberRetrieved()));
        data.add(new IndependentPair((Object)"num_rel", (Object)this.eval.numberRetrieved()));
        data.add(new IndependentPair((Object)"num_rel_ret", (Object)this.eval.numberRelevantRetrieved()));
        data.add(new IndependentPair((Object)"map", (Object)this.eval.meanAveragePrecision()));
        data.add(new IndependentPair((Object)"gm_ap", (Object)this.eval.geometricMeanAveragePrecision()));
        data.add(new IndependentPair((Object)"ndcg", (Object)this.eval.meanNormalizedDiscountedCumulativeGain()));
        data.add(new IndependentPair((Object)"R-prec", (Object)this.eval.meanRPrecision()));
        data.add(new IndependentPair((Object)"bpref", (Object)this.eval.meanBinaryPreference()));
        data.add(new IndependentPair((Object)"recip_rank", (Object)this.eval.meanReciprocalRank()));
        return data;
    }

    public List<IndependentPair<Double, Double>> getInterpolatedPRData() {
        ArrayList<IndependentPair<Double, Double>> data = new ArrayList<IndependentPair<Double, Double>>();
        double prec = 0.0;
        double[] precs = this.eval.interpolatedPrecision();
        for (int i = 0; i < precs.length; ++i) {
            data.add((IndependentPair<Double, Double>)new IndependentPair((Object)prec, (Object)precs[i]));
            prec += 0.1;
        }
        return data;
    }

    @Override
    public JasperPrint getSummaryReport(String title, String info) throws JRException {
        InputStream inputStream = IREvalResult.class.getResourceAsStream("IREvalSummaryReport.jrxml");
        ArrayList<IREvalResult> list = new ArrayList<IREvalResult>();
        list.add(this);
        JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource(list);
        HashMap parameters = new HashMap();
        JasperDesign jasperDesign = JRXmlLoader.load((InputStream)inputStream);
        JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)beanColDataSource);
        return jasperPrint;
    }

    @Override
    public JasperPrint getDetailReport(String title, String info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSummaryReport() {
        return IREval.singleEvaluation((SetRetrievalEvaluator)this.eval, (boolean)false);
    }

    @Override
    public String getDetailReport() {
        return IREval.singleEvaluation((SetRetrievalEvaluator)this.eval, (boolean)true);
    }
}

