/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.retrieval;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.Evaluator;
import org.openimaj.experiment.evaluation.retrieval.RetrievalAnalyser;
import org.openimaj.experiment.evaluation.retrieval.RetrievalEngine;

public class RetrievalEvaluator<RESULT extends AnalysisResult, DOCUMENT extends Identifiable, QUERY>
implements Evaluator<Map<QUERY, List<DOCUMENT>>, RESULT> {
    protected RetrievalEngine<DOCUMENT, QUERY> engine;
    protected Collection<QUERY> queries;
    protected Map<QUERY, Set<DOCUMENT>> relevant;
    protected RetrievalAnalyser<RESULT, QUERY, DOCUMENT> analyser;

    public RetrievalEvaluator(RetrievalEngine<DOCUMENT, QUERY> engine, Collection<QUERY> queries, Map<QUERY, Set<DOCUMENT>> relevant, RetrievalAnalyser<RESULT, QUERY, DOCUMENT> analyser) {
        this.engine = engine;
        this.queries = queries;
        this.relevant = relevant;
        this.analyser = analyser;
    }

    public RetrievalEvaluator(RetrievalEngine<DOCUMENT, QUERY> engine, Map<QUERY, Set<DOCUMENT>> relevant, RetrievalAnalyser<RESULT, QUERY, DOCUMENT> analyser) {
        this.engine = engine;
        this.queries = relevant.keySet();
        this.relevant = relevant;
        this.analyser = analyser;
    }

    public RetrievalEvaluator(final Map<QUERY, List<DOCUMENT>> results, Map<QUERY, Set<DOCUMENT>> relevant, RetrievalAnalyser<RESULT, QUERY, DOCUMENT> analyser) {
        this.engine = new RetrievalEngine<DOCUMENT, QUERY>(){

            @Override
            public List<DOCUMENT> search(QUERY query) {
                return (List)results.get(query);
            }
        };
        this.queries = relevant.keySet();
        this.relevant = relevant;
        this.analyser = analyser;
    }

    @Override
    public Map<QUERY, List<DOCUMENT>> evaluate() {
        HashMap<QUERY, List<DOCUMENT>> results = new HashMap<QUERY, List<DOCUMENT>>();
        for (QUERY query : this.queries) {
            results.put(query, this.engine.search(query));
        }
        return results;
    }

    @Override
    public RESULT analyse(Map<QUERY, List<DOCUMENT>> results) {
        return this.analyser.analyse(results, this.relevant);
    }
}

