/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.classification.analysers.roc;

import gov.sandia.cognition.statistics.method.ReceiverOperatingCharacteristic;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import org.openimaj.experiment.evaluation.AnalysisResult;

public class ROCResult<CLASS>
implements AnalysisResult {
    Map<CLASS, ReceiverOperatingCharacteristic> rocData;

    ROCResult(Map<CLASS, ReceiverOperatingCharacteristic> rocData) {
        this.rocData = rocData;
    }

    public Map<CLASS, ReceiverOperatingCharacteristic> getROCData() {
        return this.rocData;
    }

    public String toString() {
        return this.getSummaryReport();
    }

    @Override
    public JasperPrint getSummaryReport(String title, String info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JasperPrint getDetailReport(String title, String info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSummaryReport() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<CLASS, ReceiverOperatingCharacteristic> entry : this.rocData.entrySet()) {
            ReceiverOperatingCharacteristic.Statistic stats = entry.getValue().computeStatistics();
            sb.append(String.format("%10s\tAUC: %2.3f\tEER:%2.3f\n", entry.getKey(), stats.getAreaUnderCurve(), stats.getOptimalThreshold().getFalsePositiveRate()));
        }
        return sb.toString();
    }

    @Override
    public String getDetailReport() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<CLASS, ReceiverOperatingCharacteristic> entry : this.rocData.entrySet()) {
            ReceiverOperatingCharacteristic.Statistic stats = entry.getValue().computeStatistics();
            sb.append("Class: " + entry.getKey() + "\n");
            sb.append(String.format("AUC: %2.3f\n", stats.getAreaUnderCurve()));
            sb.append(String.format("EER: %2.3f\n", stats.getOptimalThreshold().getFalsePositiveRate()));
            sb.append("\n");
            sb.append("FPR\tTPR\n");
            for (ReceiverOperatingCharacteristic.DataPoint dp : entry.getValue().getSortedROCData()) {
                sb.append(String.format("%2.3f\t%2.3f\n", dp.getFalsePositiveRate(), dp.getTruePositiveRate()));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

