/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.classification;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.Evaluator;
import org.openimaj.experiment.evaluation.classification.ClassificationAnalyser;
import org.openimaj.experiment.evaluation.classification.ClassificationResult;
import org.openimaj.experiment.evaluation.classification.Classifier;

public class ClassificationEvaluator<RESULT extends AnalysisResult, CLASS, OBJECT>
implements Evaluator<Map<OBJECT, ClassificationResult<CLASS>>, RESULT> {
    protected Classifier<CLASS, OBJECT> classifier;
    protected ClassificationAnalyser<RESULT, CLASS, OBJECT> analyser;
    protected Map<OBJECT, Set<CLASS>> actual;
    protected Collection<OBJECT> objects;

    public ClassificationEvaluator(Classifier<CLASS, OBJECT> classifier, Collection<OBJECT> objects, Map<OBJECT, Set<CLASS>> actual, ClassificationAnalyser<RESULT, CLASS, OBJECT> analyser) {
        this.classifier = classifier;
        this.objects = objects;
        this.actual = actual;
        this.analyser = analyser;
    }

    public ClassificationEvaluator(Classifier<CLASS, OBJECT> classifier, Map<OBJECT, Set<CLASS>> actual, ClassificationAnalyser<RESULT, CLASS, OBJECT> analyser) {
        this.classifier = classifier;
        this.objects = actual.keySet();
        this.actual = actual;
        this.analyser = analyser;
    }

    public ClassificationEvaluator(Classifier<CLASS, OBJECT> classifier, GroupedDataset<CLASS, ? extends ListDataset<OBJECT>, OBJECT> actual, ClassificationAnalyser<RESULT, CLASS, OBJECT> analyser) {
        this.classifier = classifier;
        this.objects = DatasetAdaptors.asList(actual);
        this.actual = new HashMap<OBJECT, Set<CLASS>>();
        for (Object clazz : actual.getGroups()) {
            HashSet cset = new HashSet();
            cset.add(clazz);
            for (Object instance : (ListDataset)actual.getInstances(clazz)) {
                this.actual.put(instance, cset);
            }
        }
        this.analyser = analyser;
    }

    public ClassificationEvaluator(final Map<OBJECT, ClassificationResult<CLASS>> results, Map<OBJECT, Set<CLASS>> actual, ClassificationAnalyser<RESULT, CLASS, OBJECT> analyser) {
        this.classifier = new Classifier<CLASS, OBJECT>(){

            @Override
            public ClassificationResult<CLASS> classify(OBJECT object) {
                return (ClassificationResult)results.get(object);
            }
        };
        this.objects = actual.keySet();
        this.actual = actual;
        this.analyser = analyser;
    }

    @Override
    public Map<OBJECT, ClassificationResult<CLASS>> evaluate() {
        HashMap<OBJECT, ClassificationResult<CLASS>> results = new HashMap<OBJECT, ClassificationResult<CLASS>>();
        for (OBJECT object : this.objects) {
            results.put(object, this.classifier.classify(object));
        }
        return results;
    }

    @Override
    public RESULT analyse(Map<OBJECT, ClassificationResult<CLASS>> predicted) {
        return this.analyser.analyse(predicted, this.actual);
    }

    public Map<OBJECT, Set<CLASS>> getExpected() {
        return this.actual;
    }
}

