/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.dataset.sampling;

import java.util.List;
import org.openimaj.data.RandomData;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.experiment.dataset.sampling.Sampler;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.util.list.AcceptingListView;
import org.openimaj.util.list.SkippingListView;

public class UniformRandomisedSampler<INSTANCE>
implements Sampler<ListDataset<INSTANCE>> {
    private boolean withReplacement = false;
    private double percentage;

    public UniformRandomisedSampler(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("percentage of sample instances must be between 0 and 1");
        }
        this.percentage = percentage;
    }

    public UniformRandomisedSampler(double percentage, boolean withReplacement) {
        this(percentage);
        this.withReplacement = withReplacement;
    }

    public UniformRandomisedSampler(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("number of sample instances must be bigger than 0");
        }
        this.percentage = -number;
    }

    public UniformRandomisedSampler(int number, boolean withReplacement) {
        this(number);
        this.withReplacement = withReplacement;
    }

    @Override
    public ListDataset<INSTANCE> sample(ListDataset<INSTANCE> dataset) {
        int N;
        boolean skip;
        if (this.percentage >= 0.0) {
            skip = this.percentage > 0.5;
            double per = skip ? 1.0 - this.percentage : this.percentage;
            N = (int)Math.round((double)dataset.size() * per);
        } else {
            N = (int)(-this.percentage);
            skip = N > dataset.size() / 2;
        }
        int[] selectedIds = this.withReplacement ? RandomData.getRandomIntArray((int)N, (int)0, (int)dataset.size()) : RandomData.getUniqueRandomInts((int)N, (int)0, (int)dataset.size());
        List<INSTANCE> listView = DatasetAdaptors.asList(dataset);
        if (!skip) {
            return new ListBackedDataset((List)new AcceptingListView(listView, selectedIds));
        }
        return new ListBackedDataset((List)new SkippingListView(listView, selectedIds));
    }
}

