/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.dataset.sampling;

import java.util.Collection;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.dataset.sampling.Sampler;

public class NamedGroupSampler<KEY, INSTANCE>
implements Sampler<GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE>> {
    Collection<KEY> keys;

    public NamedGroupSampler(Collection<KEY> keys) {
        this.keys = keys;
    }

    @Override
    public GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset) {
        MapBackedDataset sample = new MapBackedDataset();
        for (KEY key : this.keys) {
            sample.add(key, (Dataset)dataset.get(key));
        }
        return sample;
    }

    public static <KEY, INSTANCE> GroupedDataset<KEY, ListDataset<INSTANCE>, INSTANCE> sample(GroupedDataset<KEY, ? extends ListDataset<INSTANCE>, INSTANCE> dataset, Collection<KEY> keys) {
        return new NamedGroupSampler<KEY, INSTANCE>(keys).sample(dataset);
    }
}

