/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.citation.annotation.output;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import org.jbibtex.LaTeXObject;
import org.jbibtex.LaTeXParser;
import org.jbibtex.LaTeXPrinter;
import org.jbibtex.ParseException;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.output.ReferenceFormatter;

public enum StandardFormatters implements ReferenceFormatter
{
    BIBTEX{

        @Override
        protected String formatRefs(Iterable<Reference> refs) {
            StringBuilder builder = new StringBuilder();
            for (Reference r : refs) {
                builder.append(this.format(r));
            }
            return builder.toString();
        }

        void appendNames(StringBuilder builder, String key, String[] authors) {
            if (authors == null || authors.length == 0 || authors.length == 1 && authors[0].length() == 0) {
                return;
            }
            builder.append(" " + key + " = {");
            for (int i = 0; i < authors.length - 1; ++i) {
                builder.append("{" + authors[i] + "} and ");
            }
            builder.append("{" + authors[authors.length - 1] + "}");
            builder.append("}\n");
        }

        @Override
        public String format(Reference ref) {
            int i;
            StringBuilder builder = new StringBuilder();
            String key = ref.hashCode() + "";
            builder.append("@" + (Object)((Object)ref.type()) + "{" + key + "\n");
            this.appendNames(builder, "author", ref.author());
            builder.append(" title = {" + ref.title() + "}\n");
            builder.append(" year = {" + ref.year() + "}\n");
            if (ref.journal().length() > 0) {
                builder.append(" journal = {" + ref.journal() + "}\n");
            }
            if (ref.booktitle().length() > 0) {
                builder.append(" booktitle = {" + ref.booktitle() + "}\n");
            }
            if (ref.pages().length > 0) {
                if (ref.pages().length == 1) {
                    builder.append(" pages = {" + ref.pages()[0] + "}\n");
                } else if (ref.pages().length == 2) {
                    builder.append(" pages = {" + ref.pages()[0] + "--" + ref.pages()[1] + "}\n");
                } else {
                    builder.append(" pages = {");
                    for (i = 0; i < ref.pages().length - 1; ++i) {
                        builder.append(ref.pages()[i] + ", ");
                    }
                    builder.append(ref.pages()[ref.pages().length - 1] + "}\n");
                }
            }
            if (ref.chapter().length() > 0) {
                builder.append(" chapter = {" + ref.chapter() + "}\n");
            }
            if (ref.edition().length() > 0) {
                builder.append(" edition = {" + ref.edition() + "}\n");
            }
            if (ref.url().length() > 0) {
                builder.append(" url = {" + ref.url() + "}\n");
            }
            if (ref.note().length() > 0) {
                builder.append(" note = {" + ref.note() + "}\n");
            }
            this.appendNames(builder, "editor", ref.editor());
            if (ref.institution().length() > 0) {
                builder.append(" institution = {" + ref.institution() + "}\n");
            }
            if (ref.month().length() > 0) {
                builder.append(" month = {" + ref.month() + "}\n");
            }
            if (ref.number() != "") {
                builder.append(" number = {" + ref.number() + "}\n");
            }
            if (ref.organization().length() > 0) {
                builder.append(" organization = {" + ref.organization() + "}\n");
            }
            if (ref.publisher().length() > 0) {
                builder.append(" publisher = {" + ref.publisher() + "}\n");
            }
            if (ref.school().length() > 0) {
                builder.append(" school = {" + ref.school() + "}\n");
            }
            if (ref.series().length() > 0) {
                builder.append(" series = {" + ref.series() + "}\n");
            }
            if (ref.volume() != "") {
                builder.append(" volume = {" + ref.volume() + "}\n");
            }
            if (ref.customData().length > 1) {
                for (i = 0; i < ref.customData().length; i += 2) {
                    builder.append(" " + ref.customData()[i] + " = {" + ref.customData()[i + 1] + "}\n");
                }
            }
            builder.append("}\n");
            return builder.toString();
        }
    }
    ,
    REFERENCE_ANNOTATION{

        @Override
        protected String formatRefs(Iterable<Reference> refs) {
            StringBuilder builder = new StringBuilder();
            for (Reference r : refs) {
                builder.append(this.format(r));
            }
            return builder.toString();
        }

        private String formatArray(String[] arr) {
            StringBuilder builder = new StringBuilder();
            builder.append("{ ");
            for (int i = 0; i < arr.length - 1; ++i) {
                builder.append(this.formatString(arr[i]) + ", ");
            }
            builder.append(this.formatString(arr[arr.length - 1]) + " }");
            return builder.toString();
        }

        private String formatString(String str) {
            return "\"" + str + "\"";
        }

        @Override
        public String format(Reference ref) {
            StringBuilder builder = new StringBuilder();
            builder.append("@Reference(\n");
            builder.append("\ttype = ReferenceType." + (Object)((Object)ref.type()) + ",\n");
            builder.append("\tauthor = " + this.formatArray(ref.author()) + ",\n");
            builder.append("\ttitle = " + this.formatString(ref.title()) + ",\n");
            builder.append("\tyear = " + this.formatString(ref.year()) + ",\n");
            if (ref.journal().length() > 0) {
                builder.append("\tjournal = " + this.formatString(ref.journal()) + ",\n");
            }
            if (ref.booktitle().length() > 0) {
                builder.append("\tbooktitle = " + this.formatString(ref.booktitle()) + ",\n");
            }
            if (ref.pages().length > 0) {
                builder.append("\tpages = " + this.formatArray(ref.pages()) + ",\n");
            }
            if (ref.chapter().length() > 0) {
                builder.append("\tchapter = " + this.formatString(ref.chapter()) + ",\n");
            }
            if (ref.edition().length() > 0) {
                builder.append("\tedition = " + this.formatString(ref.edition()) + ",\n");
            }
            if (ref.url().length() > 0) {
                builder.append("\turl = " + this.formatString(ref.url()) + ",\n");
            }
            if (ref.note().length() > 0) {
                builder.append("\tnote = " + this.formatString(ref.note()) + ",\n");
            }
            if (ref.editor().length > 0) {
                builder.append("\teditor = " + this.formatArray(ref.editor()) + ",\n");
            }
            if (ref.institution().length() > 0) {
                builder.append("\tinstitution = " + this.formatString(ref.institution()) + ",\n");
            }
            if (ref.month().length() > 0) {
                builder.append("\tmonth = " + this.formatString(ref.month()) + ",\n");
            }
            if (ref.number() != "") {
                builder.append("\tnumber = " + this.formatString(ref.number()) + ",\n");
            }
            if (ref.organization().length() > 0) {
                builder.append("\torganization = " + this.formatString(ref.organization()) + ",\n");
            }
            if (ref.publisher().length() > 0) {
                builder.append("\tpublisher = " + this.formatString(ref.publisher()) + ",\n");
            }
            if (ref.school().length() > 0) {
                builder.append("\tschool = " + this.formatString(ref.school()) + ",\n");
            }
            if (ref.series().length() > 0) {
                builder.append("\tseries = " + this.formatString(ref.series()) + ",\n");
            }
            if (ref.volume() != "") {
                builder.append("\tvolume = " + this.formatString(ref.volume()) + ",\n");
            }
            if (ref.customData().length > 1) {
                builder.append("\tcustomData = {\n");
                for (int i = 0; i < ref.customData().length; i += 2) {
                    builder.append("\t\t" + this.formatString(ref.customData()[i]) + ", " + this.formatString(ref.customData()[i + 1]));
                    if (i < ref.customData().length - 2) {
                        builder.append(",");
                    }
                    builder.append("\n");
                }
                builder.append("\t}\n");
            }
            if (builder.charAt(builder.length() - 2) == ',') {
                builder.deleteCharAt(builder.length() - 2);
            }
            builder.append(")\n");
            return builder.toString();
        }
    }
    ,
    STRING{

        @Override
        protected String formatRefs(Iterable<Reference> refs) {
            StringBuilder builder = new StringBuilder();
            for (Reference r : refs) {
                builder.append(this.format(r) + "\n");
            }
            return builder.toString();
        }

        void appendNames(StringBuilder builder, String[] authors) {
            if (authors == null || authors.length == 0 || authors.length == 1 && authors[0].length() == 0) {
                return;
            }
            if (authors.length == 1) {
                builder.append(this.formatName(authors[0]) + ".");
                return;
            }
            for (int i = 0; i < authors.length - 2; ++i) {
                builder.append(this.formatName(authors[i]) + ", ");
            }
            builder.append(this.formatName(authors[authors.length - 2]) + " and " + this.formatName(authors[authors.length - 1]) + ". ");
        }

        String formatName(String name) {
            if ((name = 3.format(name)).contains(",")) {
                String lastName = name.substring(0, name.indexOf(","));
                String[] firstNames = name.substring(name.indexOf(",") + 1).split(" ");
                String formatted = "";
                for (String f : firstNames) {
                    if ((f = f.trim()).length() <= 0) continue;
                    formatted = formatted + f.charAt(0) + ". ";
                }
                return formatted + lastName;
            }
            String[] parts = name.split(" ");
            String formatted = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                formatted = formatted + parts[i].charAt(0) + ". ";
            }
            return formatted + parts[parts.length - 1];
        }

        @Override
        public String format(Reference ref) {
            StringBuilder builder = new StringBuilder();
            this.appendNames(builder, ref.author());
            builder.append(3.format(ref.title()) + ". ");
            if (ref.journal().length() > 0) {
                builder.append(3.format(ref.journal()) + ". ");
            }
            if (ref.booktitle().length() > 0) {
                builder.append(3.format(ref.booktitle()) + ". ");
            }
            if (ref.institution().length() > 0) {
                builder.append(3.format(ref.institution()) + ". ");
            }
            if (ref.school().length() > 0) {
                builder.append(3.format(ref.school()) + ". ");
            }
            if (ref.publisher().length() > 0) {
                builder.append(3.format(ref.publisher()) + ". ");
            }
            if (ref.organization().length() > 0) {
                builder.append(3.format(ref.organization()) + ". ");
            }
            if (ref.pages().length > 0) {
                if (ref.pages().length == 1) {
                    builder.append("p" + ref.pages()[0] + ". ");
                } else if (ref.pages().length == 2) {
                    builder.append("pp" + ref.pages()[0] + "-" + ref.pages()[1] + ". ");
                } else {
                    builder.append("pp");
                    for (int i = 0; i < ref.pages().length - 1; ++i) {
                        builder.append(ref.pages()[i] + ", ");
                    }
                    builder.append(ref.pages()[ref.pages().length - 1] + ". ");
                }
            }
            if (ref.month().length() > 0) {
                builder.append(3.format(ref.month()) + ", ");
            }
            builder.append(3.format(ref.year()) + ". ");
            if (ref.url().length() > 0) {
                builder.append(3.format(ref.url()));
            }
            return builder.toString();
        }
    }
    ,
    HTML{

        @Override
        protected String formatRefs(Iterable<Reference> refs) {
            StringBuilder builder = new StringBuilder();
            for (Reference r : refs) {
                builder.append("<p class=\"ref\">");
                builder.append(this.format(r));
                builder.append("</p>\n");
            }
            return builder.toString();
        }

        void appendNames(StringBuilder builder, String[] authors) {
            if (authors == null || authors.length == 0 || authors.length == 1 && authors[0].length() == 0) {
                return;
            }
            if (authors.length == 1) {
                builder.append(this.formatName(authors[0]) + ". ");
                return;
            }
            for (int i = 0; i < authors.length - 2; ++i) {
                builder.append(this.formatName(authors[i]) + ", ");
            }
            builder.append(this.formatName(authors[authors.length - 2]) + " and " + this.formatName(authors[authors.length - 1]) + ". ");
        }

        String formatName(String name) {
            if ((name = 4.format(name)).contains(",")) {
                String lastName = name.substring(0, name.indexOf(","));
                String[] firstNames = name.substring(name.indexOf(",") + 1).split(" ");
                String formatted = "";
                for (String f : firstNames) {
                    if ((f = f.trim()).length() <= 0) continue;
                    formatted = formatted + f.charAt(0) + ". ";
                }
                return formatted + lastName;
            }
            String[] parts = name.split(" ");
            String formatted = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                formatted = formatted + parts[i].charAt(0) + ". ";
            }
            return formatted + parts[parts.length - 1];
        }

        @Override
        public String format(Reference ref) {
            StringBuilder builder = new StringBuilder();
            builder.append("<span class='authors'>");
            this.appendNames(builder, ref.author());
            builder.append("</span>");
            builder.append("<span class='title'>");
            builder.append(4.format(ref.title()) + ". ");
            builder.append("</span>");
            if (ref.journal().length() > 0) {
                builder.append("<span class='journal'>" + 4.format(ref.journal()) + ". </span>");
            }
            if (ref.booktitle().length() > 0) {
                builder.append("<span class='booktitle'>" + 4.format(ref.booktitle()) + ". </span>");
            }
            if (ref.institution().length() > 0) {
                builder.append("<span class='institution'>" + 4.format(ref.institution()) + ". </span>");
            }
            if (ref.school().length() > 0) {
                builder.append("<span class='school'>" + 4.format(ref.school()) + ". </span>");
            }
            if (ref.publisher().length() > 0) {
                builder.append("<span class='publisher'>" + 4.format(ref.publisher()) + ". </span>");
            }
            if (ref.organization().length() > 0) {
                builder.append("<span class='organization'>" + 4.format(ref.organization()) + ". </span>");
            }
            if (ref.pages().length > 0) {
                if (ref.pages().length == 1) {
                    builder.append("<span class='pages'>p" + ref.pages()[0] + ". </span>");
                } else if (ref.pages().length == 2) {
                    builder.append("<span class='pages'>pp" + ref.pages()[0] + "-" + ref.pages()[1] + ". </span>");
                } else {
                    builder.append("<span class='pages'>pp");
                    for (int i = 0; i < ref.pages().length - 1; ++i) {
                        builder.append(ref.pages()[i] + ", ");
                    }
                    builder.append(ref.pages()[ref.pages().length - 1] + ". </span>");
                }
            }
            if (ref.month().length() > 0) {
                builder.append("<span class='month'>" + 4.format(ref.month()) + ", </span>");
            }
            builder.append("<span class='year'>" + 4.format(ref.year()) + ". </span>");
            if (ref.url().length() > 0) {
                builder.append("<a class='url' href='" + 4.format(ref.url()) + "'>" + 4.format(ref.url()) + "</a>");
            }
            return builder.toString();
        }
    };


    protected abstract String formatRefs(Iterable<Reference> var1);

    @Override
    public abstract String format(Reference var1);

    @Override
    public String format(Collection<Reference> refs) {
        return this.formatRefs(refs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<LaTeXObject> parseLaTeX(String string) throws IOException, ParseException {
        try (StringReader reader = new StringReader(string);){
            LaTeXParser parser = new LaTeXParser();
            List list = parser.parse((Reader)reader);
            return list;
        }
    }

    static String printLaTeX(List<LaTeXObject> objects) {
        LaTeXPrinter printer = new LaTeXPrinter();
        return printer.print(objects);
    }

    static String format(String latex) {
        try {
            return StandardFormatters.printLaTeX(StandardFormatters.parseLaTeX(latex));
        }
        catch (Exception e) {
            return latex;
        }
    }
}

