/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.samples;

import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.timecode.AudioTimecode;

public class SampleBuffer8Bit
implements SampleBuffer,
Iterator<Float> {
    private static final int SAMPLE_SCALAR = 16909320;
    private byte[] byteBuffer = null;
    private AudioFormat format = null;
    private int iteratorCount;
    private AudioTimecode timecode;

    public SampleBuffer8Bit(SampleChunk samples, AudioFormat af) {
        this.format = af;
        if (this.format == null || this.format.getNBits() != 8) {
            throw new IllegalArgumentException("Number of bits must be 8 if you're instantiating an 8 bit sample buffer. However " + (this.format == null ? "format object was null." : "number of bits in format was " + this.format.getNBits()));
        }
        this.byteBuffer = samples.getSamples();
        this.timecode = samples.getStartTimecode();
    }

    public SampleBuffer8Bit(AudioFormat af, int nSamples) {
        this.format = af.clone();
        if (this.format == null || this.format.getNBits() != 8) {
            throw new IllegalArgumentException("Number of bits must be 8 if you're instantiating an 8 bit sample buffer. However " + (this.format == null ? "format object was null." : "number of bits in format was " + this.format.getNBits()));
        }
        this.byteBuffer = new byte[nSamples];
    }

    @Override
    public SampleChunk getSampleChunk() {
        SampleChunk sc = new SampleChunk(this.byteBuffer, this.format);
        sc.setStartTimecode(this.timecode);
        return sc;
    }

    @Override
    public SampleChunk getSampleChunk(int channel) {
        if (channel > this.format.getNumChannels()) {
            throw new IllegalArgumentException("Cannot generate sample chunk for channel " + channel + " as sample only has " + this.format.getNumChannels() + " channels.");
        }
        if (channel == 0 && this.format.getNumChannels() == 1) {
            return this.getSampleChunk();
        }
        byte[] newSamples = new byte[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            newSamples[i] = this.byteBuffer[i * this.format.getNumChannels() + channel];
        }
        AudioFormat af = this.format.clone();
        af.setNumChannels(1);
        return new SampleChunk(newSamples, af);
    }

    @Override
    public float get(int index) {
        return this.byteBuffer[index] * 16909320;
    }

    @Override
    public float getUnscaled(int index) {
        return this.byteBuffer[index];
    }

    @Override
    public void set(int index, float sample) {
        if (sample > 127.0f) {
            sample = 127.0f;
        }
        if (sample < -128.0f) {
            sample = -128.0f;
        }
        this.byteBuffer[index] = (byte)(sample / 1.690932E7f);
    }

    @Override
    public int size() {
        return this.byteBuffer.length;
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(AudioFormat af) {
        this.format = af;
    }

    @Override
    public double[] asDoubleArray() {
        double[] d = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            d[i] = this.get(i);
        }
        return d;
    }

    @Override
    public double[][] asDoubleChannelArray() {
        int nc = this.format.getNumChannels();
        double[][] s = new double[nc][this.size() / nc];
        for (int c = 0; c < nc; ++c) {
            for (int sa = 0; sa < this.size() / nc; ++sa) {
                s[c][sa] = this.get(sa * nc + c);
            }
        }
        return s;
    }

    @Override
    public Iterator<Float> iterator() {
        this.iteratorCount = 0;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorCount < this.size();
    }

    @Override
    public Float next() {
        float f = this.get(this.iteratorCount);
        ++this.iteratorCount;
        return Float.valueOf(f);
    }

    @Override
    public void remove() {
        throw new NotImplementedException("Cannot remove from 16bit sample buffer");
    }

    @Override
    public AudioTimecode getStartTimecode() {
        return this.timecode;
    }
}

