/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.samples;

import gnu.trove.iterator.TFloatIterator;
import gnu.trove.list.array.TFloatArrayList;
import java.util.Iterator;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.timecode.AudioTimecode;
import org.openimaj.util.array.ArrayUtils;

public class FloatSampleBuffer
implements SampleBuffer,
Iterator<Float> {
    private float[] samples = null;
    private AudioFormat format = null;
    private TFloatIterator tfIterator;

    public FloatSampleBuffer(float[] samples, AudioFormat af) {
        this.format = af.clone();
        this.format.setNBits(-1);
        this.samples = samples;
    }

    public FloatSampleBuffer(double[] samples, AudioFormat af) {
        this(ArrayUtils.convertToFloat((double[])samples), af);
    }

    @Override
    public float get(int index) {
        return this.samples[index];
    }

    @Override
    public void set(int index, float sample) {
        this.samples[index] = sample;
    }

    @Override
    public int size() {
        return this.samples.length;
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(AudioFormat af) {
        this.format = af.clone();
        this.format.setNBits(-1);
    }

    @Override
    public SampleChunk getSampleChunk() {
        return null;
    }

    @Override
    public SampleChunk getSampleChunk(int channel) {
        return null;
    }

    @Override
    public double[] asDoubleArray() {
        return ArrayUtils.convertToDouble((float[])this.samples);
    }

    @Override
    public double[][] asDoubleChannelArray() {
        int nc = this.format.getNumChannels();
        double[][] s = new double[nc][this.samples.length / nc];
        for (int c = 0; c < nc; ++c) {
            for (int sa = 0; sa < this.samples.length / nc; ++sa) {
                s[c][sa] = this.samples[sa * nc + c];
            }
        }
        return s;
    }

    @Override
    public float getUnscaled(int index) {
        return this.get(index);
    }

    public FloatSampleBuffer multiply(double scalar) {
        for (int i = 0; i < this.samples.length; ++i) {
            this.set(i, (float)((double)this.samples[i] * scalar));
        }
        return this;
    }

    public FloatSampleBuffer add(double scalar) {
        for (int i = 0; i < this.samples.length; ++i) {
            this.set(i, (float)((double)this.samples[i] + scalar));
        }
        return this;
    }

    @Override
    public Iterator<Float> iterator() {
        this.tfIterator = this.tf_iterator();
        return this;
    }

    public TFloatIterator tf_iterator() {
        TFloatArrayList l = new TFloatArrayList();
        for (float f : this.samples) {
            l.add(f);
        }
        return l.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.tfIterator.hasNext();
    }

    @Override
    public Float next() {
        return Float.valueOf(this.tfIterator.next());
    }

    @Override
    public void remove() {
        this.tfIterator.remove();
    }

    @Override
    public AudioTimecode getStartTimecode() {
        return null;
    }
}

