/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.processor;

import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;

public abstract class AudioProcessor
extends AudioStream {
    private AudioStream stream = null;

    public AudioProcessor() {
    }

    public AudioProcessor(AudioStream a) {
        this.stream = a;
        if (a != null) {
            this.format = a.getFormat().clone();
        }
    }

    public void process(AudioStream a) throws Exception {
        this.stream = a;
        while (this.nextSampleChunk() != null) {
        }
        this.processingComplete(a);
    }

    public abstract SampleChunk process(SampleChunk var1) throws Exception;

    public void processingComplete(AudioStream a) {
    }

    @Override
    public SampleChunk nextSampleChunk() {
        try {
            SampleChunk s = this.stream.nextSampleChunk();
            return s != null ? this.process(s) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AudioStream getUnderlyingStream() {
        return this.stream;
    }

    public void setUnderlyingStream(AudioStream stream) {
        this.stream = stream;
        if (stream != null) {
            this.format = stream.getFormat().clone();
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public long getLength() {
        return this.stream.getLength();
    }
}

