/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.spectral;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.Eigenvalues;
import java.util.Iterator;
import org.openimaj.math.matrix.DiagonalMatrix;
import org.openimaj.math.matrix.MatlibMatrixUtils;
import org.openimaj.ml.clustering.spectral.FBEigenIterator;
import org.openimaj.util.pair.DoubleObjectPair;

public abstract class GraphLaplacian {
    public SparseMatrix laplacian(SparseMatrix adj) {
        DiagonalMatrix degree = new DiagonalMatrix(adj.rowCount());
        int i = 0;
        for (Vector row : adj.rows()) {
            degree.put(i, i, row.sum());
            ++i;
        }
        return this.laplacian(adj, degree);
    }

    public abstract SparseMatrix laplacian(SparseMatrix var1, DiagonalMatrix var2);

    public Iterator<DoubleObjectPair<Vector>> eigenIterator(Eigenvalues evd) {
        return new FBEigenIterator(evd);
    }

    public static class Warped
    extends GraphLaplacian {
        @Override
        public SparseMatrix laplacian(SparseMatrix adj, DiagonalMatrix degree) {
            DiagonalMatrix invDegree = (DiagonalMatrix)MatlibMatrixUtils.powInplace((Matrix)degree, (double)-1.0);
            for (int i = 0; i < degree.rowCount(); ++i) {
                if (!Double.isNaN(degree.get(i, i)) && !Double.isInfinite(degree.get(i, i))) continue;
                invDegree.put(i, i, 0.0);
            }
            SparseMatrix ret = MatlibMatrixUtils.times((SparseMatrix)MatlibMatrixUtils.times((DiagonalMatrix)invDegree, (SparseMatrix)adj), (DiagonalMatrix)invDegree);
            return ret;
        }

        @Override
        public Iterator<DoubleObjectPair<Vector>> eigenIterator(Eigenvalues evd) {
            return new FBEigenIterator(evd);
        }
    }

    public static class Normalised
    extends GraphLaplacian {
        @Override
        public SparseMatrix laplacian(SparseMatrix adj, DiagonalMatrix degree) {
            DiagonalMatrix invSqrtDegree = (DiagonalMatrix)MatlibMatrixUtils.powInplace((Matrix)degree, (double)-0.5);
            for (int i = 0; i < degree.rowCount(); ++i) {
                if (!Double.isNaN(degree.get(i, i)) && !Double.isInfinite(degree.get(i, i))) continue;
                invSqrtDegree.put(i, i, 0.0);
            }
            SparseMatrix ret = MatlibMatrixUtils.times((SparseMatrix)MatlibMatrixUtils.times((DiagonalMatrix)invSqrtDegree, (SparseMatrix)adj), (DiagonalMatrix)invSqrtDegree);
            return ret;
        }

        @Override
        public Iterator<DoubleObjectPair<Vector>> eigenIterator(Eigenvalues evd) {
            return new FBEigenIterator(evd);
        }
    }

    public static class Unnormalised
    extends GraphLaplacian {
        @Override
        public SparseMatrix laplacian(SparseMatrix adj, DiagonalMatrix degree) {
            SparseMatrix ret = (SparseMatrix)MatlibMatrixUtils.plusInplace((DiagonalMatrix)DiagonalMatrix.ones((int)degree.rowCount()), (Matrix)MatlibMatrixUtils.minusInplace((DiagonalMatrix)degree, (Matrix)adj));
            return ret;
        }
    }
}

