/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.rforest;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.DataSource;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.SpatialClusters;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.rforest.RandomDecisionTree;
import org.openimaj.util.hash.HashCodeUtil;
import org.openimaj.util.pair.IntFloatPair;

@Reference(type=ReferenceType.Article, author={"Frank Moosmann", "Eric Nowak", "Fr{'e}d{'e}ric Jurie"}, title="Randomized Clustering Forests for Image Classification", year="2008", journal="IEEE PAMI", url="http://dx.doi.org/10.1109/TPAMI.2007.70822")
public class IntRandomForest
implements SpatialClusters<int[]>,
SpatialClusterer<IntRandomForest, int[]>,
HardAssigner<int[], float[], IntFloatPair> {
    private static final String HEADER = "CLSTRFIC";
    int nDecisions;
    int nTrees;
    int featureLength;
    List<RandomDecisionTree> trees;
    int[] maxVal;
    int[] minVal;
    Map<Letter, Integer> letterToInt;
    private int currentInt = 0;
    private HashMap<Word, Integer> wordToInt;
    private int currentWordInt = 0;
    private int randomSeed = -1;

    private Word wordFromString(String str) {
        String[] values = str.split("_");
        Letter[] intValues = new Letter[values.length];
        int i = 0;
        for (String s : values) {
            intValues[i++] = this.letterFromString(s);
        }
        return new Word(intValues);
    }

    private Letter letterFromString(String str) {
        String[] values = str.split("-");
        boolean[] intValues = new boolean[values.length];
        int i = 0;
        for (int j = 0; j < values.length - 1; ++j) {
            intValues[i++] = Boolean.parseBoolean(values[j]);
        }
        return new Letter(intValues, Integer.parseInt(values[values.length - 1]));
    }

    public IntRandomForest() {
        this(32, 32);
    }

    public IntRandomForest(int nTrees, int nDecisions) {
        this.nTrees = nTrees;
        this.nDecisions = nDecisions;
        this.letterToInt = new HashMap<Letter, Integer>();
        this.wordToInt = new HashMap();
    }

    private void initMinMax(int[][] data) {
        int[] min = new int[this.featureLength];
        int[] max = new int[this.featureLength];
        boolean isSet = false;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < this.featureLength; ++j) {
                int val = data[i][j];
                if (!isSet) {
                    min[j] = val;
                    max[j] = val;
                    continue;
                }
                if (max[j] < val) {
                    max[j] = val;
                    continue;
                }
                if (min[j] <= val) continue;
                min[j] = val;
            }
            isSet = true;
        }
        this.setMinMax(min, max);
    }

    public void setMinMax(int[] min, int[] max) {
        this.minVal = min;
        this.maxVal = max;
    }

    private void initTrees() {
        this.trees = new LinkedList<RandomDecisionTree>();
        Random r = new Random();
        if (this.randomSeed != -1) {
            r = new Random(this.randomSeed);
        }
        for (int i = 0; i < this.nTrees; ++i) {
            RandomDecisionTree tree = new RandomDecisionTree(this.nDecisions, this.featureLength, this.minVal, this.maxVal, r);
            this.trees.add(tree);
        }
    }

    public IntRandomForest cluster(int[][] data) {
        this.featureLength = data[0].length;
        this.initMinMax(data);
        this.initTrees();
        return this;
    }

    @Override
    public IntRandomForest cluster(DataSource<int[]> data) {
        int[][] dataArr = new int[data.numRows()][data.numDimensions()];
        return this.cluster(dataArr);
    }

    @Override
    public int numClusters() {
        return this.currentInt;
    }

    @Override
    public int numDimensions() {
        return this.featureLength;
    }

    public int[] assign(int[][] data) {
        int[] proj = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            proj[i] = this.assign(data[i]);
        }
        return proj;
    }

    public Word[] assignLetters(int[][] data) {
        Word[] pushedLetters = new Word[data.length];
        int i = 0;
        for (int[] k : data) {
            pushedLetters[i++] = this.assignWord(k);
        }
        return pushedLetters;
    }

    public Word assignWord(int[] data) {
        Letter[] pushed = new Letter[this.nTrees];
        for (int i = 0; i < this.nTrees; ++i) {
            boolean[] justLetter = this.trees.get(i).getLetter(data);
            Letter letter = new Letter(justLetter, i);
            letter.hashedLetter();
            pushed[i] = letter;
        }
        return new Word(pushed);
    }

    @Override
    public int assign(int[] data) {
        Word word = this.assignWord(data);
        return word.hashedWord();
    }

    public int getNTrees() {
        return this.nTrees;
    }

    public int getNDecisions() {
        return this.nDecisions;
    }

    public List<RandomDecisionTree> getTrees() {
        return this.trees;
    }

    public boolean equals(Object r) {
        if (!(r instanceof IntRandomForest)) {
            return false;
        }
        IntRandomForest that = (IntRandomForest)r;
        boolean same = true;
        same &= this.numDimensions() == that.numDimensions();
        same &= this.getNTrees() == that.getNTrees();
        same &= this.getNDecisions() == that.getNDecisions();
        for (int i = 0; i < that.trees.size(); ++i) {
            this.trees.get(i).equals(that.trees.get(i));
        }
        for (Map.Entry<Letter, Integer> entry : that.letterToInt.entrySet()) {
            same &= that.letterToInt.get(entry.getKey()).equals(this.letterToInt.get(entry.getKey()));
        }
        for (Map.Entry<Object, Integer> entry : that.wordToInt.entrySet()) {
            same &= that.wordToInt.get(entry.getKey()).equals(this.wordToInt.get(entry.getKey()));
        }
        return same;
    }

    public String asciiHeader() {
        return "ASCIICLSTRFIC";
    }

    public byte[] binaryHeader() {
        return HEADER.getBytes();
    }

    public void readASCII(Scanner br) throws IOException {
        String[] part;
        int i;
        this.nDecisions = Integer.parseInt(br.nextLine());
        this.nTrees = Integer.parseInt(br.nextLine());
        this.letterToInt = new HashMap<Letter, Integer>();
        this.featureLength = Integer.parseInt(br.nextLine());
        if (this.trees == null || this.trees.size() != this.nTrees) {
            this.trees = new LinkedList<RandomDecisionTree>();
            for (int i2 = 0; i2 < this.nTrees; ++i2) {
                this.trees.add(new RandomDecisionTree().readASCII(br));
            }
        } else {
            for (RandomDecisionTree rt : this.trees) {
                rt.readASCII(br);
            }
        }
        String[] line = br.nextLine().split(" ");
        if (this.maxVal == null || this.maxVal.length != this.featureLength) {
            this.maxVal = new int[this.featureLength];
        }
        for (i = 0; i < this.featureLength; ++i) {
            this.maxVal[i] = Integer.parseInt(line[i]);
        }
        if (this.minVal == null || this.minVal.length != this.featureLength) {
            this.minVal = new int[this.featureLength];
        }
        line = br.nextLine().split(" ");
        for (i = 0; i < this.featureLength; ++i) {
            this.minVal[i] = Integer.parseInt(line[i]);
        }
        this.currentInt = Integer.parseInt(br.nextLine());
        line = br.nextLine().split(" ");
        assert (line.length - 1 == this.currentInt);
        for (i = 0; i < this.currentInt; ++i) {
            part = line[i].split(",");
            this.letterToInt.put(this.letterFromString(part[0]), Integer.parseInt(part[1]));
        }
        this.currentWordInt = Integer.parseInt(br.nextLine());
        if (this.currentWordInt != 0) {
            line = br.nextLine().split(" ");
            assert (line.length - 1 == this.currentWordInt);
            for (i = 0; i < this.currentWordInt; ++i) {
                part = line[i].split(",");
                this.wordToInt.put(this.wordFromString(part[0]), Integer.parseInt(part[1]));
            }
        }
    }

    public void readBinary(DataInput dis) throws IOException {
        int i;
        this.nDecisions = dis.readInt();
        this.nTrees = dis.readInt();
        this.letterToInt = new HashMap<Letter, Integer>();
        this.featureLength = dis.readInt();
        if (this.trees == null || this.trees.size() != this.nTrees) {
            this.trees = new LinkedList<RandomDecisionTree>();
            for (i = 0; i < this.nTrees; ++i) {
                this.trees.add(new RandomDecisionTree().readBinary(dis));
            }
        } else {
            for (RandomDecisionTree rt : this.trees) {
                rt.readBinary(dis);
            }
        }
        if (this.maxVal == null || this.maxVal.length != this.featureLength) {
            this.maxVal = new int[this.featureLength];
        }
        for (i = 0; i < this.featureLength; ++i) {
            this.maxVal[i] = dis.readInt();
        }
        if (this.minVal == null || this.minVal.length != this.featureLength) {
            this.minVal = new int[this.featureLength];
        }
        for (i = 0; i < this.featureLength; ++i) {
            this.minVal[i] = dis.readInt();
        }
        this.currentInt = dis.readInt();
        for (i = 0; i < this.currentInt; ++i) {
            int letterLen = dis.readInt();
            boolean[] stringBytes = new boolean[letterLen];
            for (int j = 0; j < letterLen; ++j) {
                stringBytes[j] = dis.readBoolean();
            }
            this.letterToInt.put(new Letter(stringBytes, dis.readInt()), dis.readInt());
        }
        this.currentWordInt = dis.readInt();
        if (this.currentWordInt != 0) {
            for (i = 0; i < this.currentWordInt; ++i) {
                Letter[] letters = new Letter[dis.readInt()];
                for (int j = 0; j < letters.length; ++j) {
                    int letterLen = dis.readInt();
                    boolean[] stringBytes = new boolean[letterLen];
                    for (int k = 0; k < stringBytes.length; ++k) {
                        stringBytes[k] = dis.readBoolean();
                    }
                    letters[j] = new Letter(stringBytes, dis.readInt());
                }
                this.wordToInt.put(new Word(letters), dis.readInt());
            }
        }
    }

    public void writeASCII(PrintWriter writer) throws IOException {
        int i;
        writer.println(this.nDecisions);
        writer.println(this.nTrees);
        writer.println(this.featureLength);
        for (RandomDecisionTree randomDecisionTree : this.trees) {
            randomDecisionTree.writeASCII(writer);
            writer.println();
        }
        for (i = 0; i < this.maxVal.length; ++i) {
            writer.print(this.maxVal[i] + " ");
        }
        writer.println();
        for (i = 0; i < this.minVal.length; ++i) {
            writer.print(this.minVal[i] + " ");
        }
        writer.println();
        writer.println(this.currentInt);
        for (Map.Entry<Letter, Integer> entry : this.letterToInt.entrySet()) {
            writer.print(entry.getKey() + "," + entry.getValue() + " ");
        }
        writer.println();
        writer.println(this.currentWordInt);
        for (Map.Entry<Object, Integer> entry : this.wordToInt.entrySet()) {
            writer.print(entry.getKey() + "," + entry.getValue() + " ");
        }
        writer.println();
        writer.flush();
    }

    public void writeBinary(DataOutput o) throws IOException {
        int i;
        o.writeInt(this.nDecisions);
        o.writeInt(this.nTrees);
        o.writeInt(this.featureLength);
        for (RandomDecisionTree randomDecisionTree : this.trees) {
            randomDecisionTree.write(o);
        }
        for (i = 0; i < this.maxVal.length; ++i) {
            o.writeInt(this.maxVal[i]);
        }
        for (i = 0; i < this.minVal.length; ++i) {
            o.writeInt(this.minVal[i]);
        }
        o.writeInt(this.currentInt);
        for (Map.Entry<Letter, Integer> entry : this.letterToInt.entrySet()) {
            o.writeInt(entry.getKey().value.length);
            for (boolean i2 : entry.getKey().value) {
                o.writeBoolean(i2);
            }
            o.writeInt(entry.getKey().treeIndex);
            o.writeInt(entry.getValue());
        }
        o.writeInt(this.currentWordInt);
        for (Map.Entry<Object, Integer> entry : this.wordToInt.entrySet()) {
            o.writeInt(((Word)entry.getKey()).letters.length);
            for (Letter i3 : ((Word)entry.getKey()).letters) {
                o.writeInt(i3.value.length);
                for (boolean j : i3.value) {
                    o.writeBoolean(j);
                }
                o.writeInt(i3.treeIndex);
            }
            o.writeInt(entry.getValue());
        }
    }

    public void setRandomSeed(int random) {
        this.randomSeed = random;
    }

    Letter newLetter(boolean[] bs, int i) {
        return new Letter(bs, i);
    }

    Word newWord(Letter[] letters) {
        return new Word(letters);
    }

    public void assignDistance(int[][] data, int[] indices, float[] distances) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public IntFloatPair assignDistance(int[] data) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public HardAssigner<int[], ?, ?> defaultHardAssigner() {
        return this;
    }

    @Override
    public int size() {
        return this.currentInt;
    }

    public int[][] performClustering(int[][] data) {
        return new IndexClusters(this.cluster(data).defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    class Letter {
        boolean[] value;
        int treeIndex;

        public Letter(boolean[] value, int treeIndex) {
            this.value = value;
            this.treeIndex = treeIndex;
        }

        public int hashCode() {
            int result = 23;
            result = HashCodeUtil.hash((int)result, (boolean[])this.value);
            result = HashCodeUtil.hash((int)result, (int)this.treeIndex);
            return result;
        }

        public int getTreeIndex() {
            return this.treeIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Letter)) {
                return false;
            }
            Letter that = (Letter)obj;
            boolean same = true;
            for (int i = 0; i < this.value.length; ++i) {
                if (same &= this.value[i] == that.value[i]) continue;
                return false;
            }
            return same &= this.treeIndex == that.treeIndex;
        }

        public String toString() {
            String outString = "";
            for (int i = 0; i < this.value.length; ++i) {
                outString = outString + "-" + (this.value[i] ? 1 : 0);
            }
            return outString.substring(1) + "-" + this.treeIndex;
        }

        public int hashedLetter() {
            if (!IntRandomForest.this.letterToInt.containsKey(this)) {
                IntRandomForest.this.letterToInt.put(this, IntRandomForest.this.currentInt++);
                if (IntRandomForest.this.currentInt == Integer.MAX_VALUE) {
                    System.err.println("... too many letters!");
                    IntRandomForest.this.currentInt = 0;
                }
            }
            return IntRandomForest.this.letterToInt.get(this);
        }
    }

    class Word {
        private Letter[] letters;

        Word(Letter[] value) {
            this.letters = value;
        }

        public int hashCode() {
            int result = 23;
            for (Letter l : this.letters) {
                result = HashCodeUtil.hash((int)result, (Object)l);
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Word)) {
                return false;
            }
            Word that = (Word)obj;
            boolean same = true;
            for (int i = 0; i < this.letters.length; ++i) {
                if (same &= this.letters[i].equals(that.letters[i])) continue;
                return false;
            }
            return same;
        }

        public String toString() {
            String outString = "";
            for (int i = 0; i < this.letters.length; ++i) {
                outString = outString + "_" + this.letters[i];
            }
            return outString.substring(1);
        }

        public int hashedWord() {
            if (!IntRandomForest.this.wordToInt.containsKey(this)) {
                IntRandomForest.this.wordToInt.put(this, IntRandomForest.this.currentWordInt++);
                if (IntRandomForest.this.currentWordInt == Integer.MAX_VALUE) {
                    System.err.println("Too many words!");
                    IntRandomForest.this.currentWordInt = 0;
                }
            }
            return (Integer)IntRandomForest.this.wordToInt.get(this);
        }
    }
}

