/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.random;

import java.util.Arrays;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.ShortCentroidsResult;
import org.openimaj.ml.clustering.SpatialClusterer;

public class RandomShortClusterer
implements SpatialClusterer<ShortCentroidsResult, short[]> {
    protected int M;
    protected int K;
    protected Random random;
    protected long seed;

    public RandomShortClusterer(int M, int K) {
        this.M = M;
        this.K = K;
        this.random = new Random();
        this.seed = -1L;
    }

    public RandomShortClusterer(int M) {
        this(M, -1);
    }

    public void setSeed(long seed) {
        this.random = new Random();
        this.random.setSeed(seed);
        this.seed = seed;
    }

    public ShortCentroidsResult cluster(short[][] data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.length;
        }
        ShortCentroidsResult result = new ShortCentroidsResult();
        result.centroids = new short[nc][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.length);
            result.centroids[i] = Arrays.copyOf(data[dIndex], data[dIndex].length);
        }
        return result;
    }

    public int[][] performClustering(short[][] data) {
        ShortCentroidsResult res = this.cluster(data);
        return new IndexClusters(res.defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    @Override
    public ShortCentroidsResult cluster(DataSource<short[]> data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.numRows();
        }
        ShortCentroidsResult result = new ShortCentroidsResult();
        result.centroids = new short[nc][this.M];
        short[][] dataRow = new short[1][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.numRows());
            dataRow[0] = result.centroids[i];
            data.getData(dIndex, dIndex + 1, (Object[])dataRow);
        }
        return result;
    }
}

