/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.ml.clustering.FloatCentroidsResult;
import org.openimaj.ml.clustering.SpatialClusters;
import org.openimaj.ml.clustering.assignment.hard.HierarchicalFloatHardAssigner;

public class HierarchicalFloatKMeansResult
implements SpatialClusters<float[]> {
    private static final String HEADER = "CLSTH" + "Float".charAt(0) + "KM";
    int M;
    int K;
    int depth;
    Node root;

    protected HierarchicalFloatKMeansResult() {
    }

    @Override
    public int numDimensions() {
        return this.M;
    }

    public int getK() {
        return this.K;
    }

    public int getDepth() {
        return this.depth;
    }

    public Node getRoot() {
        return this.root;
    }

    private static int ipow(int x, int y) {
        int sum = 1;
        for (int i = 0; i < y; ++i) {
            sum *= x;
        }
        return sum;
    }

    public static int getIndex(int[] path, int depth, int K) {
        int idx = 0;
        for (int i = 0; i < depth; ++i) {
            idx += path[i] * HierarchicalFloatKMeansResult.ipow(K, depth - 1 - i);
        }
        return idx;
    }

    public int getIndex(int[] path) {
        return HierarchicalFloatKMeansResult.getIndex(path, this.depth, this.K);
    }

    public static int[] getPath(int index, int depth, int K) {
        int[] path = new int[depth];
        block0: for (int i = 0; i < depth; ++i) {
            int v = HierarchicalFloatKMeansResult.ipow(K, depth - 1 - i);
            for (int j = 0; j < K; ++j) {
                int vp = v * j;
                int vpn = v * (j + 1);
                if (index >= vpn) continue;
                path[i] = j;
                index -= vp;
                continue block0;
            }
        }
        return path;
    }

    public int[] getPath(int index) {
        return HierarchicalFloatKMeansResult.getPath(index, this.depth, this.K);
    }

    private int countLeaves(Node node) {
        int count = 0;
        if (node.children == null) {
            count = node.result.numClusters();
        } else {
            for (int i = 0; i < node.result.numClusters(); ++i) {
                count += this.countLeaves(node.children[i]);
            }
        }
        return count;
    }

    public int countActiveLeafNodes() {
        return this.countLeaves(this.root);
    }

    public String toString() {
        String s = "";
        s = s + String.format("Number of dimensions:               %d\n", this.M);
        s = s + String.format("Number of clusters:                 %d\n", this.K);
        s = s + String.format("Number of levels:                   %d\n", this.depth);
        s = s + String.format("Maximum number of leaf nodes:       %d\n", HierarchicalFloatKMeansResult.ipow(this.K, this.depth));
        s = s + String.format("Number of leaf active nodes:        %d", this.countActiveLeafNodes());
        return s;
    }

    public int countLeafs() {
        return HierarchicalFloatKMeansResult.ipow(this.K, this.depth);
    }

    @Override
    public int numClusters() {
        return this.countLeafs();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HierarchicalFloatKMeansResult)) {
            return false;
        }
        HierarchicalFloatKMeansResult other = (HierarchicalFloatKMeansResult)o;
        return other.countActiveLeafNodes() == this.countActiveLeafNodes() && other.getDepth() == this.getDepth() && other.getK() == this.getK() && other.numDimensions() == this.numDimensions();
    }

    public float[] getClusterCentroid(int[] path) {
        Node node = this.root;
        for (int i = 0; i < path.length - 1; ++i) {
            node = node.children[path[i]];
        }
        return node.result.getCentroids()[path[path.length - 1]];
    }

    public String asciiHeader() {
        return "ASCII" + HEADER;
    }

    public byte[] binaryHeader() {
        return HEADER.getBytes();
    }

    public void readASCII(Scanner reader) throws IOException {
        this.M = Integer.parseInt(reader.nextLine());
        this.K = Integer.parseInt(reader.nextLine());
        this.depth = Integer.parseInt(reader.nextLine());
        this.root = this.readNode(this, reader);
    }

    private Node readNode(HierarchicalFloatKMeansResult hFloatkm, Scanner reader) throws IOException {
        String line;
        while ((line = reader.nextLine()).length() == 0) {
        }
        char type = line.charAt(0);
        Node node = new Node();
        node.result = new FloatCentroidsResult();
        node.result.readASCII(reader);
        if (type == 'I') {
            node.children = new Node[node.result.numClusters()];
            for (int i = 0; i < node.result.numClusters(); ++i) {
                node.children[i] = this.readNode(hFloatkm, reader);
            }
        } else {
            node.children = null;
        }
        return node;
    }

    public void readBinary(DataInput dis) throws IOException {
        this.M = dis.readInt();
        this.K = dis.readInt();
        this.depth = dis.readInt();
        this.root = this.readNodeB(this, dis);
    }

    private Node readNodeB(HierarchicalFloatKMeansResult hFloatkm, DataInput dis) throws IOException {
        Node node = new Node();
        char type = (char)dis.readByte();
        node.result = new FloatCentroidsResult();
        node.result.readBinary(dis);
        if (type == 'I') {
            node.children = new Node[node.result.numClusters()];
            for (int i = 0; i < node.result.numClusters(); ++i) {
                node.children[i] = this.readNodeB(hFloatkm, dis);
            }
        } else {
            node.children = null;
        }
        return node;
    }

    public void writeASCII(PrintWriter writer) throws IOException {
        writer.format("%d\n", this.M);
        writer.format("%d\n", this.K);
        writer.format("%d\n", this.depth);
        this.writeNodeASCII(writer, this.root);
    }

    private void writeNodeASCII(PrintWriter writer, Node node) throws IOException {
        if (node.children == null) {
            writer.write("L\n");
        } else {
            writer.write("I\n");
        }
        node.result.writeASCII(writer);
        writer.flush();
        if (node.children != null) {
            for (int i = 0; i < node.result.numClusters(); ++i) {
                this.writeNodeASCII(writer, node.children[i]);
            }
        }
    }

    public void writeBinary(DataOutput dos) throws IOException {
        dos.writeInt(this.M);
        dos.writeInt(this.K);
        dos.writeInt(this.depth);
        this.writeNodeB(dos, this.root);
    }

    private void writeNodeB(DataOutput dos, Node node) throws IOException {
        int type = node.children == null ? 76 : 73;
        dos.writeByte(type);
        node.result.writeBinary(dos);
        if (node.children != null) {
            for (int i = 0; i < node.result.numClusters(); ++i) {
                this.writeNodeB(dos, node.children[i]);
            }
        }
    }

    public HierarchicalFloatHardAssigner defaultHardAssigner() {
        return new HierarchicalFloatHardAssigner(this);
    }

    public static class Node {
        public FloatCentroidsResult result;
        public Node[] children;
    }
}

