/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.feature.ShortFVComparator;
import org.openimaj.feature.ShortFVComparison;
import org.openimaj.knn.ShortNearestNeighboursExact;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class ExactShortAssigner
implements HardAssigner<short[], float[], IntFloatPair> {
    protected ShortNearestNeighboursExact nn;

    public ExactShortAssigner(CentroidsProvider<short[]> provider) {
        this(provider, null);
    }

    public ExactShortAssigner(CentroidsProvider<short[]> provider, ShortFVComparison comparison) {
        this.nn = new ShortNearestNeighboursExact((short[][])provider.getCentroids(), (ShortFVComparator)comparison);
    }

    public ExactShortAssigner(short[][] data, ShortFVComparison comparison) {
        this.nn = new ShortNearestNeighboursExact(data, (ShortFVComparator)comparison);
    }

    public int[] assign(short[][] data) {
        int[] argmins = new int[data.length];
        float[] mins = new float[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(short[] data) {
        return this.assign(new short[][]{data})[0];
    }

    public void assignDistance(short[][] data, int[] indices, float[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntFloatPair assignDistance(short[] data) {
        int[] index = new int[1];
        float[] distance = new float[1];
        this.nn.searchNN((short[][])new short[][]{data}, index, distance);
        return new IntFloatPair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    public ShortNearestNeighboursExact getNN() {
        return this.nn;
    }
}

