/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.feature.ByteFVComparator;
import org.openimaj.feature.ByteFVComparison;
import org.openimaj.knn.ByteNearestNeighboursExact;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class ExactByteAssigner
implements HardAssigner<byte[], float[], IntFloatPair> {
    protected ByteNearestNeighboursExact nn;

    public ExactByteAssigner(CentroidsProvider<byte[]> provider) {
        this(provider, null);
    }

    public ExactByteAssigner(CentroidsProvider<byte[]> provider, ByteFVComparison comparison) {
        this.nn = new ByteNearestNeighboursExact((byte[][])provider.getCentroids(), (ByteFVComparator)comparison);
    }

    public ExactByteAssigner(byte[][] data, ByteFVComparison comparison) {
        this.nn = new ByteNearestNeighboursExact(data, (ByteFVComparator)comparison);
    }

    public int[] assign(byte[][] data) {
        int[] argmins = new int[data.length];
        float[] mins = new float[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(byte[] data) {
        return this.assign(new byte[][]{data})[0];
    }

    public void assignDistance(byte[][] data, int[] indices, float[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntFloatPair assignDistance(byte[] data) {
        int[] index = new int[1];
        float[] distance = new float[1];
        this.nn.searchNN((byte[][])new byte[][]{data}, index, distance);
        return new IntFloatPair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    public ByteNearestNeighboursExact getNN() {
        return this.nn;
    }
}

