/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Scanner;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.SpatialClusters;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactFloatAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class FloatCentroidsResult
implements SpatialClusters<float[]>,
CentroidsProvider<float[]> {
    static final String HEADER = "CLST" + "Float".charAt(0) + "Cen";
    public float[][] centroids;

    public boolean equals(Object obj) {
        if (!(obj instanceof FloatCentroidsResult)) {
            return false;
        }
        FloatCentroidsResult other = (FloatCentroidsResult)obj;
        for (int i = 0; i < this.centroids.length; ++i) {
            if (Arrays.equals(this.centroids[i], other.centroids[i])) continue;
            return false;
        }
        return true;
    }

    public String asciiHeader() {
        return "ASCII" + HEADER;
    }

    public byte[] binaryHeader() {
        return HEADER.getBytes();
    }

    public void readASCII(Scanner br) throws IOException {
        int K = Integer.parseInt(br.nextLine().trim());
        int M = Integer.parseInt(br.nextLine().trim());
        this.centroids = new float[K][M];
        for (int k = 0; k < K; ++k) {
            String[] parts = br.nextLine().split(",");
            for (int d = 0; d < M; ++d) {
                this.centroids[k][d] = Float.parseFloat(parts[d]);
            }
        }
    }

    public void readBinary(DataInput in) throws IOException {
        int K = in.readInt();
        int M = in.readInt();
        this.centroids = new float[K][M];
        for (int k = 0; k < K; ++k) {
            for (int d = 0; d < M; ++d) {
                this.centroids[k][d] = in.readFloat();
            }
        }
    }

    public void writeASCII(PrintWriter writer) throws IOException {
        writer.println(this.centroids.length);
        writer.println(this.centroids[0].length);
        for (int k = 0; k < this.centroids.length; ++k) {
            for (int d = 0; d < this.centroids[0].length; ++d) {
                writer.print(this.centroids[k][d] + ",");
            }
            writer.println();
        }
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.centroids.length);
        out.writeInt(this.centroids[0].length);
        for (int k = 0; k < this.centroids.length; ++k) {
            for (int d = 0; d < this.centroids[0].length; ++d) {
                out.writeFloat(this.centroids[k][d]);
            }
        }
    }

    public String toString() {
        String str = "";
        str = str + "FloatCentroidsResult\n";
        str = str + "No. of Clusters: " + this.centroids.length + "\n";
        str = str + "No. of Dimensions: " + this.centroids[0].length + "\n";
        return str;
    }

    public float[][] getCentroids() {
        return this.centroids;
    }

    @Override
    public HardAssigner<float[], float[], IntFloatPair> defaultHardAssigner() {
        return new ExactFloatAssigner(this);
    }

    @Override
    public int numDimensions() {
        return this.centroids[0].length;
    }

    @Override
    public int numClusters() {
        return this.centroids.length;
    }
}

