/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import org.openimaj.knn.DoubleNearestNeighbours;
import org.openimaj.knn.DoubleNearestNeighboursProvider;
import org.openimaj.knn.pq.DoubleProductQuantiser;
import org.openimaj.ml.clustering.kmeans.DoubleKMeans;

public final class DoubleProductQuantiserUtilities {
    private DoubleProductQuantiserUtilities() {
    }

    public static DoubleProductQuantiser train(double[][] data, int numAssigners, int K, int nIter) {
        if (K > 256 || K <= 0) {
            throw new IllegalArgumentException("0 <= K < 256");
        }
        int subDim = data[0].length / numAssigners;
        double[][] tmp = new double[data.length][subDim];
        DoubleNearestNeighbours[] assigners = new DoubleNearestNeighbours[numAssigners];
        DoubleKMeans kmeans = DoubleKMeans.createExact(K, 100);
        for (int i = 0; i < numAssigners; ++i) {
            for (int j = 0; j < data.length; ++j) {
                System.arraycopy(data[j], i * subDim, tmp[j], 0, subDim);
            }
            DoubleNearestNeighboursProvider centroids = (DoubleNearestNeighboursProvider)kmeans.cluster(tmp);
            assigners[i] = centroids.getNearestNeighbours();
        }
        return new DoubleProductQuantiser(assigners);
    }

    public static DoubleProductQuantiser train(double[][] data, int numAssigners, int nIter) {
        return DoubleProductQuantiserUtilities.train(data, numAssigners, 256, nIter);
    }
}

