/*
 * Decompiled with CFR 0.152.
 */
package com.jsaragih;

import Jama.Matrix;
import com.jsaragih.IO;
import com.jsaragih.MPatch;
import com.jsaragih.PDM;
import com.jsaragih.Tracker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Scanner;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.math.matrix.MatrixUtils;

@Reference(type=ReferenceType.Inproceedings, author={"Jason M. Saragih", "Simon Lucey", "Jeffrey F. Cohn"}, title="Face alignment through subspace constrained mean-shifts", year="2009", booktitle="IEEE 12th International Conference on Computer Vision, ICCV 2009, Kyoto, Japan, September 27 - October 4, 2009", pages={"1034", "1041"}, publisher="IEEE", customData={"doi", "http://dx.doi.org/10.1109/ICCV.2009.5459377", "researchr", "http://researchr.org/publication/SaragihLC09", "cites", "0", "citedby", "0"})
public class CLM {
    public PDM _pdm;
    public Matrix _plocal;
    public Matrix _pglobl;
    public Matrix _refs;
    public Matrix[] _cent;
    public Matrix[] _visi;
    public MPatch[][] _patch;
    private Matrix cshape_;
    private Matrix bshape_;
    private Matrix oshape_;
    private Matrix ms_;
    private Matrix u_;
    private Matrix g_;
    private Matrix J_;
    private Matrix H_;
    private FImage[] prob_;
    private FImage[] pmem_;
    private FImage[] wmem_;

    void calcSimT(Matrix src, Matrix dst, SimTData data) {
        assert (src.getRowDimension() == dst.getRowDimension() && src.getColumnDimension() == dst.getColumnDimension() && src.getColumnDimension() == 1);
        int n = src.getRowDimension() / 2;
        Matrix H = new Matrix(4, 4);
        Matrix g = new Matrix(4, 1);
        double[][] Hv = H.getArray();
        double[][] gv = g.getArray();
        for (int i = 0; i < n; ++i) {
            double ptr1x = src.get(i, 0);
            double ptr1y = src.get(i + n, 0);
            double ptr2x = dst.get(i, 0);
            double ptr2y = dst.get(i + n, 0);
            double[] dArray = Hv[0];
            dArray[0] = dArray[0] + (ptr1x * ptr1x + ptr1y * ptr1y);
            double[] dArray2 = Hv[0];
            dArray2[2] = dArray2[2] + ptr1x;
            double[] dArray3 = Hv[0];
            dArray3[3] = dArray3[3] + ptr1y;
            double[] dArray4 = gv[0];
            dArray4[0] = dArray4[0] + (ptr1x * ptr2x + ptr1y * ptr2y);
            double[] dArray5 = gv[1];
            dArray5[0] = dArray5[0] + (ptr1x * ptr2y - ptr1y * ptr2x);
            double[] dArray6 = gv[2];
            dArray6[0] = dArray6[0] + ptr2x;
            double[] dArray7 = gv[3];
            dArray7[0] = dArray7[0] + ptr2y;
        }
        Hv[1][1] = Hv[0][0];
        Hv[3][0] = Hv[0][3];
        double d = -Hv[3][0];
        Hv[2][1] = d;
        Hv[1][2] = d;
        double d2 = Hv[0][2];
        Hv[2][0] = d2;
        Hv[3][1] = d2;
        Hv[1][3] = d2;
        double d3 = n;
        Hv[3][3] = d3;
        Hv[2][2] = d3;
        Matrix p = H.solve(g);
        data.a = p.get(0, 0);
        data.b = p.get(1, 0);
        data.tx = p.get(2, 0);
        data.ty = p.get(3, 0);
    }

    void invSimT(SimTData in, SimTData out) {
        Matrix M = new Matrix((double[][])new double[][]{{in.a, -in.b}, {in.b, in.a}});
        Matrix N = M.inverse();
        out.a = N.get(0, 0);
        out.b = N.get(1, 0);
        out.tx = -1.0 * (N.get(0, 0) * in.tx + N.get(0, 1) * in.ty);
        out.ty = -1.0 * (N.get(1, 0) * in.tx + N.get(1, 1) * in.ty);
    }

    void simT(Matrix s, SimTData data) {
        assert (s.getColumnDimension() == 1);
        int n = s.getRowDimension() / 2;
        for (int i = 0; i < n; ++i) {
            double x = s.get(i, 0);
            double y = s.get(i + n, 0);
            s.set(i, 0, data.a * x - data.b * y + data.tx);
            s.set(i + n, 0, data.b * x + data.a * y + data.ty);
        }
    }

    public CLM(PDM s, Matrix r, Matrix[] c, Matrix[] v, MPatch[][] p) {
        int i;
        int n = p.length;
        assert (c.length == n && v.length == n);
        assert (r.getRowDimension() == 2 * s.nPoints() && r.getColumnDimension() == 1);
        for (i = 0; i < n; ++i) {
            assert (p[i].length == s.nPoints());
            assert (c[i].getRowDimension() == 3 && c[i].getColumnDimension() == 1);
            assert (v[i].getRowDimension() == s.nPoints() && v[i].getColumnDimension() == 1);
        }
        this._pdm = s;
        this._refs = r.copy();
        this._cent = new Matrix[n];
        this._visi = new Matrix[n];
        this._patch = new MPatch[n][];
        for (i = 0; i < n; ++i) {
            this._cent[i] = c[i].copy();
            this._visi[i] = v[i].copy();
            this._patch[i] = new MPatch[p[i].length];
            for (int j = 0; j < p[i].length; ++j) {
                this._patch[i][j] = p[i][j];
            }
        }
        this._plocal = new Matrix(this._pdm.nModes(), 1);
        this._pglobl = new Matrix(6, 1);
        this.cshape_ = new Matrix(2 * this._pdm.nPoints(), 1);
        this.bshape_ = new Matrix(2 * this._pdm.nPoints(), 1);
        this.oshape_ = new Matrix(2 * this._pdm.nPoints(), 1);
        this.ms_ = new Matrix(2 * this._pdm.nPoints(), 1);
        this.u_ = new Matrix(6 + this._pdm.nModes(), 1);
        this.g_ = new Matrix(6 + this._pdm.nModes(), 1);
        this.J_ = new Matrix(2 * this._pdm.nPoints(), 6 + this._pdm.nModes());
        this.H_ = new Matrix(6 + this._pdm.nModes(), 6 + this._pdm.nModes());
        this.prob_ = new FImage[this._pdm.nPoints()];
        this.pmem_ = new FImage[this._pdm.nPoints()];
        this.wmem_ = new FImage[this._pdm.nPoints()];
    }

    CLM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CLM load(String fname) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fname));
            Scanner sc = new Scanner(br);
            CLM cLM = CLM.read(sc, true);
            return cLM;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String fname) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fname));
            this.write(bw);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void write(BufferedWriter s) throws IOException {
        int i;
        s.write(IO.Types.CLM.ordinal() + " " + this._patch.length + " ");
        this._pdm.write(s);
        IO.writeMat(s, this._refs);
        for (i = 0; i < this._cent.length; ++i) {
            IO.writeMat(s, this._cent[i]);
        }
        for (i = 0; i < this._visi.length; ++i) {
            IO.writeMat(s, this._visi[i]);
        }
        for (i = 0; i < this._patch.length; ++i) {
            for (int j = 0; j < this._pdm.nPoints(); ++j) {
                this._patch[i][j].write(s);
            }
        }
    }

    public static CLM read(Scanner s, boolean readType) {
        int i;
        if (readType) {
            int type = s.nextInt();
            assert (type == IO.Types.CLM.ordinal());
        }
        CLM clm = new CLM();
        int n = s.nextInt();
        clm._pdm = PDM.read(s, true);
        clm._cent = new Matrix[n];
        clm._visi = new Matrix[n];
        clm._patch = new MPatch[n][];
        clm._refs = IO.readMat(s);
        for (i = 0; i < clm._cent.length; ++i) {
            clm._cent[i] = IO.readMat(s);
        }
        for (i = 0; i < clm._visi.length; ++i) {
            clm._visi[i] = IO.readMat(s);
        }
        for (i = 0; i < clm._patch.length; ++i) {
            clm._patch[i] = new MPatch[clm._pdm.nPoints()];
            for (int j = 0; j < clm._pdm.nPoints(); ++j) {
                clm._patch[i][j] = MPatch.read(s, true);
            }
        }
        clm._plocal = new Matrix(clm._pdm.nModes(), 1);
        clm._pglobl = new Matrix(6, 1);
        clm.cshape_ = new Matrix(2 * clm._pdm.nPoints(), 1);
        clm.bshape_ = new Matrix(2 * clm._pdm.nPoints(), 1);
        clm.oshape_ = new Matrix(2 * clm._pdm.nPoints(), 1);
        clm.ms_ = new Matrix(2 * clm._pdm.nPoints(), 1);
        clm.u_ = new Matrix(6 + clm._pdm.nModes(), 1);
        clm.g_ = new Matrix(6 + clm._pdm.nModes(), 1);
        clm.J_ = new Matrix(2 * clm._pdm.nPoints(), 6 + clm._pdm.nModes());
        clm.H_ = new Matrix(6 + clm._pdm.nModes(), 6 + clm._pdm.nModes());
        clm.prob_ = new FImage[clm._pdm.nPoints()];
        clm.pmem_ = new FImage[clm._pdm.nPoints()];
        clm.wmem_ = new FImage[clm._pdm.nPoints()];
        return clm;
    }

    public CLM copy() {
        int i;
        CLM c = new CLM();
        c._pdm = this._pdm.copy();
        c._cent = new Matrix[this._cent.length];
        c._visi = new Matrix[this._visi.length];
        c._patch = new MPatch[this._patch.length][];
        for (i = 0; i < this._cent.length; ++i) {
            c._cent[i] = this._cent[i].copy();
        }
        for (i = 0; i < this._visi.length; ++i) {
            c._visi[i] = this._visi[i].copy();
        }
        for (i = 0; i < this._patch.length; ++i) {
            c._patch[i] = new MPatch[this._pdm.nPoints()];
            for (int j = 0; j < this._pdm.nPoints(); ++j) {
                c._patch[i][j] = this._patch[i][j].copy();
            }
        }
        c._refs = this._refs.copy();
        c._plocal = this._plocal.copy();
        c._pglobl = this._pglobl.copy();
        c.cshape_ = this.cshape_.copy();
        c.bshape_ = this.bshape_.copy();
        c.oshape_ = this.oshape_.copy();
        c.ms_ = this.ms_.copy();
        c.u_ = this.u_.copy();
        c.g_ = this.g_.copy();
        c.J_ = this.J_.copy();
        c.H_ = this.H_.copy();
        c.prob_ = (FImage[])Arrays.copyOf(this.prob_, this.prob_.length, new FImage[0].getClass());
        c.pmem_ = (FImage[])Arrays.copyOf(this.pmem_, this.pmem_.length, new FImage[0].getClass());
        c.wmem_ = (FImage[])Arrays.copyOf(this.wmem_, this.wmem_.length, new FImage[0].getClass());
        return c;
    }

    final int nViews() {
        return this._patch.length;
    }

    public int getViewIdx() {
        int idx = 0;
        if (this.nViews() == 1) {
            return 0;
        }
        double dbest = -1.0;
        for (int i = 0; i < this.nViews(); ++i) {
            double v1 = this._pglobl.get(1, 0) - this._cent[i].get(0, 0);
            double v2 = this._pglobl.get(2, 0) - this._cent[i].get(1, 0);
            double v3 = this._pglobl.get(3, 0) - this._cent[i].get(2, 0);
            double d = v1 * v1 + v2 * v2 + v3 * v3;
            if (!(dbest < 0.0) && !(d < dbest)) continue;
            dbest = d;
            idx = i;
        }
        return idx;
    }

    public void fit(FImage im, int[] wSize, int nIter, double clamp, double fTol) {
        int n = this._pdm.nPoints();
        SimTData d1 = new SimTData();
        SimTData d2 = new SimTData();
        for (int witer = 0; witer < wSize.length; ++witer) {
            this._pdm.calcShape2D(this.cshape_, this._plocal, this._pglobl);
            this.calcSimT(this._refs, this.cshape_, d1);
            this.invSimT(d1, d2);
            int idx = this.getViewIdx();
            for (int i = 0; i < n; ++i) {
                FImage wimg;
                if (this._visi[idx].getRowDimension() == n && this._visi[idx].get(i, 0) == 0.0) continue;
                int w = wSize[witer] + this._patch[idx][i]._w - 1;
                int h = wSize[witer] + this._patch[idx][i]._h - 1;
                Matrix sim = new Matrix((double[][])new double[][]{{d1.a, -d1.b, this.cshape_.get(i, 0)}, {d1.b, d1.a, this.cshape_.get(i + n, 0)}});
                if (this.wmem_[i] == null || w > this.wmem_[i].width || h > this.wmem_[i].height) {
                    this.wmem_[i] = new FImage(w, h);
                }
                FImage wimg_o = wimg = this.subImage(this.wmem_[i], w, h);
                Matrix sim_o = sim;
                FImage im_o = im;
                this.cvGetQuadrangleSubPix(im_o, wimg_o, sim_o);
                if (this.pmem_[i] == null || wSize[witer] > this.pmem_[i].height) {
                    this.pmem_[i] = new FImage(wSize[witer], wSize[witer]);
                }
                this.prob_[i] = this.subImage(this.pmem_[i], wSize[witer], wSize[witer]);
                this._patch[idx][i].response(wimg, this.prob_[i]);
            }
            this.simT(this.cshape_, d2);
            this._pdm.applySimT(d2, this._pglobl);
            this.bshape_.setMatrix(0, this.cshape_.getRowDimension() - 1, 0, this.cshape_.getColumnDimension() - 1, this.cshape_);
            this.optimize(idx, wSize[witer], nIter, fTol, clamp, true);
            this.optimize(idx, wSize[witer], nIter, fTol, clamp, false);
            this._pdm.applySimT(d1, this._pglobl);
        }
    }

    private FImage subImage(FImage fImage, int w, int h) {
        FImage img = new FImage(fImage.pixels);
        img.width = w;
        img.height = h;
        return img;
    }

    private void cvGetQuadrangleSubPix(FImage src, FImage dest, Matrix tx) {
        float[][] dpix = dest.pixels;
        double A11 = tx.get(0, 0);
        double A12 = tx.get(0, 1);
        double A21 = tx.get(1, 0);
        double A22 = tx.get(1, 1);
        double b1 = tx.get(0, 2);
        double b2 = tx.get(1, 2);
        for (int y = 0; y < dest.width; ++y) {
            for (int x = 0; x < dest.height; ++x) {
                double xp = (double)x - (double)(dest.width - 1) * 0.5;
                double yp = (double)y - (double)(dest.height - 1) * 0.5;
                float xpp = (float)(A11 * xp + A12 * yp + b1);
                float ypp = (float)(A21 * xp + A22 * yp + b2);
                dpix[y][x] = src.getPixelInterpNative(xpp, ypp, 0.0f);
            }
        }
    }

    void optimize(int idx, int wSize, int nIter, double fTol, double clamp, boolean rigid) {
        Matrix H;
        Matrix J;
        Matrix g;
        Matrix u;
        int m = this._pdm.nModes();
        int n = this._pdm.nPoints();
        double sigma = (double)(wSize * wSize) / 36.0;
        if (rigid) {
            u = this.u_.getMatrix(0, 5, 0, 0);
            g = this.g_.getMatrix(0, 5, 0, 0);
            J = this.J_.getMatrix(0, 2 * n - 1, 0, 5);
            H = this.H_.getMatrix(0, 5, 0, 5);
        } else {
            u = this.u_;
            g = this.g_;
            J = this.J_;
            H = this.H_;
        }
        for (int iter = 0; iter < nIter; ++iter) {
            int i;
            this._pdm.calcShape2D(this.cshape_, this._plocal, this._pglobl);
            if (iter > 0 && this.l2norm(this.cshape_, this.oshape_) < fTol) break;
            this.oshape_.setMatrix(0, this.oshape_.getRowDimension() - 1, 0, this.oshape_.getColumnDimension() - 1, this.cshape_);
            if (rigid) {
                this._pdm.calcRigidJacob(this._plocal, this._pglobl, J);
            } else {
                this._pdm.calcJacob(this._plocal, this._pglobl, J);
            }
            for (i = 0; i < n; ++i) {
                if (this._visi[idx].getRowDimension() == n && this._visi[idx].get(i, 0) == 0.0) {
                    MatrixUtils.setRow((Matrix)J, (int)i, (double)0.0);
                    MatrixUtils.setRow((Matrix)J, (int)(i + n), (double)0.0);
                    this.ms_.set(i, 0, 0.0);
                    this.ms_.set(i + n, 0, 0.0);
                    continue;
                }
                double dx = this.cshape_.get(i, 0) - this.bshape_.get(i, 0) + (double)((wSize - 1) / 2);
                double dy = this.cshape_.get(i + n, 0) - this.bshape_.get(i + n, 0) + (double)((wSize - 1) / 2);
                double mx = 0.0;
                double my = 0.0;
                double sum = 0.0;
                for (int ii = 0; ii < wSize; ++ii) {
                    double vx = (dy - (double)ii) * (dy - (double)ii);
                    for (int jj = 0; jj < wSize; ++jj) {
                        double vy = (dx - (double)jj) * (dx - (double)jj);
                        double v = this.prob_[i].pixels[ii][jj];
                        sum += (v *= Math.exp(-0.5 * (vx + vy) / sigma));
                        mx += v * (double)jj;
                        my += v * (double)ii;
                    }
                }
                this.ms_.set(i, 0, mx / sum - dx);
                this.ms_.set(i + n, 0, my / sum - dy);
            }
            g = J.transpose().times(this.ms_);
            H = J.transpose().times(J);
            if (!rigid) {
                for (i = 0; i < m; ++i) {
                    double var = 0.5 * sigma / this._pdm._E.get(0, i);
                    double[] dArray = H.getArray()[6 + i];
                    int n2 = 6 + i;
                    dArray[n2] = dArray[n2] + var;
                    double[] dArray2 = g.getArray()[6 + i];
                    dArray2[0] = dArray2[0] - var * this._plocal.get(i, 0);
                }
            }
            MatrixUtils.fill((Matrix)this.u_, (double)0.0);
            u = H.solve(g);
            if (rigid) {
                this.u_.setMatrix(0, 5, 0, 0, u);
            } else {
                this.u_.setMatrix(0, u.getRowDimension() - 1, 0, u.getColumnDimension() - 1, u);
            }
            this._pdm.calcReferenceUpdate(this.u_, this._plocal, this._pglobl);
            if (rigid) continue;
            this._pdm.clamp(this._plocal, clamp);
        }
        if (rigid) {
            this.u_.setMatrix(0, 5, 0, 0, u);
            this.g_.setMatrix(0, 5, 0, 0, g);
            this.J_.setMatrix(0, 2 * n - 1, 0, 5, J);
            this.H_.setMatrix(0, 5, 0, 5, H);
        } else {
            this.u_.setMatrix(0, u.getRowDimension() - 1, 0, u.getColumnDimension() - 1, u);
            this.g_.setMatrix(0, g.getRowDimension() - 1, 0, g.getColumnDimension() - 1, g);
            this.J_.setMatrix(0, J.getRowDimension() - 1, 0, J.getColumnDimension() - 1, J);
            this.H_.setMatrix(0, H.getRowDimension() - 1, 0, H.getColumnDimension() - 1, H);
        }
    }

    private double l2norm(Matrix m1, Matrix m2) {
        double[][] m1v = m1.getArray();
        double[][] m2v = m2.getArray();
        int rows = m1.getRowDimension();
        int cols = m1.getColumnDimension();
        double sum = 0.0;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double diff = m1v[r][c] - m2v[r][c];
                sum += diff * diff;
            }
        }
        return Math.sqrt(sum);
    }

    static {
        Tracker.init();
    }

    class SimTData {
        double a;
        double b;
        double tx;
        double ty;

        SimTData() {
        }
    }
}

