/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.core;

import org.forgerock.opendj.server.core.AttachmentHolder;

public final class Attachment<T> {
    private final T defaultValue;
    private final String name;

    public Attachment(String name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public T get(AttachmentHolder attachmentHolder) {
        T value = this.get0(attachmentHolder);
        if (value == null) {
            value = this.defaultValue;
        }
        return value;
    }

    public T remove(AttachmentHolder attachmentHolder) {
        T value = this.get0(attachmentHolder);
        if (value != null) {
            this.set(attachmentHolder, null);
        }
        return value;
    }

    public T set(AttachmentHolder attachmentHolder, T value) {
        T oldValue = this.get0(attachmentHolder);
        attachmentHolder.setAttachment(this.name, value);
        return oldValue;
    }

    private T get0(AttachmentHolder attachmentHolder) {
        return (T)attachmentHolder.getAttachment(this.name);
    }
}

