/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.core;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.core.DataProvider;
import org.forgerock.opendj.server.core.DataProviderEvent;
import org.forgerock.opendj.server.core.DataProviderEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataProvider
implements DataProvider {
    private static final Logger debugLogger = LoggerFactory.getLogger(AbstractDataProvider.class);
    private final List<DataProviderEventListener> eventListeners = new CopyOnWriteArrayList<DataProviderEventListener>();

    protected AbstractDataProvider() {
    }

    @Override
    public boolean containsEntry(DN dn) throws LdapException {
        return this.getEntry(dn) != null;
    }

    @Override
    public final void deregisterEventListener(DataProviderEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public final void registerEventListener(DataProviderEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public boolean supportsChangeNotification(DN baseDN) throws LdapException {
        return false;
    }

    protected final void notifyDataProviderEventOccurred(DataProviderEvent event) {
        for (DataProviderEventListener listener : this.eventListeners) {
            try {
                listener.handleDataProviderEvent(event);
            }
            catch (Exception e) {
                debugLogger.trace("Unexpected error occurred while invoking listener", (Throwable)e);
            }
        }
    }

    protected final void notifyDataProviderEventOccurred(LocalizableMessage reason, Set<DataProviderEvent.Type> types) {
        DataProviderEvent event = new DataProviderEvent(reason, types);
        this.notifyDataProviderEventOccurred(event);
    }
}

