/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.HelpCallback;
import com.forgerock.opendj.cli.Menu;
import com.forgerock.opendj.cli.MenuCallback;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.TableBuilder;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TextTablePrinter;
import com.forgerock.opendj.cli.ValidationCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;

public final class MenuBuilder<T> {
    private int threshold = -1;
    private boolean allowMultiSelect;
    private final ConsoleApplication app;
    private final List<MenuCallback<T>> charCallbacks = new ArrayList<MenuCallback<T>>();
    private final List<LocalizableMessage> charKeys = new ArrayList<LocalizableMessage>();
    private final List<LocalizableMessage> charSynopsis = new ArrayList<LocalizableMessage>();
    private final List<LocalizableMessage> columnHeadings = new ArrayList<LocalizableMessage>();
    private final List<Integer> columnWidths = new ArrayList<Integer>();
    private MenuCallback<T> defaultCallback;
    private LocalizableMessage defaultDescription;
    private final List<MenuCallback<T>> numericCallbacks = new ArrayList<MenuCallback<T>>();
    private final List<List<LocalizableMessage>> numericFields = new ArrayList<List<LocalizableMessage>>();
    private LocalizableMessage title;
    private LocalizableMessage prompt;
    private int nMaxTries = -1;

    public MenuBuilder(ConsoleApplication app) {
        this.app = app;
    }

    public void addBackOption(boolean isDefault) {
        this.addCharOption(CliMessages.INFO_MENU_OPTION_BACK_KEY.get(), CliMessages.INFO_MENU_OPTION_BACK.get(), MenuResult.cancel());
        if (isDefault) {
            this.setDefault(CliMessages.INFO_MENU_OPTION_BACK_KEY.get(), MenuResult.cancel());
        }
    }

    public void addCancelOption(boolean isDefault) {
        this.addCharOption(CliMessages.INFO_MENU_OPTION_CANCEL_KEY.get(), CliMessages.INFO_MENU_OPTION_CANCEL.get(), MenuResult.cancel());
        if (isDefault) {
            this.setDefault(CliMessages.INFO_MENU_OPTION_CANCEL_KEY.get(), MenuResult.cancel());
        }
    }

    public void addCharOption(LocalizableMessage c, LocalizableMessage description, MenuCallback<T> callback) {
        this.charKeys.add(c);
        this.charSynopsis.add(description);
        this.charCallbacks.add(callback);
    }

    public void addCharOption(LocalizableMessage c, LocalizableMessage description, MenuResult<T> result) {
        this.addCharOption(c, description, new ResultCallback(result));
    }

    public void addHelpOption(final HelpCallback callback) {
        MenuCallback wrapper = new MenuCallback<T>(){

            @Override
            public MenuResult<T> invoke(ConsoleApplication app) throws ClientException {
                app.println();
                callback.display(app);
                return MenuResult.again();
            }
        };
        this.addCharOption(CliMessages.INFO_MENU_OPTION_HELP_KEY.get(), CliMessages.INFO_MENU_OPTION_HELP.get(), wrapper);
    }

    public int addNumberedOption(LocalizableMessage description, MenuCallback<T> callback, LocalizableMessage ... extraFields) {
        ArrayList<LocalizableMessage> fields = new ArrayList<LocalizableMessage>();
        fields.add(description);
        if (extraFields != null) {
            fields.addAll(Arrays.asList(extraFields));
        }
        this.numericFields.add(fields);
        this.numericCallbacks.add(callback);
        return this.numericCallbacks.size();
    }

    public int addNumberedOption(LocalizableMessage description, MenuResult<T> result, LocalizableMessage ... extraFields) {
        return this.addNumberedOption(description, new ResultCallback(result), extraFields);
    }

    public void addQuitOption() {
        this.addCharOption(CliMessages.INFO_MENU_OPTION_QUIT_KEY.get(), CliMessages.INFO_MENU_OPTION_QUIT.get(), MenuResult.quit());
    }

    public void setAllowMultiSelect(boolean allowMultiSelect) {
        this.allowMultiSelect = allowMultiSelect;
    }

    public void setColumnHeadings(LocalizableMessage ... headings) {
        this.columnHeadings.clear();
        if (headings != null) {
            this.columnHeadings.addAll(Arrays.asList(headings));
        }
    }

    public void setColumnWidths(Integer ... widths) {
        this.columnWidths.clear();
        if (widths != null) {
            this.columnWidths.addAll(Arrays.asList(widths));
        }
    }

    public void setDefault(LocalizableMessage description, MenuCallback<T> callback) {
        this.defaultCallback = callback;
        this.defaultDescription = description;
    }

    public void setDefault(LocalizableMessage description, MenuResult<T> result) {
        this.setDefault(description, new ResultCallback(result));
    }

    public void setMultipleColumnThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setPrompt(LocalizableMessage prompt) {
        this.prompt = prompt;
    }

    public void setTitle(LocalizableMessage title) {
        this.title = title;
    }

    public Menu<T> toMenu() {
        int sz;
        boolean useMultipleColumns;
        TableBuilder nbuilder = new TableBuilder();
        HashMap<String, MenuCallback<T>> callbacks = new HashMap<String, MenuCallback<T>>();
        boolean bl = useMultipleColumns = this.threshold >= 0 && this.numericCallbacks.size() >= this.threshold;
        if (!this.columnHeadings.isEmpty()) {
            this.appendHeadings(nbuilder);
            if (useMultipleColumns) {
                this.appendHeadings(nbuilder);
            }
        }
        int rows = sz = this.numericCallbacks.size();
        if (useMultipleColumns) {
            rows /= 2;
            rows += sz % 2;
        }
        int i = 0;
        int j = rows;
        while (i < rows) {
            nbuilder.startRow();
            this.appendCells(nbuilder, i);
            callbacks.put(String.valueOf(i + 1), this.numericCallbacks.get(i));
            if (useMultipleColumns && j < sz) {
                this.appendCells(nbuilder, j);
                callbacks.put(String.valueOf(j + 1), this.numericCallbacks.get(j));
            }
            ++i;
            ++j;
        }
        TableBuilder cbuilder = new TableBuilder();
        for (int i2 = 0; i2 < this.charCallbacks.size(); ++i2) {
            char c = this.charKeys.get(i2).charAt(0);
            LocalizableMessage option = CliMessages.INFO_MENU_CHAR_OPTION.get((Object)Character.valueOf(c));
            cbuilder.startRow();
            cbuilder.appendCell(option);
            cbuilder.appendCell(this.charSynopsis.get(i2));
            callbacks.put(String.valueOf(c), this.charCallbacks.get(i2));
        }
        TextTablePrinter printer = new TextTablePrinter(this.app.getErrorStream());
        boolean hasHeadings = !this.columnHeadings.isEmpty();
        printer.setDisplayHeadings(hasHeadings);
        if (hasHeadings) {
            printer.setHeadingSeparatorStartColumn(1);
        }
        printer.setIndentWidth(4);
        if (this.columnWidths.isEmpty()) {
            printer.setColumnWidth(1, 0);
            if (useMultipleColumns) {
                printer.setColumnWidth(3, 0);
            }
        } else {
            for (int i3 = 0; i3 < this.columnWidths.size(); ++i3) {
                Integer j2 = this.columnWidths.get(i3);
                if (j2 == null) continue;
                printer.setColumnWidth(i3 + 1, j2);
                if (!useMultipleColumns) continue;
                printer.setColumnWidth(i3 + 2 + this.columnWidths.size(), j2);
            }
        }
        return new MenuImpl(this.app, this.title, this.prompt, nbuilder, cbuilder, printer, callbacks, this.allowMultiSelect, this.defaultCallback, this.defaultDescription, this.nMaxTries);
    }

    private void appendCells(TableBuilder nbuilder, int i) {
        nbuilder.appendCell(CliMessages.INFO_MENU_NUMERIC_OPTION.get((Object)(i + 1)));
        for (LocalizableMessage field : this.numericFields.get(i)) {
            if (field != null) {
                nbuilder.appendCell(field);
                continue;
            }
            nbuilder.appendCell();
        }
    }

    private void appendHeadings(TableBuilder nbuilder) {
        nbuilder.appendHeading();
        for (LocalizableMessage heading : this.columnHeadings) {
            if (heading != null) {
                nbuilder.appendHeading(heading);
                continue;
            }
            nbuilder.appendHeading();
        }
    }

    public void setMaxTries(int nTries) {
        this.nMaxTries = nTries;
    }

    private static final class ResultCallback<T>
    implements MenuCallback<T> {
        private final MenuResult<T> result;

        private ResultCallback(MenuResult<T> result) {
            this.result = result;
        }

        @Override
        public MenuResult<T> invoke(ConsoleApplication app) throws ClientException {
            return this.result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(result=" + this.result + ")";
        }
    }

    private static final class MenuImpl<T>
    implements Menu<T> {
        private final boolean allowMultiSelect;
        private final ConsoleApplication app;
        private final Map<String, MenuCallback<T>> callbacks;
        private final TableBuilder cbuilder;
        private final MenuCallback<T> defaultCallback;
        private final LocalizableMessage defaultDescription;
        private final TableBuilder nbuilder;
        private final TablePrinter printer;
        private final LocalizableMessage prompt;
        private final LocalizableMessage title;
        private int nMaxTries;

        private MenuImpl(ConsoleApplication app, LocalizableMessage title, LocalizableMessage prompt, TableBuilder ntable, TableBuilder ctable, TablePrinter printer, Map<String, MenuCallback<T>> callbacks, boolean allowMultiSelect, MenuCallback<T> defaultCallback, LocalizableMessage defaultDescription, int nMaxTries) {
            this.app = app;
            this.title = title;
            this.prompt = prompt;
            this.nbuilder = ntable;
            this.cbuilder = ctable;
            this.printer = printer;
            this.callbacks = callbacks;
            this.allowMultiSelect = allowMultiSelect;
            this.defaultCallback = defaultCallback;
            this.defaultDescription = defaultDescription;
            this.nMaxTries = nMaxTries;
        }

        @Override
        public MenuResult<T> run() throws ClientException {
            ValidationCallback validator = new ValidationCallback<MenuCallback<T>>(){

                @Override
                public MenuCallback<T> validate(ConsoleApplication app, String input) {
                    String ninput = input.trim();
                    if (ninput.length() == 0) {
                        if (defaultCallback != null) {
                            return defaultCallback;
                        }
                        if (allowMultiSelect) {
                            app.println();
                            app.println(CliMessages.ERR_MENU_BAD_CHOICE_MULTI.get());
                            app.println();
                            return null;
                        }
                        app.println();
                        app.println(CliMessages.ERR_MENU_BAD_CHOICE_SINGLE.get());
                        app.println();
                        return null;
                    }
                    if (allowMultiSelect) {
                        ArrayList cl = new ArrayList();
                        String[] stringArray = ninput.split(",");
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            HashSet<String> choices = new HashSet<String>();
                            String value = stringArray[i];
                            String nvalue = value.trim();
                            if (choices.contains(nvalue)) {
                                app.println();
                                app.println(CliMessages.ERR_MENU_BAD_CHOICE_MULTI_DUPE.get((Object)value));
                                app.println();
                                return null;
                            }
                            if (!callbacks.containsKey(nvalue)) {
                                app.println();
                                app.println(CliMessages.ERR_MENU_BAD_CHOICE_MULTI.get());
                                app.println();
                                return null;
                            }
                            cl.add(callbacks.get(nvalue));
                            choices.add(nvalue);
                        }
                        return new CompositeCallback(cl);
                    }
                    if (!callbacks.containsKey(ninput)) {
                        app.println();
                        app.println(CliMessages.ERR_MENU_BAD_CHOICE_SINGLE.get());
                        app.println();
                        return null;
                    }
                    return (MenuCallback)callbacks.get(ninput);
                }
            };
            LocalizableMessage promptMsg = this.allowMultiSelect ? (this.defaultDescription != null ? CliMessages.INFO_MENU_PROMPT_MULTI_DEFAULT.get((Object)this.defaultDescription) : CliMessages.INFO_MENU_PROMPT_MULTI.get()) : (this.defaultDescription != null ? CliMessages.INFO_MENU_PROMPT_SINGLE_DEFAULT.get((Object)this.defaultDescription) : CliMessages.INFO_MENU_PROMPT_SINGLE.get());
            while (true) {
                MenuCallback choice;
                MenuResult result;
                if (this.title != null) {
                    this.app.println(this.title);
                    this.app.println();
                }
                if (this.prompt != null) {
                    this.app.println(this.prompt);
                    this.app.println();
                }
                if (this.nbuilder.getTableHeight() > 0) {
                    this.nbuilder.print(this.printer);
                    this.app.println();
                }
                if (this.cbuilder.getTableHeight() > 0) {
                    TextTablePrinter cprinter = new TextTablePrinter(this.app.getErrorStream());
                    cprinter.setDisplayHeadings(false);
                    int sz = String.valueOf(this.nbuilder.getTableHeight()).length() + 1;
                    cprinter.setIndentWidth(4);
                    cprinter.setColumnWidth(0, sz);
                    cprinter.setColumnWidth(1, 0);
                    this.cbuilder.print(cprinter);
                    this.app.println();
                }
                if (!(result = (choice = this.nMaxTries != -1 ? (MenuCallback)this.app.readValidatedInput(promptMsg, validator, this.nMaxTries) : (MenuCallback)this.app.readValidatedInput(promptMsg, validator)).invoke(this.app)).isAgain()) {
                    return result;
                }
                this.app.println();
                this.app.println();
            }
        }
    }

    private static final class CompositeCallback<T>
    implements MenuCallback<T> {
        private final Collection<MenuCallback<T>> callbacks;

        public CompositeCallback(Collection<MenuCallback<T>> callbacks) {
            this.callbacks = callbacks;
        }

        @Override
        public MenuResult<T> invoke(ConsoleApplication app) throws ClientException {
            ArrayList<T> values = new ArrayList<T>();
            for (MenuCallback<T> callback : this.callbacks) {
                MenuResult<T> result = callback.invoke(app);
                if (!result.isSuccess()) {
                    return result;
                }
                values.addAll(result.getValues());
            }
            return MenuResult.success(values);
        }
    }
}

