/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ApplicationKeyManager;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.PromptingTrustManager;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.util.StaticUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.KeyManagers;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.PasswordPolicyRequestControl;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.util.Options;
import org.forgerock.util.time.Duration;

public final class ConnectionFactoryProvider {
    static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private StringArgument hostNameArg;
    private IntegerArgument portArg;
    private StringArgument bindNameArg;
    private FileBasedArgument bindPasswordFileArg;
    private char[] password;
    private StringArgument bindPasswordArg;
    private IntegerArgument connectTimeOut;
    private BooleanArgument trustAllArg;
    private StringArgument trustStorePathArg;
    private StringArgument trustStorePasswordArg;
    private FileBasedArgument trustStorePasswordFileArg;
    private StringArgument keyStorePathArg;
    private StringArgument keyStorePasswordArg;
    private FileBasedArgument keyStorePasswordFileArg;
    private StringArgument certNicknameArg;
    private BooleanArgument useSSLArg;
    private BooleanArgument useStartTLSArg;
    private StringArgument saslOptionArg;
    private final BooleanArgument reportAuthzIDArg;
    private final BooleanArgument usePasswordPolicyControlArg;
    private SSLContext sslContext;
    private ConnectionFactory connFactory;
    private BindRequest bindRequest;
    private final ConsoleApplication app;
    private boolean isAdminConnection;

    public ConnectionFactoryProvider(ArgumentParser argumentParser, ConsoleApplication app) throws ArgumentException {
        this(argumentParser, app, "", 389, false);
    }

    public ConnectionFactoryProvider(ArgumentParser argumentParser, ConsoleApplication app, String defaultBindDN, int defaultPort, boolean alwaysSSL) throws ArgumentException {
        this.app = app;
        this.useSSLArg = CommonArguments.useSSLArgument();
        if (!alwaysSSL) {
            argumentParser.addLdapConnectionArgument(this.useSSLArg);
        } else {
            this.useSSLArg.setPresent(true);
        }
        this.useStartTLSArg = CommonArguments.startTLSArgument();
        if (!alwaysSSL) {
            argumentParser.addLdapConnectionArgument(this.useStartTLSArg);
        }
        String defaultHostName = "localhost";
        this.hostNameArg = CommonArguments.hostNameArgument(defaultHostName);
        argumentParser.addLdapConnectionArgument(this.hostNameArg);
        LocalizableMessage portDescription = CliMessages.INFO_DESCRIPTION_PORT.get();
        if (alwaysSSL) {
            portDescription = CliMessages.INFO_DESCRIPTION_ADMIN_PORT.get();
        }
        this.portArg = CommonArguments.portArgument(defaultPort, portDescription);
        argumentParser.addLdapConnectionArgument(this.portArg);
        this.bindNameArg = CommonArguments.bindDNArgument(defaultBindDN);
        argumentParser.addLdapConnectionArgument(this.bindNameArg);
        this.bindPasswordArg = CommonArguments.bindPasswordArgument();
        argumentParser.addLdapConnectionArgument(this.bindPasswordArg);
        this.bindPasswordFileArg = CommonArguments.bindPasswordFileArgument();
        argumentParser.addLdapConnectionArgument(this.bindPasswordFileArg);
        this.saslOptionArg = CommonArguments.saslArgument();
        argumentParser.addLdapConnectionArgument(this.saslOptionArg);
        this.trustAllArg = CommonArguments.trustAllArgument();
        argumentParser.addLdapConnectionArgument(this.trustAllArg);
        this.trustStorePathArg = CommonArguments.trustStorePathArgument();
        argumentParser.addLdapConnectionArgument(this.trustStorePathArg);
        this.trustStorePasswordArg = CommonArguments.trustStorePasswordArgument();
        argumentParser.addLdapConnectionArgument(this.trustStorePasswordArg);
        this.trustStorePasswordFileArg = CommonArguments.trustStorePasswordFileArgument();
        argumentParser.addLdapConnectionArgument(this.trustStorePasswordFileArg);
        this.keyStorePathArg = CommonArguments.keyStorePathArgument();
        argumentParser.addLdapConnectionArgument(this.keyStorePathArg);
        this.keyStorePasswordArg = CommonArguments.keyStorePasswordArgument();
        argumentParser.addLdapConnectionArgument(this.keyStorePasswordArg);
        this.keyStorePasswordFileArg = CommonArguments.keyStorePasswordFileArgument();
        argumentParser.addLdapConnectionArgument(this.keyStorePasswordFileArg);
        this.certNicknameArg = CommonArguments.certNickNameArgument();
        argumentParser.addLdapConnectionArgument(this.certNicknameArg);
        this.reportAuthzIDArg = CommonArguments.reportAuthzIdArgument();
        argumentParser.addArgument(this.reportAuthzIDArg);
        this.connectTimeOut = CommonArguments.connectTimeOutArgument();
        argumentParser.addArgument(this.connectTimeOut);
        this.usePasswordPolicyControlArg = (BooleanArgument)((BooleanArgument.Builder)BooleanArgument.builder("usePasswordPolicyControl").description(CliMessages.INFO_DESCRIPTION_USE_PWP_CONTROL.get())).buildAndAddToParser(argumentParser);
    }

    public int getConnectTimeout() {
        if (this.connectTimeOut.isPresent()) {
            try {
                return this.connectTimeOut.getIntValue();
            }
            catch (ArgumentException e) {
                return Integer.valueOf(this.connectTimeOut.getDefaultValue());
            }
        }
        return Integer.valueOf(this.connectTimeOut.getDefaultValue());
    }

    public String getHostname() throws ArgumentException {
        String value = "";
        if (this.hostNameArg.isPresent()) {
            value = this.hostNameArg.getValue();
        } else if (this.app.isInteractive()) {
            try {
                value = this.app.readInput(CliMessages.INFO_DESCRIPTION_HOST.get(), this.getHostNameDefaultValue(value));
                this.app.println();
                this.hostNameArg.addValue(value);
                this.hostNameArg.setPresent(true);
            }
            catch (ClientException e) {
                throw new ArgumentException(CliMessages.ERR_ERROR_CANNOT_READ_HOST_NAME.get(), (Throwable)e);
            }
        } else {
            return this.getHostNameDefaultValue(value);
        }
        return Utils.getHostNameForLdapUrl(value);
    }

    private String getHostNameDefaultValue(String fallbackValue) {
        return this.hostNameArg.getDefaultValue() != null ? this.hostNameArg.getDefaultValue() : fallbackValue;
    }

    public int getPort() {
        if (this.portArg.isPresent()) {
            try {
                return this.portArg.getIntValue();
            }
            catch (ArgumentException e) {
                return Integer.valueOf(this.portArg.getDefaultValue());
            }
        }
        if (this.app.isInteractive()) {
            LocalizableMessage portMsg = this.isAdminConnection ? CliMessages.INFO_DESCRIPTION_ADMIN_PORT.get() : CliMessages.INFO_DESCRIPTION_PORT.get();
            int value = this.app.askPort(portMsg, Integer.valueOf(this.portArg.getDefaultValue()), logger);
            this.app.println();
            this.portArg.addValue(Integer.toString(value));
            this.portArg.setPresent(true);
            return value;
        }
        return Integer.valueOf(this.portArg.getDefaultValue());
    }

    public boolean useSSL() {
        return this.useSSLArg.isPresent();
    }

    public boolean useStartTLS() {
        return this.useStartTLSArg.isPresent();
    }

    public static List<String> getDefaultProtocols() throws NoSuchAlgorithmException {
        return ConnectionFactoryProvider.getDefaultProtocols(SSLContext.getDefault());
    }

    public static List<String> getDefaultProtocols(SSLContext sslContext) throws NoSuchAlgorithmException {
        List<String> enabled = Arrays.asList(sslContext.createSSLEngine().getEnabledProtocols());
        String property = System.getProperty("org.opends.ldaps.protocols");
        ArrayList<String> defaults = new ArrayList<String>();
        if (property != null && property.length() != 0) {
            for (String protocol : property.split(",")) {
                if (!enabled.contains(protocol)) continue;
                defaults.add(protocol);
            }
            return defaults;
        }
        for (String protocol : enabled) {
            if (protocol.startsWith("SSL")) continue;
            defaults.add(protocol);
        }
        return defaults;
    }

    public ConnectionFactory getAuthenticatedConnectionFactory() throws ArgumentException {
        return this.getConnectionFactory(true);
    }

    public ConnectionFactory getUnauthenticatedConnectionFactory() throws ArgumentException {
        return this.getConnectionFactory(false);
    }

    private ConnectionFactory getConnectionFactory(boolean usePreAuthentication) throws ArgumentException {
        if (this.connFactory == null) {
            this.checkForConflictingArguments();
            if (this.app.isInteractive()) {
                boolean bindPwdIsMissing;
                boolean portIsMissing = !this.portArg.isPresent() || this.portArg.getIntValue() == 0;
                boolean bl = bindPwdIsMissing = !this.bindPasswordArg.isPresent() && !this.bindPasswordFileArg.isPresent();
                if (!this.hostNameArg.isPresent() || portIsMissing || !this.bindNameArg.isPresent() || bindPwdIsMissing) {
                    this.app.printHeader(CliMessages.INFO_LDAP_CONN_HEADING_CONNECTION_PARAMETERS.get());
                }
                if (!this.hostNameArg.isPresent()) {
                    this.getHostname();
                }
                if (portIsMissing) {
                    this.getPort();
                }
                if (!this.bindNameArg.isPresent()) {
                    this.getBindName();
                }
                if (bindPwdIsMissing) {
                    this.getPassword();
                }
            }
            try {
                if (this.useSSLArg.isPresent() || this.useStartTLSArg.isPresent()) {
                    String clientAlias = this.certNicknameArg.isPresent() ? this.certNicknameArg.getValue() : null;
                    if (this.sslContext == null) {
                        TrustManager trustManager = this.getTrustManager();
                        X509KeyManager keyManager = null;
                        X509KeyManager akm = this.getKeyManager(this.keyStorePathArg.getValue());
                        keyManager = akm != null && clientAlias != null ? KeyManagers.useSingleCertificate((String)clientAlias, (X509KeyManager)akm) : akm;
                        this.sslContext = new SSLContextBuilder().setTrustManager(trustManager).setKeyManager((KeyManager)keyManager).getSSLContext();
                    }
                }
            }
            catch (Exception e) {
                throw new ArgumentException(CliMessages.ERR_LDAP_CONN_CANNOT_INITIALIZE_SSL.get((Object)e.toString()), (Throwable)e);
            }
            Options options = Options.defaultOptions();
            if (this.sslContext != null) {
                try {
                    options.set(LDAPConnectionFactory.SSL_CONTEXT, (Object)this.sslContext).set(LDAPConnectionFactory.SSL_USE_STARTTLS, (Object)this.useStartTLSArg.isPresent()).set(LDAPConnectionFactory.SSL_ENABLED_PROTOCOLS, ConnectionFactoryProvider.getDefaultProtocols(this.sslContext));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ArgumentException(CliMessages.ERR_LDAP_CONN_CANNOT_INITIALIZE_SSL.get((Object)e.toString()), (Throwable)e);
                }
            }
            options.set(LDAPConnectionFactory.CONNECT_TIMEOUT, (Object)Duration.duration((long)this.getConnectTimeout(), (TimeUnit)TimeUnit.MILLISECONDS));
            if (usePreAuthentication) {
                options.set(LDAPConnectionFactory.AUTHN_BIND_REQUEST, (Object)this.getBindRequest());
            }
            this.connFactory = new LDAPConnectionFactory(this.hostNameArg.getValue(), this.portArg.getIntValue(), options);
        }
        return this.connFactory;
    }

    private void checkForConflictingArguments() throws ArgumentException {
        String value;
        Utils.throwIfArgumentsConflict(this.bindPasswordArg, this.bindPasswordFileArg);
        Utils.throwIfArgumentsConflict(this.trustAllArg, this.trustStorePathArg);
        Utils.throwIfArgumentsConflict(this.trustAllArg, this.trustStorePasswordArg);
        Utils.throwIfArgumentsConflict(this.trustAllArg, this.trustStorePasswordFileArg);
        Utils.throwIfArgumentsConflict(this.trustStorePasswordArg, this.trustStorePasswordFileArg);
        Utils.throwIfArgumentsConflict(this.useStartTLSArg, this.useSSLArg);
        if (this.trustStorePathArg.isPresent() && !this.canReadPath(value = this.trustStorePathArg.getValue())) {
            LocalizableMessage message = CliMessages.ERR_CANNOT_READ_TRUSTSTORE.get((Object)value);
            throw new ArgumentException(message);
        }
        if (this.keyStorePathArg.isPresent() && !this.canReadPath(value = this.keyStorePathArg.getValue())) {
            LocalizableMessage message = CliMessages.ERR_CANNOT_READ_KEYSTORE.get((Object)value);
            throw new ArgumentException(message);
        }
    }

    private boolean canReadPath(String path) {
        File file = new File(path);
        return file.exists() && file.canRead();
    }

    private String getAuthID(String mech) throws ArgumentException {
        String value = this.getAuthID();
        if (value == null && this.bindNameArg.isPresent()) {
            value = "dn: " + this.bindNameArg.getValue();
        }
        if (value == null && this.app.isInteractive()) {
            try {
                value = this.app.readInput(LocalizableMessage.raw((CharSequence)"Authentication ID:", (Object[])new Object[0]), this.bindNameArg.getDefaultValue() == null ? null : "dn: " + this.bindNameArg.getDefaultValue());
            }
            catch (ClientException e) {
                throw new ArgumentException(LocalizableMessage.raw((CharSequence)"Unable to read authentication ID", (Object[])new Object[0]), (Throwable)e);
            }
        }
        if (value == null) {
            throw new ArgumentException(CliMessages.ERR_LDAPAUTH_SASL_AUTHID_REQUIRED.get((Object)mech));
        }
        return value;
    }

    private String getAuthID() throws ArgumentException {
        return this.getSaslProperty("authid");
    }

    private String getAuthzID() throws ArgumentException {
        return this.getSaslProperty("authzid");
    }

    public String getBindName() throws ArgumentException {
        String value = "";
        if (this.bindNameArg.isPresent()) {
            value = this.bindNameArg.getValue();
        } else if (this.app.isInteractive()) {
            LocalizableMessage bindMsg = this.isAdminConnection ? CliMessages.INFO_DESCRIPTION_ADMIN_BINDDN.get() : CliMessages.INFO_DESCRIPTION_BINDDN.get();
            try {
                value = this.app.readInput(bindMsg, this.bindNameArg.getDefaultValue() == null ? value : this.bindNameArg.getDefaultValue());
                this.app.println();
                this.bindNameArg.clearValues();
                this.bindNameArg.addValue(value);
                this.bindNameArg.setPresent(true);
            }
            catch (ClientException e) {
                throw new ArgumentException(CliMessages.ERR_ERROR_CANNOT_READ_BIND_NAME.get(), (Throwable)e);
            }
        }
        return value;
    }

    public BindRequest getBindRequest() throws ArgumentException {
        if (this.bindRequest == null) {
            String mech = this.getMechanism();
            if (mech == null) {
                if (this.bindNameArg.isPresent() || this.bindPasswordFileArg.isPresent() || this.bindPasswordArg.isPresent()) {
                    this.bindRequest = Requests.newSimpleBindRequest((String)this.getBindName(), (char[])this.getPassword());
                }
            } else if ("DIGEST-MD5".equals(mech)) {
                this.bindRequest = Requests.newDigestMD5SASLBindRequest((String)this.getAuthID("DIGEST-MD5"), (char[])this.getPassword()).setAuthorizationID(this.getAuthzID()).setRealm(this.getRealm());
            } else if ("CRAM-MD5".equals(mech)) {
                this.bindRequest = Requests.newCRAMMD5SASLBindRequest((String)this.getAuthID("CRAM-MD5"), (char[])this.getPassword());
            } else if ("GSSAPI".equals(mech)) {
                this.bindRequest = Requests.newGSSAPISASLBindRequest((String)this.getAuthID("GSSAPI"), (char[])this.getPassword()).setKDCAddress(this.getKDC()).setRealm(this.getRealm()).setAuthorizationID(this.getAuthzID());
            } else if ("EXTERNAL".equals(mech)) {
                if (this.sslContext == null) {
                    LocalizableMessage message = CliMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_SSL_OR_TLS.get();
                    throw new ArgumentException(message);
                }
                if (!this.keyStorePathArg.isPresent() && this.getKeyStore() == null) {
                    LocalizableMessage message = CliMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_KEYSTORE.get();
                    throw new ArgumentException(message);
                }
                this.bindRequest = Requests.newExternalSASLBindRequest().setAuthorizationID(this.getAuthzID());
            } else if ("PLAIN".equals(mech)) {
                this.bindRequest = Requests.newPlainSASLBindRequest((String)this.getAuthID("PLAIN"), (char[])this.getPassword()).setAuthorizationID(this.getAuthzID());
            } else {
                throw new ArgumentException(CliMessages.ERR_LDAPAUTH_UNSUPPORTED_SASL_MECHANISM.get((Object)mech));
            }
            if (this.bindRequest != null && this.reportAuthzIDArg.isPresent()) {
                this.bindRequest.addControl((Control)AuthorizationIdentityRequestControl.newControl((boolean)false));
            }
            if (this.bindRequest != null && this.usePasswordPolicyControlArg.isPresent()) {
                this.bindRequest.addControl((Control)PasswordPolicyRequestControl.newControl((boolean)false));
            }
        }
        return this.bindRequest;
    }

    private String getMechanism() throws ArgumentException {
        return this.getSaslProperty("mech");
    }

    private String getKDC() throws ArgumentException {
        return this.getSaslProperty("kdc");
    }

    private String getRealm() throws ArgumentException {
        return this.getSaslProperty("realm");
    }

    private String getSaslProperty(String propertyName) throws ArgumentException {
        for (String s : this.saslOptionArg.getValues()) {
            if (!s.startsWith(propertyName)) continue;
            return this.parseSASLOptionValue(s);
        }
        return null;
    }

    public String toString() {
        return this.connFactory.toString();
    }

    public X509KeyManager getKeyManager(String keyStoreFile) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (keyStoreFile == null) {
            keyStoreFile = this.getKeyStore();
        }
        if (keyStoreFile == null) {
            return null;
        }
        String keyStorePass = this.getKeyStorePIN();
        char[] keyStorePIN = null;
        if (keyStorePass != null) {
            keyStorePIN = keyStorePass.toCharArray();
        }
        boolean isFips = StaticUtils.isFips();
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keystore = KeyStore.getInstance(keyStoreType);
        if (isFips) {
            keystore.load(null, keyStorePIN);
        } else {
            try (FileInputStream fos = new FileInputStream(keyStoreFile);){
                keystore.load(fos, keyStorePIN);
            }
        }
        if (isFips) {
            String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            keyManagerFactory.init(keystore, keyStorePIN);
            for (KeyManager km : keyManagerFactory.getKeyManagers()) {
                if (!(km instanceof X509KeyManager)) continue;
                return (X509KeyManager)km;
            }
        }
        return new ApplicationKeyManager(keystore, keyStorePIN);
    }

    private String getKeyStore() {
        return System.getProperty("javax.net.ssl.keyStore");
    }

    private String getKeyStorePIN() {
        String pwd = this.keyStorePasswordArg.isPresent() ? this.keyStorePasswordArg.getValue() : (this.keyStorePasswordFileArg.isPresent() ? this.keyStorePasswordFileArg.getValue() : System.getProperty("javax.net.ssl.keyStorePassword"));
        return pwd;
    }

    public char[] getPassword() throws ArgumentException {
        char[] value = "".toCharArray();
        if (this.bindPasswordArg.isPresent()) {
            value = this.bindPasswordArg.getValue().toCharArray();
        } else if (this.bindPasswordFileArg.isPresent()) {
            value = this.bindPasswordFileArg.getValue().toCharArray();
        } else if (this.password != null) {
            return this.password;
        }
        if (value.length == 0 && this.app.isInteractive()) {
            LocalizableMessage msg = this.isAdminConnection ? CliMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get((Object)this.getBindName()) : CliMessages.INFO_DESCRIPTION_BINDPASSWORD.get();
            try {
                value = this.app.readPassword(msg);
                this.app.println();
            }
            catch (ClientException e) {
                throw new ArgumentException(CliMessages.ERR_ERROR_CANNOT_READ_PASSWORD.get(), (Throwable)e);
            }
            this.password = value;
        }
        return value;
    }

    public TrustManager getTrustManager() throws IOException, GeneralSecurityException {
        if (this.trustAllArg.isPresent()) {
            return TrustManagers.trustAll();
        }
        boolean isFips = StaticUtils.isFips();
        X509TrustManager tm = null;
        if (this.trustStorePathArg.isPresent() && this.trustStorePathArg.getValue().length() > 0) {
            tm = isFips ? TrustManagers.checkUsingTrustStore((String)this.trustStorePathArg.getValue(), (char[])this.getTrustStorePIN(), null) : TrustManagers.checkValidityDates((X509TrustManager)TrustManagers.checkHostName((String)this.hostNameArg.getValue(), (X509TrustManager)TrustManagers.checkUsingTrustStore((String)this.trustStorePathArg.getValue(), (char[])this.getTrustStorePIN(), null)));
        } else if (this.getTrustStore() != null) {
            tm = isFips ? TrustManagers.checkUsingTrustStore((String)this.getTrustStore(), (char[])this.getTrustStorePIN(), null) : TrustManagers.checkValidityDates((X509TrustManager)TrustManagers.checkHostName((String)this.hostNameArg.getValue(), (X509TrustManager)TrustManagers.checkUsingTrustStore((String)this.getTrustStore(), (char[])this.getTrustStorePIN(), null)));
        }
        if (this.app != null && !this.app.isQuiet() && !isFips) {
            return new PromptingTrustManager(this.app, tm);
        }
        if (isFips) {
            return TrustManagers.checkUsingPkcs11TrustStore();
        }
        return tm;
    }

    private String getTrustStore() {
        return System.getProperty("javax.net.ssl.trustStore");
    }

    private char[] getTrustStorePIN() {
        String pwd = this.trustStorePasswordArg.isPresent() ? this.trustStorePasswordArg.getValue() : (this.trustStorePasswordFileArg.isPresent() ? this.trustStorePasswordFileArg.getValue() : System.getProperty("javax.net.ssl.trustStorePassword"));
        return pwd == null ? null : pwd.toCharArray();
    }

    private String parseSASLOptionValue(String option) throws ArgumentException {
        int equalPos = option.indexOf(61);
        if (equalPos == -1) {
            throw new ArgumentException(CliMessages.ERR_LDAP_CONN_CANNOT_PARSE_SASL_OPTION.get((Object)option));
        }
        return option.substring(equalPos + 1, option.length());
    }

    public void setIsAnAdminConnection() {
        this.isAdminConnection = true;
    }
}

