/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentGroup;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.DocDescriptionSupplement;
import com.forgerock.opendj.cli.DocGenerationHelper;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolRefDocContainer;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.cli.VersionHandler;
import com.forgerock.opendj.util.StaticUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;

public class ArgumentParser
implements ToolRefDocContainer {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final Set<String> HOST_LONG_IDENTIFIERS = new HashSet<String>(Arrays.asList("hostname", "referencedHostName", "host1", "host2", "hostSource", "hostDestination"));
    public static final String DEFAULT_OPENDJ_CONFIG_DIR = ".opendj";
    public static final String DEFAULT_OPENDJ_PROPERTIES_FILE_NAME = "tools";
    public static final String DEFAULT_OPENDJ_PROPERTIES_FILE_EXTENSION = ".properties";
    public static final String PROPERTY_SCRIPT_NAME = "com.forgerock.opendj.ldap.tools.scriptName";
    public static final String PROPERTY_SCRIPT_NAME_LEGACY = "org.opends.server.scriptName";
    private StringArgument filePropertiesPathArgument;
    private BooleanArgument noPropertiesFileArgument;
    private Argument usageArgument;
    private Argument versionArgument;
    private final ArrayList<String> trailingArguments = new ArrayList();
    private final boolean allowsTrailingArguments;
    private final boolean longArgumentsCaseSensitive;
    private boolean usageOrVersionDisplayed;
    private boolean versionPresent;
    private VersionHandler versionHandler = new VersionHandler(){

        @Override
        public void printVersion() {
        }

        public String toString() {
            return "<no version displayed>";
        }
    };
    private final Map<Character, Argument> shortIDMap = new HashMap<Character, Argument>();
    private final Map<String, Argument> longIDMap = new HashMap<String, Argument>();
    private final List<Argument> argumentList = new LinkedList<Argument>();
    private final int maxTrailingArguments;
    private final int minTrailingArguments;
    private OutputStream usageOutputStream = System.out;
    private final String mainClassName;
    private final LocalizableMessage toolDescription;
    private LocalizableMessage shortToolDescription;
    private final String trailingArgsDisplayName;
    protected final Set<ArgumentGroup> argumentGroups = new TreeSet<ArgumentGroup>();
    private final ArgumentGroup defaultArgGroup = new ArgumentGroup(LocalizableMessage.EMPTY, Integer.MAX_VALUE);
    final ArgumentGroup ldapArgGroup = new ArgumentGroup(CliMessages.INFO_DESCRIPTION_LDAP_CONNECTION_ARGS.get(), -2147483646);
    protected final ArgumentGroup ioArgGroup = new ArgumentGroup(CliMessages.INFO_DESCRIPTION_IO_ARGS.get(), -2147483647);
    private final ArgumentGroup generalArgGroup = new ArgumentGroup(CliMessages.INFO_DESCRIPTION_GENERAL_ARGS.get(), Integer.MIN_VALUE);
    private static final String INDENT = "    ";
    private DocSubcommandDescriptionSupplement docToolDescriptionSupplement;
    private DocSubcommandDescriptionSupplement docSubcommandsDescriptionSupplement;

    public ArgumentParser(String mainClassName, LocalizableMessage toolDescription, boolean longArgumentsCaseSensitive) {
        this(mainClassName, toolDescription, longArgumentsCaseSensitive, false, 0, 0, null);
    }

    public ArgumentParser(String mainClassName, LocalizableMessage toolDescription, boolean longArgumentsCaseSensitive, boolean allowsTrailingArguments, int minTrailingArguments, int maxTrailingArguments, String trailingArgsDisplayName) {
        this.mainClassName = mainClassName;
        this.toolDescription = toolDescription;
        this.longArgumentsCaseSensitive = longArgumentsCaseSensitive;
        this.allowsTrailingArguments = allowsTrailingArguments;
        this.minTrailingArguments = minTrailingArguments;
        this.maxTrailingArguments = maxTrailingArguments;
        this.trailingArgsDisplayName = trailingArgsDisplayName;
        this.initGroups();
    }

    public void addArgument(Argument argument) throws ArgumentException {
        this.addArgument(argument, null);
    }

    public void addArgument(Argument argument, ArgumentGroup group) throws ArgumentException {
        String longID;
        Character shortID = argument.getShortIdentifier();
        if (shortID != null && this.shortIDMap.containsKey(shortID)) {
            String conflictingID = this.shortIDMap.get(shortID).getLongIdentifier();
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_DUPLICATE_SHORT_ID.get((Object)argument.getLongIdentifier(), (Object)shortID, (Object)conflictingID));
        }
        if (this.versionArgument != null && shortID != null && shortID.equals(this.versionArgument.getShortIdentifier())) {
            try {
                this.versionArgument = this.getVersionArgument(false);
                this.generalArgGroup.addArgument(this.versionArgument);
            }
            catch (ArgumentException conflictingID) {
                // empty catch block
            }
        }
        if (this.longIDMap.containsKey(longID = this.formatLongIdentifier(argument.getLongIdentifier()))) {
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_DUPLICATE_LONG_ID.get((Object)argument.getLongIdentifier()));
        }
        if (shortID != null) {
            this.shortIDMap.put(shortID, argument);
        }
        if (longID != null) {
            this.longIDMap.put(longID, argument);
        }
        this.argumentList.add(argument);
        if (group == null) {
            group = this.getStandardGroup(argument);
        }
        group.addArgument(argument);
        this.argumentGroups.add(group);
    }

    private BooleanArgument getVersionArgument(boolean displayShortIdentifier) throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("version").shortIdentifier(displayShortIdentifier ? Character.valueOf('V') : null)).description(CliMessages.INFO_DESCRIPTION_PRODUCT_VERSION.get())).buildArgument();
    }

    protected void addDefaultArgument(Argument argument) throws ArgumentException {
        this.addArgument(argument, this.defaultArgGroup);
    }

    public void addLdapConnectionArgument(Argument argument) throws ArgumentException {
        this.addArgument(argument, this.ldapArgGroup);
    }

    boolean allowsTrailingArguments() {
        return this.allowsTrailingArguments;
    }

    Properties checkExternalProperties() throws ArgumentException {
        String propertiesFilePath;
        if (this.noPropertiesFileArgument != null && this.noPropertiesFileArgument.isPresent()) {
            return null;
        }
        if (this.filePropertiesPathArgument == null) {
            return null;
        }
        if (this.filePropertiesPathArgument.isPresent()) {
            propertiesFilePath = this.filePropertiesPathArgument.getValue();
        } else {
            String userDir = System.getProperty("user.home");
            propertiesFilePath = this.findPropertiesFile(userDir + File.separator + DEFAULT_OPENDJ_CONFIG_DIR);
        }
        if (propertiesFilePath == null) {
            return null;
        }
        try {
            Properties argumentProperties = new Properties();
            String scriptName = this.getScriptName();
            Properties p = new Properties();
            try (FileInputStream fis = new FileInputStream(propertiesFilePath);){
                p.load(fis);
            }
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String currentPropertyName;
                String propertyName = currentPropertyName = (String)e.nextElement();
                if (scriptName != null) {
                    if (currentPropertyName.startsWith(scriptName)) {
                        propertyName = currentPropertyName.substring(scriptName.length() + 1);
                    } else if (p.containsKey(scriptName + "." + currentPropertyName)) continue;
                }
                argumentProperties.setProperty(propertyName.toLowerCase(), p.getProperty(currentPropertyName));
            }
            return argumentProperties;
        }
        catch (Exception e) {
            LocalizableMessage message = CliMessages.ERR_ARGPARSER_CANNOT_READ_PROPERTIES_FILE.get((Object)propertiesFilePath, (Object)StaticUtils.getExceptionMessage((Throwable)e));
            throw new ArgumentException(message, (Throwable)e);
        }
    }

    public Argument getArgumentForLongID(String longID) {
        return this.longIDMap.get(this.formatLongIdentifier(longID));
    }

    public List<Argument> getArgumentList() {
        return this.argumentList;
    }

    String getMainClassName() {
        return this.mainClassName;
    }

    ArgumentGroup getStandardGroup(Argument argument) {
        if (this.isInputOutputArgument(argument)) {
            return this.ioArgGroup;
        }
        if (this.isGeneralArgument(argument)) {
            return this.generalArgGroup;
        }
        if (this.isLdapConnectionArgument(argument)) {
            return this.ldapArgGroup;
        }
        return this.defaultArgGroup;
    }

    LocalizableMessage getToolDescription() {
        return this.toolDescription;
    }

    @Override
    public LocalizableMessage getShortToolDescription() {
        return this.shortToolDescription != null ? this.shortToolDescription : LocalizableMessage.EMPTY;
    }

    @Override
    public void setShortToolDescription(LocalizableMessage shortDescription) {
        this.shortToolDescription = shortDescription;
    }

    @Override
    public LocalizableMessage getDocToolDescriptionSupplement() {
        this.docToolDescriptionSupplement = this.constructIfNull(this.docToolDescriptionSupplement);
        return this.docToolDescriptionSupplement.getDocDescriptionSupplement();
    }

    @Override
    public void setDocToolDescriptionSupplement(LocalizableMessage supplement) {
        this.docToolDescriptionSupplement = this.constructIfNull(this.docToolDescriptionSupplement);
        this.docToolDescriptionSupplement.setDocDescriptionSupplement(supplement);
    }

    @Override
    public LocalizableMessage getDocSubcommandsDescriptionSupplement() {
        this.docSubcommandsDescriptionSupplement = this.constructIfNull(this.docSubcommandsDescriptionSupplement);
        return this.docSubcommandsDescriptionSupplement.getDocDescriptionSupplement();
    }

    @Override
    public void setDocSubcommandsDescriptionSupplement(LocalizableMessage supplement) {
        this.docSubcommandsDescriptionSupplement = this.constructIfNull(this.docSubcommandsDescriptionSupplement);
        this.docSubcommandsDescriptionSupplement.setDocDescriptionSupplement(supplement);
    }

    private DocSubcommandDescriptionSupplement constructIfNull(DocSubcommandDescriptionSupplement supplement) {
        if (supplement != null) {
            return supplement;
        }
        return new DocSubcommandDescriptionSupplement();
    }

    public ArrayList<String> getTrailingArguments() {
        return this.trailingArguments;
    }

    public String getUsage() {
        StringBuilder buffer = new StringBuilder();
        this.usageOrVersionDisplayed = true;
        if (System.getProperty("org.forgerock.opendj.gendoc") != null) {
            this.toRefEntry(buffer, this.getSynopsisArgs(), this.argumentList);
        } else {
            this.getUsage(buffer);
        }
        return buffer.toString();
    }

    String getSynopsisArgs() {
        if (this.allowsTrailingArguments()) {
            if (this.trailingArgsDisplayName != null) {
                return this.trailingArgsDisplayName;
            }
            return CliMessages.INFO_ARGPARSER_USAGE_TRAILINGARGS.get().toString();
        }
        return null;
    }

    void toRefEntry(StringBuilder builder, String synopsisArgs, List<Argument> argList) {
        String scriptName = this.getScriptName();
        if (scriptName == null) {
            throw new RuntimeException("The script name should have been set via the environment property 'com.forgerock.opendj.ldap.tools.scriptName'.");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("locale", Locale.getDefault().getLanguage());
        map.put("year", new SimpleDateFormat("yyyy").format(new Date()));
        map.put("name", scriptName);
        map.put("shortDesc", this.getShortToolDescription());
        map.put("descTitle", CliMessages.REF_TITLE_DESCRIPTION.get());
        map.put("args", synopsisArgs);
        map.put("description", this.eolToNewPara(this.getToolDescription()));
        map.put("info", this.getDocToolDescriptionSupplement());
        if (!argList.isEmpty()) {
            map.put("optionSection", this.getOptionsRefSect1(scriptName));
        }
        map.put("subcommands", null);
        map.put("trailingSectionString", System.getProperty("org.forgerock.opendj.gendoc.trailing"));
        DocGenerationHelper.applyTemplate(builder, "refEntry.ftl", map);
    }

    String eolToNewPara(LocalizableMessage input) {
        return input.toString().replaceAll(StaticUtils.EOL, "</para><para>");
    }

    protected String getOptionsRefSect1(String scriptName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", scriptName);
        map.put("title", CliMessages.REF_TITLE_OPTIONS.get());
        map.put("intro", CliMessages.REF_INTRO_OPTIONS.get((Object)scriptName));
        Argument helpArgument = null;
        boolean printHeaders = this.printUsageGroupHeaders();
        LinkedList groups = new LinkedList();
        for (ArgumentGroup argGroup : this.argumentGroups) {
            HashMap<String, Object> group = new HashMap<String, Object>();
            if (argGroup.containsArguments() && printHeaders) {
                LocalizableMessage description = argGroup.getDescription();
                if (description != LocalizableMessage.EMPTY) {
                    group.put("description", this.eolToNewPara(description));
                } else {
                    group.put("description", CliMessages.INFO_SUBCMDPARSER_WHERE_OPTIONS_INCLUDE.get());
                }
            }
            LinkedList<Map<String, Object>> options = new LinkedList<Map<String, Object>>();
            SortedSet<Argument> args = this.sortArguments(argGroup.getArguments());
            for (Argument a : args) {
                if (a.isHidden()) continue;
                Map<String, Object> argumentMap = this.getArgumentMap(a);
                if (this.isHostNameArgument(a)) {
                    argumentMap.put("default", CliMessages.REF_DEFAULT.get((Object)"localhost.localdomain"));
                }
                if (a.getLongIdentifier().equals("backendType")) {
                    argumentMap.put("default", CliMessages.REF_DEFAULT_BACKEND_TYPE.get().toString());
                }
                if (this.isUsageArgument(a)) {
                    helpArgument = a;
                    continue;
                }
                options.add(argumentMap);
            }
            group.put("options", options);
            if (options.isEmpty()) continue;
            groups.add(group);
        }
        if (helpArgument != null) {
            HashMap helpGroup = new HashMap();
            helpGroup.put("description", null);
            LinkedList<Map<String, Object>> options = new LinkedList<Map<String, Object>>();
            options.add(this.getArgumentMap(helpArgument));
            helpGroup.put("options", options);
            groups.add(helpGroup);
        }
        map.put("groups", groups);
        StringBuilder sb = new StringBuilder();
        DocGenerationHelper.applyTemplate(sb, "optionsRefSect1.ftl", map);
        return sb.toString();
    }

    boolean isHostNameArgument(Argument a) {
        return HOST_LONG_IDENTIFIERS.contains(a.getLongIdentifier());
    }

    private Map<String, Object> getArgumentMap(Argument a) {
        HashMap<String, Object> option = new HashMap<String, Object>();
        option.put("synopsis", DocGenerationHelper.getOptionSynopsis(a));
        option.put("description", this.eolToNewPara(a.getDescription()));
        String dv = a.getDefaultValue();
        option.put("default", dv != null ? CliMessages.REF_DEFAULT.get((Object)dv) : null);
        option.put("info", a.getDocDescriptionSupplement());
        return option;
    }

    void writeToUsageOutputStream(CharSequence message) {
        try {
            this.usageOutputStream.write(StaticUtils.getBytes((CharSequence)message.toString()));
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
        }
    }

    private void getUsage(StringBuilder buffer) {
        buffer.append((CharSequence)this.getLocalizableScriptName());
        if (this.allowsTrailingArguments) {
            buffer.append(" ");
            if (this.trailingArgsDisplayName != null) {
                buffer.append(this.trailingArgsDisplayName);
            } else {
                buffer.append((CharSequence)CliMessages.INFO_ARGPARSER_USAGE_TRAILINGARGS.get());
            }
        }
        buffer.append(StaticUtils.EOL);
        buffer.append(StaticUtils.EOL);
        if (this.toolDescription != null && this.toolDescription.length() > 0) {
            buffer.append(Utils.wrapText(this.toolDescription.toString(), Utils.MAX_LINE_WIDTH - 1));
            buffer.append(StaticUtils.EOL);
            buffer.append(StaticUtils.EOL);
        }
        buffer.append((CharSequence)CliMessages.INFO_SUBCMDPARSER_WHERE_OPTIONS_INCLUDE.get());
        buffer.append(StaticUtils.EOL);
        buffer.append(StaticUtils.EOL);
        Argument helpArgument = null;
        boolean printHeaders = this.printUsageGroupHeaders();
        for (ArgumentGroup argGroup : this.argumentGroups) {
            LocalizableMessage groupDesc;
            if (argGroup.containsArguments() && printHeaders && (groupDesc = argGroup.getDescription()) != null && !LocalizableMessage.EMPTY.equals((Object)groupDesc)) {
                buffer.append(StaticUtils.EOL);
                buffer.append(Utils.wrapText(groupDesc.toString(), Utils.MAX_LINE_WIDTH - 1));
                buffer.append(StaticUtils.EOL);
                buffer.append(StaticUtils.EOL);
            }
            SortedSet<Argument> args = this.sortArguments(argGroup.getArguments());
            for (Argument a : args) {
                if (a.isHidden()) continue;
                if (this.isUsageArgument(a)) {
                    helpArgument = a;
                    continue;
                }
                this.printArgumentUsage(a, buffer);
            }
        }
        if (helpArgument != null) {
            this.printArgumentUsage(helpArgument, buffer);
        } else {
            buffer.append(StaticUtils.EOL);
            buffer.append("-?");
            buffer.append(StaticUtils.EOL);
        }
    }

    SortedSet<Argument> sortArguments(List<Argument> arguments) {
        TreeSet<Argument> result = new TreeSet<Argument>(new Comparator<Argument>(){

            @Override
            public int compare(Argument o1, Argument o2) {
                String s2;
                String s1 = this.getIdentifier(o1);
                int res = s1.compareToIgnoreCase(s2 = this.getIdentifier(o2));
                if (res != 0) {
                    return res;
                }
                return -s1.compareTo(s2);
            }

            private String getIdentifier(Argument o1) {
                if (o1.getShortIdentifier() != null) {
                    return o1.getShortIdentifier().toString();
                }
                return o1.getLongIdentifier();
            }
        });
        result.addAll(arguments);
        return result;
    }

    String getScriptNameOrJava() {
        String scriptName = this.getScriptName();
        if (scriptName != null && scriptName.length() != 0) {
            return scriptName;
        }
        return "java " + this.getMainClassName();
    }

    LocalizableMessage getLocalizableScriptName() {
        String scriptName = this.getScriptName();
        if (scriptName == null || scriptName.length() == 0) {
            return CliMessages.INFO_ARGPARSER_USAGE_JAVA_CLASSNAME.get((Object)this.mainClassName);
        }
        return CliMessages.INFO_ARGPARSER_USAGE_JAVA_SCRIPTNAME.get((Object)scriptName);
    }

    String getScriptName() {
        String scriptName = System.getProperty(PROPERTY_SCRIPT_NAME);
        if (scriptName != null && scriptName.length() != 0) {
            return scriptName;
        }
        String legacyScriptName = System.getProperty(PROPERTY_SCRIPT_NAME_LEGACY);
        if (legacyScriptName != null && legacyScriptName.length() != 0) {
            return legacyScriptName;
        }
        return null;
    }

    Argument getUsageArgument() {
        return this.usageArgument;
    }

    boolean isUsageArgument(Argument a) {
        return this.usageArgument != null && this.usageArgument.getLongIdentifier().equals(a.getLongIdentifier());
    }

    void printVersion() {
        this.versionPresent = true;
        this.usageOrVersionDisplayed = true;
        this.versionHandler.printVersion();
    }

    public boolean isUsageArgumentPresent() {
        return this.usageArgument != null && this.usageArgument.isPresent();
    }

    public boolean isVersionArgumentPresent() {
        return this.versionPresent;
    }

    boolean longArgumentsCaseSensitive() {
        return this.longArgumentsCaseSensitive;
    }

    public void parseArguments(String[] rawArguments) throws ArgumentException {
        this.parseArguments(rawArguments, null);
    }

    public void parseArguments(String[] rawArguments, Properties argumentProperties) throws ArgumentException {
        boolean inTrailingArgs = false;
        int numArguments = rawArguments.length;
        for (int i = 0; i < numArguments; ++i) {
            String argValue;
            String arg = rawArguments[i];
            if (inTrailingArgs) {
                this.trailingArguments.add(arg);
                if (this.maxTrailingArguments <= 0 || this.trailingArguments.size() <= this.maxTrailingArguments) continue;
                LocalizableMessage message = CliMessages.ERR_ARGPARSER_TOO_MANY_TRAILING_ARGS.get((Object)this.maxTrailingArguments);
                throw new ArgumentException(message);
            }
            if (arg.equals("--")) {
                inTrailingArgs = true;
                continue;
            }
            if (arg.startsWith("--")) {
                String argName = arg.substring(2);
                argValue = null;
                int equalPos = argName.indexOf(61);
                if (equalPos == 0) {
                    throw new ArgumentException(CliMessages.ERR_ARGPARSER_LONG_ARG_WITHOUT_NAME.get((Object)arg));
                }
                if (equalPos > 0) {
                    argValue = argName.substring(equalPos + 1);
                    argName = argName.substring(0, equalPos);
                }
                String origArgName = argName;
                Argument a = this.longIDMap.get(argName = this.formatLongIdentifier(argName));
                if (a == null) {
                    if ("help".equals(argName)) {
                        this.writeToUsageOutputStream(this.getUsage());
                        return;
                    }
                    if ("version".equals(argName)) {
                        this.printVersion();
                        return;
                    }
                    throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_LONG_ID.get((Object)origArgName));
                }
                a.setPresent(true);
                if (this.isUsageArgument(a)) {
                    this.writeToUsageOutputStream(this.getUsage());
                    return;
                }
                if (a.needsValue()) {
                    LocalizableMessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_VALUE_FOR_ARGUMENT_WITH_LONG_ID.get((Object)origArgName));
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new LocalizableMessageBuilder())) {
                        throw new ArgumentException(CliMessages.ERR_ARGPARSER_VALUE_UNACCEPTABLE_FOR_LONG_ID.get((Object)argValue, (Object)origArgName, (Object)invalidReason));
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        throw new ArgumentException(CliMessages.ERR_ARGPARSER_NOT_MULTIVALUED_FOR_LONG_ID.get((Object)origArgName));
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                throw new ArgumentException(CliMessages.ERR_ARGPARSER_ARG_FOR_LONG_ID_DOESNT_TAKE_VALUE.get((Object)origArgName));
            }
            if (arg.startsWith("-")) {
                if (arg.equals("-")) {
                    throw new ArgumentException(CliMessages.ERR_ARGPARSER_INVALID_DASH_AS_ARGUMENT.get());
                }
                char argCharacter = arg.charAt(1);
                argValue = arg.length() > 2 ? arg.substring(2) : null;
                Argument a = this.shortIDMap.get(Character.valueOf(argCharacter));
                if (a == null) {
                    if (argCharacter == '?') {
                        this.writeToUsageOutputStream(this.getUsage());
                        return;
                    }
                    if (this.versionHandler != null && argCharacter == 'V' && !this.shortIDMap.containsKey(Character.valueOf('V'))) {
                        this.printVersion();
                        return;
                    }
                    throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                }
                a.setPresent(true);
                if (this.isUsageArgument(a)) {
                    this.writeToUsageOutputStream(this.getUsage());
                    return;
                }
                if (a.needsValue()) {
                    LocalizableMessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_VALUE_FOR_ARGUMENT_WITH_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new LocalizableMessageBuilder())) {
                        throw new ArgumentException(CliMessages.ERR_ARGPARSER_VALUE_UNACCEPTABLE_FOR_SHORT_ID.get((Object)argValue, (Object)Character.valueOf(argCharacter), (Object)invalidReason));
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        throw new ArgumentException(CliMessages.ERR_ARGPARSER_NOT_MULTIVALUED_FOR_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                int valueLength = argValue.length();
                for (int j = 0; j < valueLength; ++j) {
                    char c = argValue.charAt(j);
                    Argument b = this.shortIDMap.get(Character.valueOf(c));
                    if (b == null) {
                        throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                    }
                    if (b.needsValue()) {
                        throw new ArgumentException(CliMessages.ERR_ARGPARSER_CANT_MIX_ARGS_WITH_VALUES.get((Object)Character.valueOf(argCharacter), (Object)argValue, (Object)Character.valueOf(c)));
                    }
                    b.setPresent(true);
                    if (!this.isUsageArgument(b)) continue;
                    this.writeToUsageOutputStream(this.getUsage());
                    return;
                }
                continue;
            }
            if (this.allowsTrailingArguments) {
                inTrailingArgs = true;
                this.trailingArguments.add(arg);
                continue;
            }
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_DISALLOWED_TRAILING_ARGUMENT.get((Object)arg));
        }
        if (this.allowsTrailingArguments && this.minTrailingArguments > 0 && this.trailingArguments.size() < this.minTrailingArguments) {
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_TOO_FEW_TRAILING_ARGUMENTS.get((Object)this.minTrailingArguments));
        }
        if (argumentProperties == null) {
            argumentProperties = this.checkExternalProperties();
        }
        this.normalizeArguments(argumentProperties, this.argumentList);
    }

    public void parseArguments(String[] rawArguments, String propertiesFile, boolean requirePropertiesFile) throws ArgumentException {
        Properties argumentProperties;
        block14: {
            argumentProperties = null;
            try (FileInputStream fis = new FileInputStream(propertiesFile);){
                Properties p = new Properties();
                p.load(fis);
                argumentProperties = p;
            }
            catch (Exception e) {
                if (!requirePropertiesFile) break block14;
                LocalizableMessage message = CliMessages.ERR_ARGPARSER_CANNOT_READ_PROPERTIES_FILE.get((Object)propertiesFile, (Object)StaticUtils.getExceptionMessage((Throwable)e));
                throw new ArgumentException(message, (Throwable)e);
            }
        }
        this.parseArguments(rawArguments, argumentProperties);
    }

    boolean printUsageGroupHeaders() {
        int groupsContainingArgs = 0;
        for (ArgumentGroup argGroup : this.argumentGroups) {
            if (!argGroup.containsNonHiddenArguments()) continue;
            ++groupsContainingArgs;
        }
        return groupsContainingArgs > 1;
    }

    public void setFilePropertiesArgument(StringArgument argument) {
        this.filePropertiesPathArgument = argument;
    }

    public void setNoPropertiesFileArgument(BooleanArgument argument) {
        this.noPropertiesFileArgument = argument;
    }

    public void setUsageArgument(Argument argument) {
        this.usageArgument = argument;
        this.usageOutputStream = System.out;
    }

    public void setUsageArgument(Argument argument, OutputStream outputStream) {
        this.usageArgument = argument;
        this.usageOutputStream = outputStream;
    }

    public void setUsageOrVersionDisplayed(boolean usageOrVersionDisplayed) {
        this.usageOrVersionDisplayed = usageOrVersionDisplayed;
    }

    public void setVersionHandler(VersionHandler handler) {
        this.versionHandler = handler;
    }

    public boolean usageOrVersionDisplayed() {
        return this.usageOrVersionDisplayed;
    }

    private String findPropertiesFile(String directory) {
        File f = new File(directory, "tools.properties");
        if (f.exists() && f.canRead()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private void initGroups() {
        this.argumentGroups.add(this.defaultArgGroup);
        this.argumentGroups.add(this.ldapArgGroup);
        this.argumentGroups.add(this.generalArgGroup);
        this.argumentGroups.add(this.ioArgGroup);
        try {
            this.versionArgument = this.getVersionArgument(true);
            this.generalArgGroup.addArgument(this.versionArgument);
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    private boolean isGeneralArgument(Argument arg) {
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            return "help".equals(longId) || "version".equals(longId);
        }
        return false;
    }

    private boolean isInputOutputArgument(Argument arg) {
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            return "verbose".equals(longId) || "quiet".equals(longId) || "no-prompt".equals(longId) || "propertiesFilePath".equals(longId) || "noPropertiesFile".equals(longId) || "script-friendly".equals(longId) || "wrapColumn".equals(longId) || "encoding".equals(longId) || "batchFilePath".equals(longId);
        }
        return false;
    }

    private boolean isLdapConnectionArgument(Argument arg) {
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            return "useSSL".equals(longId) || "useStartTLS".equals(longId) || "hostname".equals(longId) || "port".equals(longId) || "bindDN".equals(longId) || "bindPassword".equals(longId) || "bindPasswordFile".equals(longId) || "saslOption".equals(longId) || "trustAll".equals(longId) || "trustStorePath".equals(longId) || "trustStorePassword".equals(longId) || "trustStorePasswordFile".equals(longId) || "keyStorePath".equals(longId) || "keyStorePassword".equals(longId) || "keyStorePasswordFile".equals(longId) || "certNickname".equals(longId) || "referencedHostName".equals(longId) || "adminUID".equals(longId) || "reportAuthzID".equals(longId) || "usePasswordPolicyControl".equals(longId) || "useSASLExternal".equals(longId);
        }
        return false;
    }

    private void printArgumentUsage(Argument a, StringBuilder buffer) {
        this.printLineForShortLongArgument(a, buffer);
        int indentLength = INDENT.length();
        buffer.append(Utils.wrapText(a.getDescription(), Utils.MAX_LINE_WIDTH, indentLength));
        buffer.append(StaticUtils.EOL);
        if (a.needsValue() && a.getDefaultValue() != null && a.getDefaultValue().length() > 0) {
            buffer.append(INDENT);
            buffer.append((CharSequence)CliMessages.INFO_ARGPARSER_USAGE_DEFAULT_VALUE.get((Object)a.getDefaultValue()));
            buffer.append(StaticUtils.EOL);
        }
    }

    void printLineForShortLongArgument(Argument a, StringBuilder buffer) {
        Character shortID = a.getShortIdentifier();
        String longID = a.getLongIdentifier();
        if (shortID != null) {
            if (this.isUsageArgument(a)) {
                buffer.append("-?, ");
            }
            buffer.append("-");
            buffer.append(shortID.charValue());
            if (a.needsValue() && longID == null) {
                buffer.append(" ");
                buffer.append((CharSequence)a.getValuePlaceholder());
            }
            if (longID != null) {
                StringBuilder newBuffer = new StringBuilder();
                newBuffer.append(", --");
                newBuffer.append(longID);
                if (a.needsValue()) {
                    newBuffer.append(" ");
                    newBuffer.append((CharSequence)a.getValuePlaceholder());
                }
                int currentLength = buffer.length();
                int lineLength = buffer.length() - currentLength + newBuffer.length();
                if (lineLength > Utils.MAX_LINE_WIDTH) {
                    buffer.append(StaticUtils.EOL);
                }
                buffer.append((CharSequence)newBuffer);
            }
            buffer.append(StaticUtils.EOL);
        } else if (longID != null) {
            if (this.isUsageArgument(a)) {
                buffer.append("-?, ");
            }
            buffer.append("--");
            buffer.append(longID);
            if (a.needsValue()) {
                buffer.append(" ");
                buffer.append((CharSequence)a.getValuePlaceholder());
            }
            buffer.append(StaticUtils.EOL);
        }
    }

    void normalizeArguments(Properties argumentProperties, List<Argument> arguments) throws ArgumentException {
        for (Argument a : arguments) {
            if (!a.isPresent() && argumentProperties != null) {
                String value = argumentProperties.getProperty(a.getLongIdentifier().toLowerCase());
                LocalizableMessageBuilder invalidReason = new LocalizableMessageBuilder();
                if (value != null) {
                    boolean addValue;
                    boolean bl = addValue = a instanceof BooleanArgument || a.valueIsAcceptable(value, invalidReason);
                    if (addValue) {
                        a.addValue(value);
                        if (a.needsValue()) {
                            a.setPresent(true);
                        }
                        a.valueSetByProperty();
                    }
                }
            }
            if (a.isPresent() || !a.needsValue()) continue;
            if (a.getDefaultValue() != null) {
                a.addValue(a.getDefaultValue());
            }
            if (a.hasValue() || !a.isRequired()) continue;
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_NO_VALUE_FOR_REQUIRED_ARG.get((Object)a.getLongIdentifier()));
        }
    }

    public void displayMessageAndUsageReference(PrintStream printStream, LocalizableMessage message) {
        Utils.printWrappedText(printStream, message);
        printStream.println();
        Utils.printWrappedText(printStream, this.getHelpUsageReference());
    }

    public LocalizableMessage getHelpUsageReference() {
        this.setUsageOrVersionDisplayed(true);
        LocalizableMessageBuilder buffer = new LocalizableMessageBuilder();
        buffer.append(CliMessages.INFO_GLOBAL_HELP_REFERENCE.get((Object)this.getScriptNameOrJava()));
        buffer.append((CharSequence)StaticUtils.EOL);
        return buffer.toMessage();
    }

    public static String getBindPassword(StringArgument clearArg, FileBasedArgument fileArg) {
        if (clearArg.isPresent()) {
            return clearArg.getValue();
        }
        if (fileArg.isPresent()) {
            return fileArg.getValue();
        }
        return null;
    }

    public void replaceArgument(Argument argument) {
        this.replaceArgumentInCollections(this.longIDMap, this.shortIDMap, this.argumentList, argument);
    }

    void replaceArgumentInCollections(Map<String, Argument> longIDToArg, Map<Character, Argument> shortIDToArg, List<Argument> argumentList, Argument argument) {
        String longID = this.formatLongIdentifier(argument.getLongIdentifier());
        if (!longIDToArg.containsKey(longID)) {
            return;
        }
        longIDToArg.put(longID, argument);
        shortIDToArg.put(argument.getShortIdentifier(), argument);
        argumentList.remove(argument);
        argumentList.add(argument);
        for (ArgumentGroup group : this.argumentGroups) {
            if (!group.getArguments().contains(argument)) continue;
            group.removeArgument(argument);
            group.addArgument(argument);
        }
    }

    String formatLongIdentifier(String longIdentifier) {
        return this.longArgumentsCaseSensitive ? longIdentifier : StaticUtils.toLowerCase((String)longIdentifier);
    }

    private class DocSubcommandDescriptionSupplement
    implements DocDescriptionSupplement {
        private LocalizableMessage docDescriptionSupplement;

        private DocSubcommandDescriptionSupplement() {
        }

        @Override
        public LocalizableMessage getDocDescriptionSupplement() {
            return this.docDescriptionSupplement != null ? this.docDescriptionSupplement : LocalizableMessage.EMPTY;
        }

        private void setDocDescriptionSupplement(LocalizableMessage docDescriptionSupplement) {
            this.docDescriptionSupplement = docDescriptionSupplement;
        }
    }
}

