/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils.file;

public enum FileSizeUnit {
    GB{

        @Override
        public long convert(long sourceDuration, FileSizeUnit sourceUnit) {
            return sourceUnit.toGB(sourceDuration);
        }

        @Override
        public long toB(long value) {
            return MB.toB(value) * 1024L;
        }

        @Override
        public long toKB(long value) {
            return MB.toKB(value) * 1024L;
        }

        @Override
        public long toMB(long value) {
            return MB.toMB(value) * 1024L;
        }

        @Override
        public long toGB(long value) {
            return value;
        }
    }
    ,
    MB{

        @Override
        public long convert(long sourceDuration, FileSizeUnit sourceUnit) {
            return sourceUnit.toMB(sourceDuration);
        }

        @Override
        public long toB(long value) {
            return KB.toB(value) * 1024L;
        }

        @Override
        public long toKB(long value) {
            return KB.toKB(value) * 1024L;
        }

        @Override
        public long toMB(long value) {
            return value;
        }

        @Override
        public long toGB(long value) {
            return GB.toGB(value) / 1024L;
        }
    }
    ,
    KB{

        @Override
        public long convert(long sourceDuration, FileSizeUnit sourceUnit) {
            return sourceUnit.toKB(sourceDuration);
        }

        @Override
        public long toB(long value) {
            return B.toB(value) * 1024L;
        }

        @Override
        public long toKB(long value) {
            return value;
        }

        @Override
        public long toMB(long value) {
            return MB.toMB(value) / 1024L;
        }

        @Override
        public long toGB(long value) {
            return MB.toGB(value) / 1024L;
        }
    }
    ,
    B{

        @Override
        public long convert(long sourceDuration, FileSizeUnit sourceUnit) {
            return sourceUnit.toB(sourceDuration);
        }

        @Override
        public long toB(long value) {
            return value;
        }

        @Override
        public long toKB(long value) {
            return KB.toKB(value) / 1024L;
        }

        @Override
        public long toMB(long value) {
            return KB.toMB(value) / 1024L;
        }

        @Override
        public long toGB(long value) {
            return KB.toGB(value) / 1024L;
        }
    };


    public abstract long convert(long var1, FileSizeUnit var3);

    public abstract long toB(long var1);

    public abstract long toKB(long var1);

    public abstract long toMB(long var1);

    public abstract long toGB(long var1);
}

