/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.forgerock.openam.utils.Time;

public final class TimeUtils {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private TimeUtils() {
    }

    public static long toUnixTime(Calendar timestamp) {
        return timestamp.getTimeInMillis() / 1000L;
    }

    public static Calendar fromUnixTime(long unixTime) {
        return TimeUtils.fromUnixTime(unixTime, TimeUnit.SECONDS);
    }

    public static Calendar fromUnixTime(long unixTime, TimeUnit timeUnit) {
        Calendar calendar = Time.getCalendarInstance();
        calendar.setTimeZone(TimeZone.getDefault());
        long millis = timeUnit.toMillis(unixTime);
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static long currentUnixTime() {
        Calendar calendar = Time.getCalendarInstance();
        calendar.setTimeInMillis(Time.currentTimeMillis());
        return TimeUtils.toUnixTime(calendar);
    }
}

